/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.utils.system;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.minecraft.class_11910;
import net.minecraft.class_156;
import net.minecraft.class_310;
import org.lwjgl.glfw.GLFW;
import org.mcaccess.minecraftaccess.mixin.MouseHandlerAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MouseUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MouseUtils.class);
    private static long windowPointer = 0L;

    private MouseUtils() {
    }

    public static void moveAndLeftClick(int x, int y) {
        MouseUtils.move(x, y);
        if (class_156.method_668() == class_156.class_158.field_1133) {
            try {
                TimeUnit.MILLISECONDS.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Key.LEFT.click();
    }

    public static void move(int x, int y) {
        log.debug("Move mouse to x:{} y:{}", (Object)x, (Object)y);
        GLFW.glfwSetCursorPos((long)MouseUtils.getWindowPointer(), (double)x, (double)y);
        MouseUtils.getMouseHandler().invokeOnMove(MouseUtils.getWindowPointer(), x, y);
    }

    public static void move(Coordinates coordinates) {
        MouseUtils.move(coordinates.x(), coordinates.y());
    }

    public static void moveAfterDelay(final int x, final int y, int delayInMillSecs) {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                MouseUtils.move(x, y);
            }
        }, delayInMillSecs);
    }

    public static Coordinates calcRealPositionOfWidget(int x, int y) {
        double scale = class_310.method_1551().method_22683().method_4495();
        int realX = (int)((double)x * scale);
        int realY = (int)((double)y * scale);
        return new Coordinates(realX, realY);
    }

    private static MouseHandlerAccessor getMouseHandler() {
        return (MouseHandlerAccessor)class_310.method_1551().field_1729;
    }

    private static long getWindowPointer() {
        if (windowPointer == 0L) {
            windowPointer = class_310.method_1551().method_22683().method_4490();
        }
        return windowPointer;
    }

    public static enum Key {
        LEFT(0),
        RIGHT(1),
        MIDDLE(2);

        public final int id;

        private Key(int buttonId) {
            this.id = buttonId;
        }

        public void click() {
            log.debug("Mouse {} clicked", (Object)this);
            this.press();
            this.release();
        }

        public void press() {
            Key.operate(this, 1);
        }

        public void release() {
            Key.operate(this, 0);
        }

        private static void operate(Key key, int action) {
            int modifiers = class_310.method_1551().method_74187() ? 1 : 0;
            class_11910 mouseButtonInfo = new class_11910(key.id, modifiers);
            MouseUtils.getMouseHandler().invokeOnButton(MouseUtils.getWindowPointer(), mouseButtonInfo, action);
        }
    }

    public record Coordinates(int x, int y) {
    }

    public static enum Wheel {
        UP,
        DOWN;


        public void scroll() {
            log.debug("Mouse {} scrolled", (Object)this);
            int offset = this == UP ? 1 : -1;
            MouseUtils.getMouseHandler().invokeOnScroll(MouseUtils.getWindowPointer(), 0.0, offset);
        }
    }
}

