/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.mcaccess.minecraftaccess.utils.UnzipUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoLibrarySetup {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoLibrarySetup.class);

    public void initialize() {
        try {
            if (this.checkInstalled()) {
                return;
            }
            this.downloadAndInstall();
        }
        catch (IOException e) {
            log.error("An error occurred while downloading library.", (Throwable)e);
        }
    }

    private void downloadAndInstall() throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            log.info("Downloading latest tolk build...");
            File tolkLatestBuildZip = new File(Paths.get("tolk-latest-build.zip", new String[0]).toAbsolutePath().toString());
            FileUtils.copyURLToFile((URL)URI.create("https://github.com/ndarilek/tolk/releases/download/refs%2Fheads%2Fmaster/tolk.zip").toURL(), (File)tolkLatestBuildZip);
            UnzipUtility unzipUtility = new UnzipUtility();
            File tempDirectoryPath = Paths.get("temp-tolk-latest", new String[0]).toAbsolutePath().toFile();
            unzipUtility.unzip(tolkLatestBuildZip.getAbsolutePath(), tempDirectoryPath.getAbsolutePath());
            log.info("Moving files...");
            String sourceDir = "x64";
            if (SystemUtils.OS_ARCH.equalsIgnoreCase("X86")) {
                sourceDir = "x86";
            }
            FileUtils.copyDirectory((File)Paths.get(tempDirectoryPath.getAbsolutePath(), sourceDir).toFile(), (File)tempDirectoryPath.getParentFile());
            log.info("Deleting temp files...");
            FileUtils.delete((File)tolkLatestBuildZip);
            FileUtils.deleteDirectory((File)tempDirectoryPath);
            log.info("tolk library downloaded and installed.");
        } else if (SystemUtils.IS_OS_LINUX) {
            log.info("Downloading libspeechdwrapper.so ...");
            FileUtils.copyURLToFile((URL)URI.create("https://github.com/khanshoaib3/libspeechdwrapper/releases/download/v1.0.0/libspeechdwrapper.so").toURL(), (File)new File(Paths.get("libspeechdwrapper.so", new String[0]).toAbsolutePath().toString()));
            log.info("libspeechdwrapper.so downloaded and installed.");
        }
    }

    private boolean checkInstalled() {
        log.info("Checking for installed files...");
        for (String libraryName : this.getRequiredLibraryNames()) {
            log.debug("Checking for {}", (Object)libraryName);
            if (Files.exists(Paths.get(libraryName, new String[0]).toAbsolutePath(), new LinkOption[0])) continue;
            log.error("{} file not found.", (Object)libraryName);
            return false;
        }
        log.info("All files are installed.");
        return true;
    }

    private List<String> getRequiredLibraryNames() {
        ArrayList<String> requiredFiles = new ArrayList<String>();
        if (SystemUtils.IS_OS_WINDOWS) {
            requiredFiles.add("Tolk.dll");
            if (SystemUtils.OS_ARCH.equalsIgnoreCase("X86")) {
                requiredFiles.add("nvdaControllerClient32.dll");
                requiredFiles.add("SAAPI32.dll");
                requiredFiles.add("dolapi32.dll");
            } else {
                requiredFiles.add("nvdaControllerClient64.dll");
                requiredFiles.add("SAAPI64.dll");
            }
        } else if (SystemUtils.IS_OS_LINUX) {
            requiredFiles.add("libspeechdwrapper.so");
        }
        return requiredFiles;
    }
}

