/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features;

import lombok.Generated;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_2183;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;
import org.mcaccess.minecraftaccess.utils.condition.DoubleClick;
import org.mcaccess.minecraftaccess.utils.condition.Interval;
import org.mcaccess.minecraftaccess.utils.position.Orientation;
import org.mcaccess.minecraftaccess.utils.position.PlayerPositionUtils;
import org.mcaccess.minecraftaccess.utils.system.KeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CameraControls {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CameraControls.class);
    private static final class_310 CLIENT = class_310.method_1551();
    private static CameraConfig config;
    private static final Interval INTERVAL;
    private static final DoubleClick straightUpDoubleClick;
    private static final DoubleClick straightDownDoubleClick;

    private CameraControls() {
    }

    public static void tick() {
        if (!INTERVAL.isReady()) {
            return;
        }
        CameraControls.loadConfigurations();
        CameraControls.keyListener();
    }

    private static void loadConfigurations() {
        Config.CameraControls config = Config.getInstance().cameraControls;
        CameraControls.config = new CameraConfig(config);
        INTERVAL.setDelay(config.delayMilliseconds, Interval.Unit.MILLISECOND);
    }

    private static void keyListener() {
        float rotateAngle;
        boolean isLeftAltPressed = KeyUtils.isLeftAltPressed();
        boolean isRightAltPressed = KeyUtils.isRightAltPressed();
        boolean isUpKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.CAMERA_CONTROLS_UP.mapping, KeyBindingsHandler.Keys.CAMERA_CONTROLS_ALTERNATE_UP.mapping);
        boolean isRightKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.CAMERA_CONTROLS_RIGHT.mapping, KeyBindingsHandler.Keys.CAMERA_CONTROLS_ALTERNATE_RIGHT.mapping);
        boolean isDownKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.CAMERA_CONTROLS_DOWN.mapping, KeyBindingsHandler.Keys.CAMERA_CONTROLS_ALTERNATE_DOWN.mapping);
        boolean isLeftKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.CAMERA_CONTROLS_LEFT.mapping, KeyBindingsHandler.Keys.CAMERA_CONTROLS_ALTERNATE_LEFT.mapping);
        boolean isNorthKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.CAMERA_CONTROLS_NORTH.mapping) || isUpKeyPressed && isRightAltPressed && !isLeftAltPressed;
        boolean isEastKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.CAMERA_CONTROLS_EAST.mapping) || isRightKeyPressed && isRightAltPressed && !isLeftAltPressed;
        boolean isWestKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.CAMERA_CONTROLS_WEST.mapping) || isLeftKeyPressed && isRightAltPressed && !isLeftAltPressed;
        boolean isSouthKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.CAMERA_CONTROLS_SOUTH.mapping) || isDownKeyPressed && isRightAltPressed && !isLeftAltPressed;
        boolean isCenterCameraKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.CAMERA_CONTROLS_CENTER_CAMERA.mapping);
        boolean isStraightUpKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.CAMERA_CONTROLS_STRAIGHT_UP.mapping);
        boolean isUpKeyDoublePressedWithRightAlt = isRightAltPressed && straightUpDoubleClick.canBeTriggered();
        boolean isStraightDownKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.CAMERA_CONTROLS_STRAIGHT_DOWN.mapping);
        boolean isDownKeyDoublePressedWithRightAlt = isRightAltPressed && straightDownDoubleClick.canBeTriggered();
        boolean anyFunctionTriggered = false;
        if (isStraightUpKeyPressed || isUpKeyDoublePressedWithRightAlt) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraTo(Orientation.UP);
        }
        if (isStraightDownKeyPressed || isDownKeyDoublePressedWithRightAlt) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraTo(Orientation.DOWN);
        }
        if (isNorthKeyPressed) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraTo(Orientation.NORTH);
        }
        if (isEastKeyPressed) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraTo(Orientation.EAST);
        }
        if (isWestKeyPressed) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraTo(Orientation.WEST);
        }
        if (isSouthKeyPressed) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraTo(Orientation.SOUTH);
        }
        float f = rotateAngle = isLeftAltPressed ? CameraControls.config.modifiedRotatingAngle : CameraControls.config.normalRotatingAngle;
        if (isUpKeyPressed && !isRightAltPressed) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraBy(rotateAngle, RotatingDirection.UP);
        }
        if (isRightKeyPressed && !isRightAltPressed) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraBy(rotateAngle, RotatingDirection.RIGHT);
        }
        if (isDownKeyPressed && !isRightAltPressed) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraBy(rotateAngle, RotatingDirection.DOWN);
        }
        if (isLeftKeyPressed && !isRightAltPressed) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraBy(rotateAngle, RotatingDirection.LEFT);
        }
        if (isCenterCameraKeyPressed) {
            anyFunctionTriggered = true;
            CameraControls.centerCamera(isLeftAltPressed);
        }
        INTERVAL.adjustNextReadyTimeBy(anyFunctionTriggered);
    }

    private static void rotateCameraBy(float angle, RotatingDirection direction) {
        if (CameraControls.handleLocking()) {
            return;
        }
        float horizontalAngleDelta = angle * (float)direction.horizontalWight;
        float verticalAngleDelta = angle * (float)direction.verticalWight;
        log.debug("Rotating camera by x:{} y:{}", (Object)Float.valueOf(horizontalAngleDelta), (Object)Float.valueOf(verticalAngleDelta));
        assert (CameraControls.CLIENT.field_1724 != null);
        CameraControls.CLIENT.field_1724.method_5872((double)horizontalAngleDelta, (double)verticalAngleDelta);
        String horizontalDirection = PlayerPositionUtils.getHorizontalFacingDirectionInWords();
        String verticalDirection = PlayerPositionUtils.getVerticalFacingDirectionInWords();
        if (Config.getInstance().features.facingDirectionEnabled) {
            if (direction.isRotatingHorizontal) {
                MainClass.narrate(horizontalDirection, true);
            } else if (verticalDirection != null) {
                MainClass.narrate(verticalDirection, true);
            }
        }
    }

    private static void rotateCameraTo(Orientation direction) {
        if (CameraControls.handleLocking()) {
            return;
        }
        class_746 player = CameraControls.CLIENT.field_1724;
        assert (player != null);
        class_243 playerBlockPosition = player.method_73189();
        class_243 targetBlockPosition = playerBlockPosition.method_1019(class_243.method_24954((class_2382)direction.vector));
        player.method_5702(class_2183.class_2184.field_9853, targetBlockPosition);
        log.debug("Rotating camera to: {}", (Object)direction.name());
        if (Config.getInstance().features.facingDirectionEnabled) {
            if (direction.in(Orientation.Layer.MIDDLE)) {
                MainClass.narrate(PlayerPositionUtils.getHorizontalFacingDirectionInWords(), true);
            } else {
                MainClass.narrate(PlayerPositionUtils.getVerticalFacingDirectionInWords(), true);
            }
        }
    }

    private static void centerCamera(boolean lookOpposite) {
        if (CameraControls.handleLocking()) {
            return;
        }
        Orientation o = PlayerPositionUtils.getHorizontalFacing();
        CameraControls.rotateCameraTo(lookOpposite ? o.getOpposite() : o);
    }

    private static boolean handleLocking() {
        if (!MainClass.poiManager.lockingHandler.isPlayerLocked() && CLIENT.method_1560().method_5779((class_1297)CameraControls.CLIENT.field_1724)) {
            return false;
        }
        MainClass.narrate(class_1074.method_4662((String)"minecraft_access.other.camera_locked", (Object[])new Object[0]), true);
        return true;
    }

    static {
        INTERVAL = Interval.defaultDelay();
        straightUpDoubleClick = new DoubleClick(() -> KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.CAMERA_CONTROLS_UP.mapping));
        straightDownDoubleClick = new DoubleClick(() -> KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.CAMERA_CONTROLS_DOWN.mapping));
    }

    private record CameraConfig(float normalRotatingAngle, float modifiedRotatingAngle) {
        static final float DELTA_90_DEGREES = 600.0f;

        private CameraConfig(Config.CameraControls config) {
            this(600.0f / (90.0f / config.normalRotatingAngle), 600.0f / (90.0f / config.modifiedRotatingAngle));
        }
    }

    private static enum RotatingDirection {
        UP(0, -1),
        DOWN(0, 1),
        LEFT(-1, 0),
        RIGHT(1, 0);

        final int horizontalWight;
        final int verticalWight;
        final boolean isRotatingHorizontal;

        private RotatingDirection(int horizontalWight, int verticalWight) {
            this.horizontalWight = horizontalWight;
            this.verticalWight = verticalWight;
            this.isRotatingHorizontal = horizontalWight != 0;
        }
    }
}

