/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features;

import lombok.Generated;
import net.minecraft.class_1074;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_746;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerWarnings {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlayerWarnings.class);
    private final class_310 client = class_310.method_1551();
    private class_746 player;
    private boolean isHealthBelowFirstThreshold;
    private boolean isHealthBelowSecondThreshold;
    private boolean isFoodBelowThreshold;
    private boolean isAirBelowThreshold;
    private boolean isFrostAboveThreshold;
    private DurabilityWarningStatus lastMainHandStatus = DurabilityWarningStatus.NONE;
    private DurabilityWarningStatus lastOffHandStatus = DurabilityWarningStatus.NONE;
    private DurabilityWarningStatus lastHeadStatus = DurabilityWarningStatus.NONE;
    private DurabilityWarningStatus lastChestStatus = DurabilityWarningStatus.NONE;
    private DurabilityWarningStatus lastLegsStatus = DurabilityWarningStatus.NONE;
    private DurabilityWarningStatus lastFeetStatus = DurabilityWarningStatus.NONE;
    private static final Config.PlayerWarnings CONFIG = Config.getInstance().playerWarnings;

    public void tick() {
        this.player = this.client.field_1724;
        this.healthWarning();
        this.hungerWarning();
        this.airWarning();
        this.frostWarning();
    }

    private void healthWarning() {
        double health = this.player.method_6032() / 2.0f;
        double maxHealth = (double)Math.round((double)this.player.method_6063() / 2.0 * 10.0) / 10.0;
        if (health <= PlayerWarnings.CONFIG.firstHealthThreshold && health > PlayerWarnings.CONFIG.secondHealthThreshold && !this.isHealthBelowFirstThreshold && !this.isHealthBelowSecondThreshold) {
            this.isHealthBelowFirstThreshold = true;
            MainClass.narrate(class_1074.method_4662((String)"minecraft_access.player_warnings.health_low", (Object[])new Object[]{NarrationUtils.narrateNumber(health), NarrationUtils.narrateNumber(maxHealth)}), true);
            this.playWarningSound(false);
        }
        if (health <= PlayerWarnings.CONFIG.secondHealthThreshold && health > 0.0 && this.isHealthBelowFirstThreshold && !this.isHealthBelowSecondThreshold) {
            this.isHealthBelowSecondThreshold = true;
            MainClass.narrate(class_1074.method_4662((String)"minecraft_access.player_warnings.health_low", (Object[])new Object[]{NarrationUtils.narrateNumber(health), NarrationUtils.narrateNumber(maxHealth)}), true);
            this.playWarningSound(true);
        }
        if (this.isHealthBelowFirstThreshold && health > PlayerWarnings.CONFIG.firstHealthThreshold) {
            this.isHealthBelowFirstThreshold = false;
        }
        if (this.isHealthBelowSecondThreshold && health > PlayerWarnings.CONFIG.secondHealthThreshold) {
            this.isHealthBelowSecondThreshold = false;
        }
    }

    private void hungerWarning() {
        double hunger = this.player.method_7344().method_7586() / 2;
        double maxHunger = (double)Math.round(100.0) / 10.0;
        if (hunger <= PlayerWarnings.CONFIG.hungerThreshold && hunger > 0.0 && !this.isFoodBelowThreshold) {
            this.isFoodBelowThreshold = true;
            MainClass.narrate(class_1074.method_4662((String)"minecraft_access.player_warnings.hunger_low", (Object[])new Object[]{NarrationUtils.narrateNumber(hunger), NarrationUtils.narrateNumber(maxHunger)}), true);
            this.playWarningSound(false);
        }
        if (this.isFoodBelowThreshold && hunger > PlayerWarnings.CONFIG.hungerThreshold) {
            this.isFoodBelowThreshold = false;
        }
    }

    private void airWarning() {
        double air = Math.max((double)this.player.method_5669() / 20.0, 0.0);
        double maxAir = (double)Math.round((double)this.player.method_5748() / 20.0 * 10.0) / 10.0;
        if (air <= PlayerWarnings.CONFIG.airThreshold && air > 0.0 && !this.isAirBelowThreshold) {
            this.isAirBelowThreshold = true;
            MainClass.narrate(class_1074.method_4662((String)"minecraft_access.player_warnings.air_low", (Object[])new Object[]{NarrationUtils.narrateNumber(air), NarrationUtils.narrateNumber(maxAir)}), true);
            this.playWarningSound(false);
        }
        if (this.isAirBelowThreshold && air > PlayerWarnings.CONFIG.airThreshold) {
            this.isAirBelowThreshold = false;
        }
    }

    private void frostWarning() {
        double frostExposurePercent = (double)Math.round((double)this.player.method_32313() * 100.0 * 10.0) / 10.0;
        if (frostExposurePercent >= PlayerWarnings.CONFIG.frostThreshold && frostExposurePercent < 100.0 && !this.isFrostAboveThreshold) {
            this.isFrostAboveThreshold = true;
            MainClass.narrate(class_1074.method_4662((String)"minecraft_access.player_warnings.frost_low", (Object[])new Object[]{NarrationUtils.narrateNumber(frostExposurePercent)}), true);
            this.playWarningSound(false);
        }
        if (this.isFrostAboveThreshold && frostExposurePercent < PlayerWarnings.CONFIG.frostThreshold) {
            this.isFrostAboveThreshold = false;
        }
    }

    private void playWarningSound(boolean severe) {
        if (PlayerWarnings.CONFIG.playSound) {
            class_3414 soundToPlay = severe ? class_3417.field_14785 : (class_3414)class_3417.field_23117.comp_349();
            this.player.method_17356(soundToPlay, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    private void playWarningSound(DurabilityWarningStatus status) {
        this.playWarningSound(status.ordinal() > DurabilityWarningStatus.FIRST.ordinal());
    }

    public void durabilityWarnings() {
        if (this.player == null) {
            return;
        }
        if (PlayerWarnings.CONFIG.durabilityWarnings.enableHeldItems) {
            DurabilityWarningStatus mainHandStatus = this.checkDurabilityLevel(this.player.method_6047());
            DurabilityWarningStatus offHandStatus = this.checkDurabilityLevel(this.player.method_6079());
            if (mainHandStatus.ordinal() > this.lastMainHandStatus.ordinal()) {
                this.narrateDurability(this.player.method_6047());
                this.playWarningSound(mainHandStatus);
            }
            if (offHandStatus.ordinal() > this.lastOffHandStatus.ordinal()) {
                this.narrateDurability(this.player.method_6079());
                this.playWarningSound(offHandStatus);
            }
            this.lastMainHandStatus = mainHandStatus;
            this.lastOffHandStatus = offHandStatus;
        }
        if (PlayerWarnings.CONFIG.durabilityWarnings.enableWornArmor) {
            class_1661 inventory = this.player.method_31548();
            DurabilityWarningStatus headStatus = this.checkDurabilityLevel(inventory.method_5438(36));
            DurabilityWarningStatus chestStatus = this.checkDurabilityLevel(inventory.method_5438(37));
            DurabilityWarningStatus legsStatus = this.checkDurabilityLevel(inventory.method_5438(38));
            DurabilityWarningStatus feetStatus = this.checkDurabilityLevel(inventory.method_5438(39));
            if (headStatus.ordinal() > this.lastHeadStatus.ordinal()) {
                this.narrateDurability(inventory.method_5438(36));
                this.playWarningSound(headStatus);
            }
            if (chestStatus.ordinal() > this.lastChestStatus.ordinal()) {
                this.narrateDurability(inventory.method_5438(37));
                this.playWarningSound(chestStatus);
            }
            if (legsStatus.ordinal() > this.lastLegsStatus.ordinal()) {
                this.narrateDurability(inventory.method_5438(38));
                this.playWarningSound(legsStatus);
            }
            if (feetStatus.ordinal() > this.lastFeetStatus.ordinal()) {
                this.narrateDurability(inventory.method_5438(39));
                this.playWarningSound(feetStatus);
            }
            this.lastHeadStatus = headStatus;
            this.lastChestStatus = chestStatus;
            this.lastLegsStatus = legsStatus;
            this.lastFeetStatus = feetStatus;
        }
    }

    private DurabilityWarningStatus checkDurabilityLevel(class_1799 itemStack) {
        if (itemStack == null || !itemStack.method_7963() || !itemStack.method_7986()) {
            return DurabilityWarningStatus.NONE;
        }
        int durability = itemStack.method_7936() - itemStack.method_7919();
        if (itemStack.method_63692()) {
            return DurabilityWarningStatus.NEXT_WILL_BREAK;
        }
        if (durability <= PlayerWarnings.CONFIG.durabilityWarnings.secondThreshold) {
            return DurabilityWarningStatus.SECOND;
        }
        if (durability <= PlayerWarnings.CONFIG.durabilityWarnings.firstThreshold) {
            return DurabilityWarningStatus.FIRST;
        }
        return DurabilityWarningStatus.NONE;
    }

    private void narrateDurability(class_1799 item) {
        String itemName = item.method_63693().getString();
        int maxDamage = item.method_7936();
        int durability = maxDamage - item.method_7919();
        MainClass.narrate(class_1074.method_4662((String)"minecraft_access.player_warnings.durability_warning", (Object[])new Object[]{itemName, durability, maxDamage}), false);
    }

    private static enum DurabilityWarningStatus {
        NONE,
        FIRST,
        SECOND,
        NEXT_WILL_BREAK;

    }
}

