/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.access_menu;

import java.util.Arrays;
import java.util.stream.Stream;
import lombok.Generated;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5289;
import net.minecraft.class_6880;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.features.access_menu.AccessMenuGUI;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderController;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.mcaccess.minecraftaccess.utils.PlayerUtils;
import org.mcaccess.minecraftaccess.utils.condition.Interval;
import org.mcaccess.minecraftaccess.utils.condition.IntervalKeystroke;
import org.mcaccess.minecraftaccess.utils.condition.MenuKeystroke;
import org.mcaccess.minecraftaccess.utils.system.KeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessMenu {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccessMenu.class);
    private static final class_310 CLIENT = class_310.method_1551();
    public static final double RAY_CAST_DISTANCE = 20.0;
    private static final MenuKeystroke MENU_KEY = new MenuKeystroke(KeyBindingsHandler.Keys.ACCESS_MENU_KEY.mapping);
    private boolean gameModeSwitcherActive = false;
    private static final Interval[] FUNCTION_INTERVALS = new Interval[10];
    private static final MenuFunction[] FUNCTIONS = new MenuFunction[]{new MenuFunction(0, new IntervalKeystroke(KeyBindingsHandler.Keys.OPEN_CONFIG_MENU.mapping), () -> class_310.method_1551().method_1507((class_437)AutoConfig.getConfigScreen(Config.class, null).get())), new MenuFunction(1, new IntervalKeystroke(KeyBindingsHandler.Keys.NARRATE_TARGET.mapping), AccessMenu::getBlockAndFluidTargetInformation), new MenuFunction(2, new IntervalKeystroke(KeyBindingsHandler.Keys.TARGET_POSITION.mapping), AccessMenu::getBlockAndFluidTargetPosition), new MenuFunction(3, new IntervalKeystroke(KeyBindingsHandler.Keys.LIGHT_LEVEL.mapping), AccessMenu::getLightLevel), new MenuFunction(4, new IntervalKeystroke(KeyBindingsHandler.Keys.CLOSEST_WATER_SOURCE.mapping), () -> MainClass.fluidDetector.findClosestWaterSource(true)), new MenuFunction(5, new IntervalKeystroke(KeyBindingsHandler.Keys.CLOSEST_LAVA_SOURCE.mapping), () -> MainClass.fluidDetector.findClosestLavaSource(true)), new MenuFunction(6, new IntervalKeystroke(KeyBindingsHandler.Keys.CURRENT_BIOME.mapping), AccessMenu::getBiome), new MenuFunction(7, new IntervalKeystroke(KeyBindingsHandler.Keys.TIME_OF_DAY.mapping), AccessMenu::getTimeOfDay), new MenuFunction(8, new IntervalKeystroke(KeyBindingsHandler.Keys.XP_LEVEL.mapping), AccessMenu::getXP), new MenuFunction(9, new IntervalKeystroke(KeyBindingsHandler.Keys.REFRESH_SCREEN_READER.mapping), () -> ScreenReaderController.refreshScreenReader(true))};

    public void tick() {
        if (AccessMenu.CLIENT.field_1724 == null) {
            return;
        }
        if (AccessMenu.CLIENT.field_1755 == null) {
            if (class_310.method_1551().method_74189()) {
                AccessMenu.handleInMenuActions();
                return;
            }
            for (MenuFunction function : FUNCTIONS) {
                if (!function.keystroke.canBeTriggered()) continue;
                function.func.run();
                return;
            }
            if (MENU_KEY.canOpenMenu() && !this.gameModeSwitcherActive) {
                CLIENT.method_1507((class_437)new AccessMenuGUI());
            }
        } else if (AccessMenu.CLIENT.field_1755 instanceof AccessMenuGUI) {
            if (MENU_KEY.closeMenuIfMenuKeyPressing()) {
                return;
            }
            AccessMenu.handleInMenuActions();
        }
        if (AccessMenu.CLIENT.field_1755 instanceof class_5289) {
            this.gameModeSwitcherActive = true;
        } else if (!KeyUtils.isAnyPressed(293)) {
            this.gameModeSwitcherActive = false;
        }
    }

    private static void handleInMenuActions() {
        class_1041 window = CLIENT.method_22683();
        Stream.of(FUNCTIONS).filter(f -> class_3675.method_15987((class_1041)window, (int)(f.number + 48))).findFirst().ifPresent(f -> {
            if (FUNCTION_INTERVALS[f.number].isReady()) {
                f.func().run();
            }
        });
    }

    public static void getBlockAndFluidTargetInformation() {
        class_239 hit = PlayerUtils.crosshairTarget(20.0);
        if (hit == null) {
            return;
        }
        switch (hit.method_17783()) {
            case field_1333: 
            case field_1331: {
                MainClass.narrate(class_1074.method_4662((String)"minecraft_access.access_menu.target_missed", (Object[])new Object[0]), true);
                break;
            }
            case field_1332: {
                class_3965 blockHit = (class_3965)hit;
                class_2338 blockPos = blockHit.method_17777();
                String narration = NarrationUtils.narrateBlock(blockPos, "") + ", " + NarrationUtils.narrateRelativePositionOfPlayerAnd(blockPos);
                MainClass.narrate(narration, true);
            }
        }
    }

    public static void getBlockAndFluidTargetPosition() {
        class_239 hit = PlayerUtils.crosshairTarget(20.0);
        if (hit == null) {
            return;
        }
        switch (hit.method_17783()) {
            case field_1333: 
            case field_1331: {
                MainClass.narrate(class_1074.method_4662((String)"minecraft_access.access_menu.target_missed", (Object[])new Object[0]), true);
                break;
            }
            case field_1332: {
                class_3965 blockHitResult = (class_3965)hit;
                class_2338 blockPos = blockHitResult.method_17777();
                MainClass.narrate(NarrationUtils.narrateCoordinatesOf(blockPos), true);
            }
        }
    }

    public static void getLightLevel() {
        if (AccessMenu.CLIENT.field_1724 == null) {
            return;
        }
        if (AccessMenu.CLIENT.field_1687 == null) {
            return;
        }
        AccessMenu.CLIENT.field_1724.method_3137();
        int light = AccessMenu.CLIENT.field_1687.method_22339(AccessMenu.CLIENT.field_1724.method_24515());
        MainClass.narrate(class_1074.method_4662((String)"minecraft_access.access_menu.light_level", (Object[])new Object[]{NarrationUtils.narrateNumber(light)}), true);
    }

    public static void getBiome() {
        if (AccessMenu.CLIENT.field_1724 == null) {
            return;
        }
        if (AccessMenu.CLIENT.field_1687 == null) {
            return;
        }
        AccessMenu.CLIENT.field_1724.method_3137();
        class_6880 currentBiome = AccessMenu.CLIENT.field_1687.method_23753(AccessMenu.CLIENT.field_1724.method_24515());
        NarrationUtils.getTranslatedName(currentBiome, "biome").ifPresent(name -> MainClass.narrate(class_1074.method_4662((String)"minecraft_access.access_menu.biome", (Object[])new Object[]{name}), true));
    }

    public static void getXP() {
        if (AccessMenu.CLIENT.field_1724 == null) {
            return;
        }
        AccessMenu.CLIENT.field_1724.method_3137();
        assert (AccessMenu.CLIENT.field_1761 != null);
        if (AccessMenu.CLIENT.field_1761.method_2920() == class_1934.field_9219) {
            MainClass.narrate(class_1074.method_4662((String)"gameMode.spectator", (Object[])new Object[0]), true);
            return;
        }
        if (AccessMenu.CLIENT.field_1761.method_2920() == class_1934.field_9220) {
            MainClass.narrate(class_1074.method_4662((String)"gameMode.creative", (Object[])new Object[0]), true);
            return;
        }
        MainClass.narrate(class_1074.method_4662((String)"minecraft_access.access_menu.xp", (Object[])new Object[]{NarrationUtils.narrateNumber(AccessMenu.CLIENT.field_1724.field_7520), NarrationUtils.narrateNumber(AccessMenu.CLIENT.field_1724.field_7510 * 100.0f)}), true);
    }

    public static void getTimeOfDay() {
        if (AccessMenu.CLIENT.field_1724 == null) {
            return;
        }
        if (AccessMenu.CLIENT.field_1687 == null) {
            return;
        }
        AccessMenu.CLIENT.field_1724.method_3137();
        long daytime = AccessMenu.CLIENT.field_1724.method_73183().method_8532() + 6000L;
        int hours = (int)(daytime / 1000L) % 24;
        int minutes = (int)(daytime % 1000L * 60L / 1000L);
        StringBuilder translationKey = new StringBuilder("minecraft_access.access_menu.time_of_day");
        if (Config.getInstance().use12HourTimeFormat) {
            if (hours == 0) {
                hours = 12;
                translationKey.append("_am");
            } else if (hours > 12) {
                hours -= 12;
                translationKey.append("_pm");
            } else if (hours == 12) {
                translationKey.append("_pm");
            } else {
                translationKey.append("_am");
            }
        }
        String narration = class_1074.method_4662((String)translationKey.toString(), (Object[])new Object[]{String.format("%02d:%02d", hours, minutes)});
        MainClass.narrate(narration, true);
    }

    static {
        Arrays.fill(FUNCTION_INTERVALS, Interval.sec(1L));
        for (int i = 0; i < 10; ++i) {
            AccessMenu.FUNCTIONS[i].keystroke.interval = FUNCTION_INTERVALS[i];
        }
        AccessMenu.FUNCTION_INTERVALS[4] = Interval.ms(0L);
        AccessMenu.FUNCTION_INTERVALS[5] = Interval.ms(0L);
    }

    private record MenuFunction(int number, IntervalKeystroke keystroke, Runnable func) {
    }
}

