/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.inventory_controls;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_10260;
import net.minecraft.class_10287;
import net.minecraft.class_10331;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_361;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_471;
import net.minecraft.class_479;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_507;
import net.minecraft.class_7706;
import net.minecraft.class_9334;
import net.minecraft.class_9792;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.features.inventory_controls.GroupGenerator;
import org.mcaccess.minecraftaccess.features.inventory_controls.SlotItem;
import org.mcaccess.minecraftaccess.features.inventory_controls.SlotsGroup;
import org.mcaccess.minecraftaccess.mixin.AbstractContainerScreenAccessor;
import org.mcaccess.minecraftaccess.mixin.AbstractRecipeBookScreenAccessor;
import org.mcaccess.minecraftaccess.mixin.AnvilScreenAccessor;
import org.mcaccess.minecraftaccess.mixin.CreativeModeInventoryScreenAccessor;
import org.mcaccess.minecraftaccess.mixin.EditBoxAccessor;
import org.mcaccess.minecraftaccess.mixin.RecipeBookComponentAccessor;
import org.mcaccess.minecraftaccess.mixin.RecipeBookPageAccessor;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;
import org.mcaccess.minecraftaccess.utils.condition.Interval;
import org.mcaccess.minecraftaccess.utils.system.KeyUtils;
import org.mcaccess.minecraftaccess.utils.system.MouseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryControls {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryControls.class);
    private Config.InventoryControls config;
    private final Interval interval = Interval.defaultDelay();
    private final class_310 client = class_310.method_1551();
    private AbstractContainerScreenAccessor previousScreen = null;
    private AbstractContainerScreenAccessor currentScreen = null;
    private List<SlotsGroup> currentSlotsGroupList = null;
    private SlotsGroup currentGroup = null;
    private int currentGroupIndex = 0;
    private SlotItem currentSlotItem = null;
    private class_507<?> currentRecipeBookWidget = null;
    private String previousSlotText = "";

    public InventoryControls() {
        this.loadConfig();
    }

    public String getRowAndColumnFormat() {
        return this.config.rowAndColumnFormat;
    }

    public void tick() {
        String slotNarrationText;
        if (!this.interval.isReady()) {
            return;
        }
        if (this.client.field_1724 == null) {
            return;
        }
        if (this.client.field_1755 == null) {
            this.previousScreen = null;
            this.currentScreen = null;
            this.currentGroupIndex = 0;
            this.currentGroup = null;
            this.currentRecipeBookWidget = null;
            return;
        }
        if (!(this.client.field_1755 instanceof class_465)) {
            return;
        }
        this.loadConfig();
        this.currentScreen = (AbstractContainerScreenAccessor)this.client.field_1755;
        this.currentRecipeBookWidget = this.getRecipeBookWidget(this.client.field_1755);
        this.currentSlotsGroupList = GroupGenerator.generateGroupsFromSlots(this.currentScreen);
        this.interval.adjustNextReadyTimeBy(this.keyListener());
        if (this.previousScreen != this.currentScreen) {
            class_481 creativeInventoryScreen;
            class_342 searchBox;
            this.previousScreen = this.currentScreen;
            AbstractContainerScreenAccessor abstractContainerScreenAccessor = this.currentScreen;
            if (abstractContainerScreenAccessor instanceof class_471) {
                class_471 anvilScreen = (class_471)abstractContainerScreenAccessor;
                this.setSearchBoxFocus(((AnvilScreenAccessor)anvilScreen).getName(), false);
            }
            if ((abstractContainerScreenAccessor = this.currentScreen) instanceof class_481 && (searchBox = ((CreativeModeInventoryScreenAccessor)(creativeInventoryScreen = (class_481)abstractContainerScreenAccessor)).getSearchBox()).method_20315()) {
                this.setSearchBoxFocus(searchBox, false);
            }
            if (this.config.autoOpenRecipeBook && this.currentRecipeBookWidget != null) {
                if (!this.currentRecipeBookWidget.method_2605()) {
                    this.currentRecipeBookWidget.method_2591();
                }
                this.setSearchBoxFocus(((RecipeBookComponentAccessor)this.currentRecipeBookWidget).getSearchBox(), false);
            }
            this.refreshGroupListAndSelectFirstGroup(false);
        }
        if (this.currentSlotsGroupList.isEmpty()) {
            return;
        }
        if (this.config.narrateFocusedSlotChanges && !this.previousSlotText.equals(slotNarrationText = this.getCurrentSlotNarrationText())) {
            this.previousSlotText = slotNarrationText;
            MainClass.narrate(this.previousSlotText, true);
        }
    }

    @Nullable
    private class_507<?> getRecipeBookWidget(class_437 screen) {
        if (screen instanceof class_10260) {
            class_10260 recipeBookScreen = (class_10260)screen;
            return ((AbstractRecipeBookScreenAccessor)recipeBookScreen).getRecipeBookComponent();
        }
        return null;
    }

    private void loadConfig() {
        this.config = Config.getInstance().inventoryControls;
        this.interval.setDelay(this.config.delayMilliseconds, Interval.Unit.MILLISECOND);
    }

    private boolean keyListener() {
        class_342 searchBox;
        class_471 anvilScreen;
        class_481 creativeInventoryScreen;
        AbstractContainerScreenAccessor searchBox2;
        boolean isGroupKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.INVENTORY_CONTROLS_GROUP_KEY.mapping);
        boolean isUpKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.INVENTORY_CONTROLS_UP_KEY.mapping);
        boolean isRightKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.INVENTORY_CONTROLS_RIGHT_KEY.mapping);
        boolean isDownKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.INVENTORY_CONTROLS_DOWN_KEY.mapping);
        boolean isLeftKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.INVENTORY_CONTROLS_LEFT_KEY.mapping);
        boolean isSwitchTabKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.INVENTORY_CONTROLS_SWITCH_TAB_KEY.mapping);
        boolean isToggleCraftableKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.INVENTORY_CONTROLS_TOGGLE_CRAFTABLE_KEY.mapping);
        boolean isLeftShiftPressed = KeyUtils.isLeftShiftPressed();
        boolean isEnterPressed = KeyUtils.isEnterPressed();
        boolean isTPressed = KeyUtils.isAnyPressed(84);
        boolean disableInputForSearchBox = false;
        AbstractContainerScreenAccessor abstractContainerScreenAccessor = this.currentScreen;
        if (abstractContainerScreenAccessor instanceof class_481 && (searchBox2 = ((CreativeModeInventoryScreenAccessor)(creativeInventoryScreen = (class_481)abstractContainerScreenAccessor)).getSearchBox()).method_20315()) {
            disableInputForSearchBox = true;
            if (isEnterPressed) {
                this.setSearchBoxFocus((class_342)searchBox2, false);
                this.refreshGroupListAndSelectFirstGroup(true);
                return true;
            }
        }
        if ((searchBox2 = this.currentScreen) instanceof class_471 && (searchBox2 = ((AnvilScreenAccessor)(anvilScreen = (class_471)searchBox2)).getName()).method_20315()) {
            disableInputForSearchBox = true;
            if (isEnterPressed) {
                this.setSearchBoxFocus((class_342)searchBox2, false);
                this.previousSlotText = "";
                return true;
            }
        }
        if (this.recipeBookIsOpening() && (searchBox = ((RecipeBookComponentAccessor)this.currentRecipeBookWidget).getSearchBox()).method_20315()) {
            disableInputForSearchBox = true;
            if (isEnterPressed) {
                this.setSearchBoxFocus(searchBox, false);
                this.previousSlotText = "";
                return true;
            }
        }
        if (disableInputForSearchBox) {
            return true;
        }
        if (isGroupKeyPressed) {
            log.debug("Group key pressed");
            this.changeGroup(!isLeftShiftPressed);
            return true;
        }
        if (isSwitchTabKeyPressed) {
            log.debug("Switch Tab key pressed");
            if (this.currentScreen instanceof class_490 || this.currentScreen instanceof class_479) {
                this.changeRecipeTab(!isLeftShiftPressed);
            } else if (this.currentScreen instanceof class_481) {
                this.changeCreativeInventoryTab(!isLeftShiftPressed);
            }
            return true;
        }
        if (isUpKeyPressed) {
            log.debug("Up key pressed");
            if (isLeftShiftPressed && this.currentGroup.isScrollable) {
                if (this.recipeBookIsOpening()) {
                    this.clickPreviousRecipeBookPage();
                } else {
                    MouseUtils.Wheel.UP.scroll();
                }
            } else {
                this.focusSlotItemAt(FocusDirection.UP);
            }
            return true;
        }
        if (isRightKeyPressed) {
            log.debug("Right key pressed");
            this.focusSlotItemAt(FocusDirection.RIGHT);
            return true;
        }
        if (isDownKeyPressed) {
            log.debug("Down key pressed");
            if (isLeftShiftPressed && this.currentGroup.isScrollable) {
                if (this.recipeBookIsOpening()) {
                    this.clickNextRecipeBookPage();
                } else {
                    MouseUtils.Wheel.DOWN.scroll();
                }
            } else {
                this.focusSlotItemAt(FocusDirection.DOWN);
            }
            return true;
        }
        if (isLeftKeyPressed) {
            log.debug("Left key pressed");
            this.focusSlotItemAt(FocusDirection.LEFT);
            return true;
        }
        if (isTPressed) {
            AbstractContainerScreenAccessor abstractContainerScreenAccessor2;
            if (CreativeModeInventoryScreenAccessor.getSelectedTab().method_47312() == class_1761.class_7916.field_41055 && (abstractContainerScreenAccessor2 = this.currentScreen) instanceof class_481) {
                creativeInventoryScreen = (class_481)abstractContainerScreenAccessor2;
                this.setSearchBoxFocus(((CreativeModeInventoryScreenAccessor)creativeInventoryScreen).getSearchBox(), true);
            } else {
                abstractContainerScreenAccessor2 = this.currentScreen;
                if (abstractContainerScreenAccessor2 instanceof class_471) {
                    class_471 anvilScreen2 = (class_471)abstractContainerScreenAccessor2;
                    this.setSearchBoxFocus(((AnvilScreenAccessor)anvilScreen2).getName(), true);
                } else if (this.recipeBookIsOpening()) {
                    this.client.field_1755.method_25395(this.currentRecipeBookWidget);
                    this.setSearchBoxFocus(((RecipeBookComponentAccessor)this.currentRecipeBookWidget).getSearchBox(), true);
                }
            }
            return true;
        }
        if (isToggleCraftableKeyPressed) {
            if (this.currentRecipeBookWidget == null) {
                return false;
            }
            if (!this.currentRecipeBookWidget.method_2605()) {
                return false;
            }
            class_361 toggleCraftableButton = ((RecipeBookComponentAccessor)this.currentRecipeBookWidget).getFilterButton();
            int x = toggleCraftableButton.method_46426() + 8;
            int y = toggleCraftableButton.method_46427() + 4;
            MouseUtils.Coordinates p = MouseUtils.calcRealPositionOfWidget(x, y);
            MouseUtils.moveAndLeftClick(p.x(), p.y());
            this.moveToSlotItem(this.currentSlotItem, 100);
            String narration = toggleCraftableButton.method_1965() ? class_1074.method_4662((String)"gui.recipebook.toggleRecipes.all", (Object[])new Object[0]) : ((RecipeBookComponentAccessor)this.currentRecipeBookWidget).callGetRecipeFilterName().getString();
            MainClass.narrate(narration, true);
            return true;
        }
        return false;
    }

    private boolean recipeBookIsOpening() {
        return this.currentRecipeBookWidget != null && this.currentRecipeBookWidget.method_2605();
    }

    private void clickPreviousRecipeBookPage() {
        RecipeBookPageAccessor area = (RecipeBookPageAccessor)((RecipeBookComponentAccessor)this.currentRecipeBookWidget).getRecipeBookPage();
        int x = area.getBackButton().method_46426() + 3;
        int y = area.getBackButton().method_46427() + 3;
        MouseUtils.Coordinates p = MouseUtils.calcRealPositionOfWidget(x, y);
        MouseUtils.moveAndLeftClick(p.x(), p.y());
        this.moveToSlotItem(this.currentSlotItem, 100);
    }

    private void clickNextRecipeBookPage() {
        RecipeBookPageAccessor area = (RecipeBookPageAccessor)((RecipeBookComponentAccessor)this.currentRecipeBookWidget).getRecipeBookPage();
        int x = area.getForwardButton().method_46426() + 3;
        int y = area.getForwardButton().method_46427() + 3;
        MouseUtils.Coordinates p = MouseUtils.calcRealPositionOfWidget(x, y);
        MouseUtils.moveAndLeftClick(p.x(), p.y());
        this.moveToSlotItem(this.currentSlotItem, 100);
    }

    private void focusSlotItemAt(FocusDirection focusDirection) {
        if (this.currentGroup == null) {
            this.changeGroup(true);
            return;
        }
        if (this.currentSlotItem == null) {
            this.focusSlotItem(this.currentGroup.getFirstGroupItem(), true);
            return;
        }
        SlotItem slotItem = this.getGroupItemInDirection(focusDirection);
        if (slotItem == null) {
            MainClass.narrate(class_1074.method_4662((String)"minecraft_access.inventory_controls.no_slot_in_direction", (Object[])new Object[]{class_1074.method_4662((String)focusDirection.getString(), (Object[])new Object[0])}), true);
            return;
        }
        this.focusSlotItem(slotItem, true);
    }

    private SlotItem getGroupItemInDirection(FocusDirection focusDirection) {
        switch (focusDirection.ordinal()) {
            case 0: {
                if (!this.currentGroup.hasSlotItemAbove(this.currentSlotItem)) {
                    return null;
                }
                if (this.currentSlotItem.upSlotItem != null) {
                    return this.currentSlotItem.upSlotItem;
                }
                for (SlotItem item : this.currentGroup.slotItems) {
                    if (item.x != this.currentSlotItem.x || item.y != this.currentSlotItem.y - 18) continue;
                    return item;
                }
                break;
            }
            case 3: {
                if (!this.currentGroup.hasSlotItemRight(this.currentSlotItem)) {
                    return null;
                }
                if (this.currentSlotItem.rightSlotItem != null) {
                    return this.currentSlotItem.rightSlotItem;
                }
                for (SlotItem item : this.currentGroup.slotItems) {
                    if (item.x != this.currentSlotItem.x + 18 || item.y != this.currentSlotItem.y) continue;
                    return item;
                }
                break;
            }
            case 1: {
                if (!this.currentGroup.hasSlotItemBelow(this.currentSlotItem)) {
                    return null;
                }
                if (this.currentSlotItem.downSlotItem != null) {
                    return this.currentSlotItem.downSlotItem;
                }
                for (SlotItem item : this.currentGroup.slotItems) {
                    if (item.x != this.currentSlotItem.x || item.y != this.currentSlotItem.y + 18) continue;
                    return item;
                }
                break;
            }
            case 2: {
                if (!this.currentGroup.hasSlotItemLeft(this.currentSlotItem)) {
                    return null;
                }
                if (this.currentSlotItem.leftSlotItem != null) {
                    return this.currentSlotItem.leftSlotItem;
                }
                for (SlotItem item : this.currentGroup.slotItems) {
                    if (item.x != this.currentSlotItem.x - 18 || item.y != this.currentSlotItem.y) continue;
                    return item;
                }
                break;
            }
        }
        return null;
    }

    private void focusSlotItem(@NotNull SlotItem slotItem, boolean interrupt) {
        this.currentSlotItem = slotItem;
        this.moveToSlotItem(this.currentSlotItem);
        String narration = this.getCurrentSlotNarrationText();
        if (!narration.isEmpty()) {
            this.previousSlotText = narration;
            MainClass.narrate(narration, interrupt);
        }
    }

    private void moveToSlotItem(SlotItem slotItem) {
        if (slotItem == null) {
            return;
        }
        int x = slotItem.x;
        int y = slotItem.y;
        MouseUtils.Coordinates p = MouseUtils.calcRealPositionOfWidget(this.currentScreen.getLeftPos() + x, this.currentScreen.getTopPos() + y);
        MouseUtils.move(p.x(), p.y());
    }

    private void moveToSlotItem(SlotItem slotItem, int delay) {
        if (slotItem == null) {
            return;
        }
        int x = slotItem.x;
        int y = slotItem.y;
        MouseUtils.Coordinates p = MouseUtils.calcRealPositionOfWidget(this.currentScreen.getLeftPos() + x, this.currentScreen.getTopPos() + y);
        MouseUtils.moveAfterDelay(p.x(), p.y(), delay);
    }

    private String getCurrentSlotNarrationText() {
        if (this.currentSlotItem == null) {
            return "";
        }
        class_1735 slot = this.currentSlotItem.slot;
        if (slot == null) {
            return Objects.requireNonNullElse(this.currentSlotItem.getNarratableText(), class_1074.method_4662((String)"minecraft_access.inventory_controls.Unknown", (Object[])new Object[0]));
        }
        if (!slot.method_7681()) {
            return class_1074.method_4662((String)"minecraft_access.inventory_controls.empty_slot", (Object[])new Object[]{this.currentGroup.getSlotPrefix(slot)});
        }
        class_1799 itemStack = slot.method_7677();
        String info = "%s %s".formatted(this.currentGroup.getSlotPrefix(slot), itemStack.method_7947() != 1 && !itemStack.method_7960() ? String.valueOf(itemStack.method_7947()) : "");
        StringBuilder toolTipString = new StringBuilder();
        List toolTipList = itemStack.method_7950(class_1792.class_9635.field_51353, (class_1657)this.client.field_1724, (class_1836)class_1836.field_41070);
        for (class_2561 line : toolTipList) {
            toolTipString.append(line.getString()).append(' ');
        }
        Optional.ofNullable((class_9792)itemStack.method_58694(class_9334.field_52175)).flatMap(jukeboxPlayable -> jukeboxPlayable.comp_2833().method_67385()).ifPresent(discNumber -> toolTipString.append(' ').append(class_1074.method_4662((String)("jukebox_song.minecraft." + discNumber.method_29177().method_12832()), (Object[])new Object[0])));
        return "%s %s".formatted(info, toolTipString.toString());
    }

    private void changeGroup(boolean goForward) {
        int nextGroupIndex = this.currentGroupIndex + (goForward ? 1 : -1);
        if ((nextGroupIndex = class_3532.method_15340((int)nextGroupIndex, (int)0, (int)(this.currentSlotsGroupList.size() - 1))) == this.currentGroupIndex) {
            return;
        }
        this.currentGroupIndex = nextGroupIndex;
        this.selectGroup(true);
    }

    private void refreshGroupListAndSelectFirstGroup(boolean interrupt) {
        this.currentSlotsGroupList = GroupGenerator.generateGroupsFromSlots(this.currentScreen);
        if (this.currentSlotsGroupList.isEmpty()) {
            return;
        }
        this.currentGroupIndex = 0;
        this.selectGroup(interrupt);
    }

    private void selectGroup(boolean interrupt) {
        this.currentGroup = this.currentSlotsGroupList.get(this.currentGroupIndex);
        log.debug("Group(name:{}) {}/{} selected", new Object[]{this.currentGroup.getGroupName(), this.currentGroupIndex + 1, this.currentSlotsGroupList.size()});
        MainClass.narrate(class_1074.method_4662((String)"minecraft_access.inventory_controls.group_selected", (Object[])new Object[]{this.currentGroup.isScrollable ? class_1074.method_4662((String)"minecraft_access.inventory_controls.scrollable", (Object[])new Object[0]) : "", this.currentGroup.getGroupName()}), interrupt);
        this.focusSlotItem(this.currentGroup.getFirstGroupItem(), false);
    }

    private void changeCreativeInventoryTab(boolean goForward) {
        AbstractContainerScreenAccessor abstractContainerScreenAccessor = this.currentScreen;
        if (!(abstractContainerScreenAccessor instanceof class_481)) {
            return;
        }
        class_481 creativeInventoryScreen = (class_481)abstractContainerScreenAccessor;
        int tab = class_7706.method_47335().indexOf(CreativeModeInventoryScreenAccessor.getSelectedTab());
        if (goForward && tab + 1 < class_7706.method_47335().size()) {
            ((CreativeModeInventoryScreenAccessor)creativeInventoryScreen).invokeSelectTab((class_1761)class_7706.method_47335().get(tab + 1));
            this.refreshGroupListAndSelectFirstGroup(false);
        } else if (!goForward && tab - 1 >= 0) {
            ((CreativeModeInventoryScreenAccessor)creativeInventoryScreen).invokeSelectTab((class_1761)class_7706.method_47335().get(tab - 1));
            this.refreshGroupListAndSelectFirstGroup(false);
        }
    }

    private void changeRecipeTab(boolean goForward) {
        if (this.currentRecipeBookWidget == null) {
            return;
        }
        if (!this.currentRecipeBookWidget.method_2605()) {
            return;
        }
        RecipeBookComponentAccessor recipeBookComponentAccessor = (RecipeBookComponentAccessor)this.currentRecipeBookWidget;
        int currentTabIndex = recipeBookComponentAccessor.getTabButtons().indexOf(recipeBookComponentAccessor.getSelectedTab());
        int nextTabIndex = currentTabIndex + (goForward ? 1 : -1);
        nextTabIndex = class_3532.method_15340((int)nextTabIndex, (int)0, (int)(recipeBookComponentAccessor.getTabButtons().size() - 1));
        int x = recipeBookComponentAccessor.getTabButtons().get(nextTabIndex).method_46426() + 9;
        int y = recipeBookComponentAccessor.getTabButtons().get(nextTabIndex).method_46427() + 9;
        MouseUtils.Coordinates p = MouseUtils.calcRealPositionOfWidget(x, y);
        MouseUtils.moveAndLeftClick(p.x(), p.y());
        this.moveToSlotItem(this.currentSlotItem, 100);
        class_10287 category = recipeBookComponentAccessor.getSelectedTab().method_2623();
        log.debug("Change tab to {}", (Object)((class_10331)category).name());
    }

    private void setSearchBoxFocus(class_342 w, boolean focus) {
        if (focus) {
            log.debug("T key pressed, selecting the search box.");
            w.method_25365(true);
        } else {
            log.debug("Enter key pressed, deselecting the search box.");
            boolean origin = ((EditBoxAccessor)w).getCanLoseFocus();
            w.method_1856(true);
            w.method_25365(false);
            w.method_1856(origin);
        }
    }

    private static enum FocusDirection {
        UP("gui.up"),
        DOWN("gui.down"),
        LEFT("minecraft_access.inventory_controls.direction_left"),
        RIGHT("minecraft_access.inventory_controls.direction_right");

        private final String value;

        private FocusDirection(String value) {
            this.value = value;
        }

        String getString() {
            return this.value;
        }
    }
}

