/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.narrate_crosshair;

import dev.architectury.platform.Platform;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.features.narrate_crosshair.CrosshairNarrator;
import org.mcaccess.minecraftaccess.features.narrate_crosshair.Jade;
import org.mcaccess.minecraftaccess.features.narrate_crosshair.MCAccess;
import org.mcaccess.minecraftaccess.utils.condition.Interval;

public class NarrateCrosshair {
    @Nullable
    private Object previous = null;
    private class_243 previousSoundPos = class_243.field_1353;
    private final Interval repetitionInterval = Interval.defaultDelay();
    private boolean filterBlocks;
    private boolean filterEntities;
    private static final Config.NarrateCrosshair CONFIG = Config.getInstance().narrateCrosshair;
    private final MCAccess mcAccess;
    private final Jade jade;

    public NarrateCrosshair() {
        this.loadConfig();
        this.mcAccess = new MCAccess();
        this.jade = new Jade();
    }

    public void tick() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        if (client.field_1724 == null) {
            return;
        }
        if (client.field_1755 != null) {
            return;
        }
        this.loadConfig();
        if (!NarrateCrosshair.CONFIG.enabled) {
            return;
        }
        CrosshairNarrator narrator = this.getNarrator();
        Object deduplication = narrator.deduplication(NarrateCrosshair.CONFIG.narrateBlockFace, !NarrateCrosshair.CONFIG.disableNarratingConsecutiveBlocks);
        if (Objects.equals(deduplication, this.previous) && !this.repetitionInterval.isReady()) {
            return;
        }
        this.previous = deduplication;
        if (deduplication == null) {
            return;
        }
        class_239 hit = narrator.rayCast();
        if (NarrateCrosshair.CONFIG.relativePositionSoundCue.enabled) {
            class_243 targetPosition;
            double rayCastDistance = Math.min(client.field_1724.method_55754(), client.field_1724.method_55755());
            class_239 class_2392 = hit;
            Objects.requireNonNull(class_2392);
            class_239 class_2393 = class_2392;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_3965.class, class_3966.class}, (Object)class_2393, n)) {
                case 0: {
                    class_3965 blockHitResult = (class_3965)class_2393;
                    class_243 class_2432 = blockHitResult.method_17777().method_46558();
                    break;
                }
                case 1: {
                    class_3966 entityHitResult = (class_3966)class_2393;
                    class_243 class_2432 = entityHitResult.method_17782().method_73189();
                    break;
                }
                default: {
                    class_243 class_2432 = targetPosition = null;
                }
            }
            if (targetPosition != null && !Objects.equals(targetPosition, this.previousSoundPos)) {
                NarrateCrosshair.playRelativePositionSoundCue(targetPosition, rayCastDistance, (class_6880.class_6883<class_3414>)class_3417.field_15114, NarrateCrosshair.CONFIG.relativePositionSoundCue.minSoundVolume, NarrateCrosshair.CONFIG.relativePositionSoundCue.maxSoundVolume);
            }
            this.previousSoundPos = targetPosition;
        }
        if (NarrateCrosshair.CONFIG.filter.enabled) {
            class_2960 resourceLocation;
            class_239 class_2394 = hit;
            Objects.requireNonNull(class_2394);
            class_239 class_2395 = class_2394;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_3965.class, class_3966.class}, (Object)class_2395, n)) {
                case 0: {
                    class_3965 blockHitResult = (class_3965)class_2395;
                    class_2960 class_29602 = class_7923.field_41175.method_10221((Object)client.field_1687.method_8320(blockHitResult.method_17777()).method_26204());
                    break;
                }
                case 1: {
                    class_3966 entityHitResult = (class_3966)class_2395;
                    class_2960 class_29602 = class_1299.method_5890((class_1299)entityHitResult.method_17782().method_5864());
                    break;
                }
                default: {
                    class_2960 class_29602 = resourceLocation = null;
                }
            }
            if (this.filterBlocks && hit.method_17783() == class_239.class_240.field_1332 && this.isIgnored(resourceLocation)) {
                return;
            }
            if (this.filterEntities && hit.method_17783() == class_239.class_240.field_1331 && this.isIgnored(resourceLocation)) {
                return;
            }
        }
        MainClass.narrate(narrator.narrate(NarrateCrosshair.CONFIG.narrateBlockFace), true);
    }

    private void loadConfig() {
        this.repetitionInterval.setDelay(NarrateCrosshair.CONFIG.repetitionInterval, Interval.Unit.MILLISECOND);
        switch (NarrateCrosshair.CONFIG.filter.targetMode) {
            case ALL: {
                this.filterBlocks = true;
                this.filterEntities = true;
                break;
            }
            case BLOCK: {
                this.filterBlocks = true;
                this.filterEntities = false;
                break;
            }
            case ENTITY: {
                this.filterBlocks = false;
                this.filterEntities = true;
            }
        }
    }

    private CrosshairNarrator getNarrator() {
        if (NarrateCrosshair.CONFIG.useJade && Platform.isModLoaded((String)"jade")) {
            return this.jade;
        }
        return this.mcAccess;
    }

    private boolean isIgnored(class_2960 identifier) {
        if (identifier == null) {
            return false;
        }
        String name = identifier.method_12832();
        Predicate<String> p = NarrateCrosshair.CONFIG.filter.fuzzy ? name::contains : name::equals;
        return NarrateCrosshair.CONFIG.filter.whitelist ? Arrays.stream(NarrateCrosshair.CONFIG.filter.targets).noneMatch(p) : Arrays.stream(NarrateCrosshair.CONFIG.filter.targets).anyMatch(p);
    }

    private static void playRelativePositionSoundCue(class_243 targetPosition, double maxDistance, class_6880.class_6883<class_3414> sound, double minVolume, double maxVolume) {
        assert (class_310.method_1551().field_1724 != null);
        class_243 playerPos = class_310.method_1551().field_1724.method_73189();
        float pitch = (float)Math.pow(2.0, (targetPosition.method_10214() - playerPos.field_1351) / maxDistance);
        double distance = Math.sqrt(targetPosition.method_1028(playerPos.field_1352, playerPos.field_1351, playerPos.field_1350));
        double volumeDeltaPerBlock = (maxVolume - minVolume) / maxDistance;
        float volume = (float)(minVolume + (maxDistance - distance) * volumeDeltaPerBlock);
        assert (class_310.method_1551().field_1687 != null);
        class_310.method_1551().field_1687.method_8486(targetPosition.field_1352, targetPosition.field_1351, targetPosition.field_1350, (class_3414)sound.comp_349(), class_3419.field_15245, volume, pitch, true);
    }
}

