/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.point_of_interest;

import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1672;
import net.minecraft.class_1753;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2399;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2533;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_746;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.features.point_of_interest.BlockPos3d;
import org.mcaccess.minecraftaccess.features.point_of_interest.BuiltinEntityPOIGroups;
import org.mcaccess.minecraftaccess.features.point_of_interest.NonCubeBlockAbsolutePositions;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.mcaccess.minecraftaccess.utils.PlayerUtils;
import org.mcaccess.minecraftaccess.utils.condition.Interval;
import org.mcaccess.minecraftaccess.utils.system.KeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockingHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LockingHandler.class);
    private final class_310 client = class_310.method_1551();
    private Config.POI.Locking config;
    private class_1297 lockedOnEntity = null;
    private BlockPos3d lockedOnBlockPos = null;
    private boolean isLockedOnWhereEyeOfEnderDisappears = false;
    private Map<class_2769<?>, Comparable<?>> entriesOfLockedOnBlock;
    private final Interval interval = Interval.defaultDelay();
    private boolean aimAssistActive = false;
    private int lastAimAssistCue = -1;
    private int lastBowState = -1;

    LockingHandler() {
    }

    private void loadConfig() {
        this.config = Config.getInstance().poi.locking;
        this.interval.setDelay(this.config.delay, Interval.Unit.MILLISECOND);
    }

    public void tick() {
        this.loadConfig();
        if (!this.interval.isReady()) {
            return;
        }
        if (this.client.field_1724 == null) {
            return;
        }
        if (this.client.field_1687 == null) {
            return;
        }
        if (this.client.field_1755 != null) {
            return;
        }
        this.handleLockingKeyPressing();
        if (this.isPlayerLocked()) {
            this.lookAtLockedTarget();
        }
        this.bowAimingAssist();
    }

    private void handleLockingKeyPressing() {
        boolean isLockingKeyPressed = KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.LOCKING_HANDLER_KEY.mapping);
        if (isLockingKeyPressed && this.client.method_74189()) {
            if (this.isPlayerLocked()) {
                this.unlock(true, true);
                this.interval.beReady();
            }
        } else if (isLockingKeyPressed) {
            assert (this.client.method_1560() != null);
            if (this.client.method_1560().method_5779((class_1297)this.client.field_1724)) {
                this.relock();
            } else {
                MainClass.narrate(class_1074.method_4662((String)"minecraft_access.other.camera_locked", (Object[])new Object[0]), true);
            }
            this.interval.reset();
        } else {
            this.interval.beReady();
        }
    }

    private void lookAtLockedTarget() {
        assert (this.client.method_1560() != null);
        if (!this.client.method_1560().method_5779((class_1297)this.client.field_1724)) {
            this.unlock(true, true);
            return;
        }
        if (this.lockedOnEntity != null) {
            if (this.unlockFromDeadEntity()) {
                return;
            }
            PlayerUtils.lookAt(this.lockedOnEntity);
        }
        if (this.lockedOnBlockPos != null) {
            boolean entriesOfLockedBlockNotChanged;
            if (this.unlockFromAirBlock()) {
                return;
            }
            assert (this.client.field_1687 != null);
            class_2680 blockState = this.client.field_1687.method_8320(class_2338.method_49638((class_2374)this.lockedOnBlockPos.getAccuratePosition()));
            if (this.unlockFromLadderIfClimbingOnIt(blockState)) {
                return;
            }
            Map entries = blockState.method_11656();
            boolean bl = entriesOfLockedBlockNotChanged = entries.values() == this.entriesOfLockedOnBlock.values();
            if (entriesOfLockedBlockNotChanged || this.isLockedOnWhereEyeOfEnderDisappears) {
                assert (this.client.field_1724 != null);
                this.client.field_1724.method_5702(class_2183.class_2184.field_9851, this.lockedOnBlockPos.getAccuratePosition());
            } else {
                this.unlock(true, true);
            }
        }
    }

    private void bowAimingAssist() {
        List<class_1297> hostileEntities;
        class_746 player = this.client.field_1724;
        if (player == null) {
            return;
        }
        if (this.config.aimAssistEnabled && !this.aimAssistActive && player.method_6115() && player.method_6030().method_7909() instanceof class_1753 && !(hostileEntities = BuiltinEntityPOIGroups.HOSTILE.group.getItems()).isEmpty()) {
            class_1297 entity = hostileEntities.stream().min(Comparator.comparingDouble(arg_0 -> ((class_746)player).method_5739(arg_0))).get();
            if (this.lockOnEntity(entity)) {
                this.aimAssistActive = true;
            }
        }
        if (!(!this.aimAssistActive || player.method_6115() && player.method_6030().method_7909() instanceof class_1753)) {
            this.unlock(false, true);
            this.aimAssistActive = false;
            this.lastAimAssistCue = -1;
            this.lastBowState = -1;
            return;
        }
        if (this.config.aimAssistAudioCuesEnabled && this.aimAssistActive && this.lockedOnEntity != null) {
            float bowPullingProgress = class_1753.method_7722((int)player.method_6048());
            int bowState = -1;
            if (bowPullingProgress >= 0.0f && bowPullingProgress < 0.5f) {
                bowState = 0;
            }
            if (bowPullingProgress >= 0.5f && bowPullingProgress < 1.0f) {
                bowState = 1;
            }
            if (bowPullingProgress == 1.0f) {
                bowState = 2;
            }
            class_243 eyePosition = player.method_33571();
            class_243 targetPosition = PlayerUtils.currentEntityLookingAtPosition;
            if (targetPosition != null) {
                if (PlayerUtils.isVisibleToPlayer(eyePosition, targetPosition, this.lockedOnEntity)) {
                    if (this.lastAimAssistCue != 1 || bowState != this.lastBowState) {
                        player.method_5783((class_3414)class_3417.field_14622.comp_349(), this.config.aimAssistAudioCuesVolume, (float)bowState);
                        this.lastAimAssistCue = 1;
                    }
                } else if (this.lastAimAssistCue != 0 || bowState != this.lastBowState) {
                    player.method_5783((class_3414)class_3417.field_14624.comp_349(), this.config.aimAssistAudioCuesVolume, (float)bowState);
                    this.lastAimAssistCue = 0;
                }
                this.lastBowState = bowState;
            }
        }
    }

    public boolean isPlayerLocked() {
        return this.lockedOnBlockPos != null || this.lockedOnEntity != null;
    }

    private void unlock(boolean narrate, boolean isStillValid) {
        this.lockedOnEntity = null;
        this.entriesOfLockedOnBlock = null;
        this.lockedOnBlockPos = null;
        this.isLockedOnWhereEyeOfEnderDisappears = false;
        if (!isStillValid) {
            MainClass.poiManager.objectTracker.clearCurrentObject();
        }
        if (narrate) {
            if (this.config.unlockingSound) {
                assert (this.client.field_1724 != null);
                this.client.field_1724.method_5783((class_3414)class_3417.field_15047.comp_349(), 0.4f, 2.0f);
            } else {
                MainClass.narrate(class_1074.method_4662((String)"narrator.button.difficulty_lock.unlocked", (Object[])new Object[0]), true);
            }
        }
    }

    private void relock() {
        Object target = MainClass.poiManager.objectTracker.getCurrentObject();
        if (target == null) {
            MainClass.narrate(class_1074.method_4662((String)"minecraft_access.point_of_interest.not_selected", (Object[])new Object[0]), true);
            return;
        }
        Object object = target;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1297.class, class_2338.class}, (Object)object2, n)) {
            case 0: {
                class_1297 entity = (class_1297)object2;
                this.lockOnEntity(entity);
                break;
            }
            case 1: {
                class_2338 blockPos = (class_2338)object2;
                this.lockOnBlock(blockPos);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected locking target type: " + String.valueOf(target));
            }
        }
    }

    private boolean unlockFromLadderIfClimbingOnIt(class_2680 blockState) {
        if (class_2246.field_9983.equals(blockState.method_26204())) {
            assert (this.client.field_1724 != null);
            class_243 playerPos = this.client.field_1724.method_73189();
            double distance = this.lockedOnBlockPos.method_46558().method_1022(playerPos);
            if (distance <= 0.5) {
                this.unlock(true, true);
                return true;
            }
        }
        return false;
    }

    private boolean unlockFromDeadEntity() {
        if (this.lockedOnEntity instanceof class_1672) {
            this.lockOnBlock(this.lockedOnEntity.method_24515());
            this.isLockedOnWhereEyeOfEnderDisappears = true;
        }
        if (MainClass.poiManager.objectTracker.isObjectValid(this.lockedOnEntity)) {
            return false;
        }
        this.unlock(true, false);
        return true;
    }

    private boolean unlockFromAirBlock() {
        if (MainClass.poiManager.objectTracker.isObjectValid((Object)this.lockedOnBlockPos)) {
            return false;
        }
        this.unlock(true, false);
        return true;
    }

    public boolean lockOnEntity(class_1297 entity) {
        if (!MainClass.poiManager.objectTracker.isObjectValid(entity)) {
            return false;
        }
        this.unlock(false, true);
        this.lockedOnEntity = entity;
        StringBuilder narration = new StringBuilder(NarrationUtils.narrateEntity(entity));
        if (Config.getInstance().poi.narrateDistance) {
            narration.append(' ').append(NarrationUtils.narrateRelativePositionOfPlayerAnd(entity.method_24515()));
        }
        MainClass.narrate(class_1074.method_4662((String)"minecraft_access.point_of_interest.locking.locked", (Object[])new Object[]{narration}), true);
        return true;
    }

    private void lockOnBlock(class_2338 position) {
        assert (this.client.field_1687 != null);
        class_2680 blockState = this.client.field_1687.method_8320(position);
        this.entriesOfLockedOnBlock = blockState.method_11656();
        class_2248 class_22482 = blockState.method_26204();
        Objects.requireNonNull(class_22482);
        class_2248 class_22483 = class_22482;
        int n = 0;
        class_243 absolutePosition = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2323.class, class_2533.class, class_2269.class, class_2399.class, class_2401.class}, (Object)class_22483, n)) {
            case 0 -> {
                class_2323 ignored = (class_2323)class_22483;
                yield NonCubeBlockAbsolutePositions.getDoorPos(position.method_46558());
            }
            case 1 -> {
                class_2533 ignored = (class_2533)class_22483;
                yield NonCubeBlockAbsolutePositions.getTrapDoorPos(position.method_46558());
            }
            case 2 -> {
                class_2269 ignored = (class_2269)class_22483;
                yield NonCubeBlockAbsolutePositions.getButtonPos(position.method_46558());
            }
            case 3 -> {
                class_2399 ignored = (class_2399)class_22483;
                yield NonCubeBlockAbsolutePositions.getLadderPos(position.method_46558());
            }
            case 4 -> {
                class_2401 ignored = (class_2401)class_22483;
                yield NonCubeBlockAbsolutePositions.getLeverPos(position.method_46558());
            }
            default -> position.method_46558();
        };
        this.lockedOnBlockPos = new BlockPos3d(position, absolutePosition);
        StringBuilder blockDescription = new StringBuilder(NarrationUtils.narrateBlock(this.lockedOnBlockPos, ""));
        if (Config.getInstance().poi.narrateDistance) {
            blockDescription.append(' ').append(NarrationUtils.narrateRelativePositionOfPlayerAnd(this.lockedOnBlockPos));
        }
        MainClass.narrate(class_1074.method_4662((String)"minecraft_access.point_of_interest.locking.locked", (Object[])new Object[]{blockDescription}), true);
    }
}

