/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.point_of_interest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_2189;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_746;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.features.point_of_interest.POIGroup;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.mcaccess.minecraftaccess.utils.condition.Keystroke;
import org.mcaccess.minecraftaccess.utils.system.KeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTracker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ObjectTracker.class);
    private final class_310 client = class_310.method_1551();
    public static final String START_OF_LIST = "minecraft_access.other.start_of_list";
    public static final String END_OF_LIST = "minecraft_access.other.end_of_list";
    private final Keystroke nextItemKeyPressed = new Keystroke(() -> KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.OBJECT_TRACKER_NEXT_ITEM.mapping), Keystroke.TriggeredAt.PRESSED);
    private final Keystroke previousItemKeyPressed = new Keystroke(() -> KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.OBJECT_TRACKER_PREVIOUS_ITEM.mapping), Keystroke.TriggeredAt.PRESSED);
    private final Keystroke narrateCurrentObjectKeyPressed = new Keystroke(() -> KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.OBJECT_TRACKER_NARRATE_CURRENT_OBJECT.mapping), Keystroke.TriggeredAt.PRESSED);
    private final Keystroke targetNearestObjectKeyPressed = new Keystroke(() -> KeyUtils.isAnyPressed(KeyBindingsHandler.Keys.TARGET_NEAREST_OBJECT.mapping), Keystroke.TriggeredAt.PRESSED);
    private Object currentObject = null;
    private POIGroup<?> currentGroup = null;
    private List<POIGroup<?>> groups = new ArrayList();

    ObjectTracker() {
    }

    private List<POIGroup<?>> getPOIGroups() {
        List<POIGroup<class_2338>> groupList = Stream.concat(Arrays.stream(MainClass.poiManager.poiEntities.groups), Arrays.stream(MainClass.poiManager.poiBlocks.groups)).toList();
        ArrayList result = new ArrayList();
        for (POIGroup<class_2338> group : groupList) {
            if (group.isEmpty()) continue;
            result.add(group);
        }
        return result;
    }

    public void tick() {
        if (this.client.field_1724 == null) {
            return;
        }
        if (this.client.field_1687 == null) {
            return;
        }
        if (this.client.field_1755 != null) {
            return;
        }
        this.updateGroups();
        if (this.narrateCurrentObjectKeyPressed.canBeTriggered()) {
            this.narrateCurrentObject(true);
        }
        if (this.nextItemKeyPressed.canBeTriggered() && this.client.method_74188()) {
            this.moveGroup(1);
        }
        if (this.previousItemKeyPressed.canBeTriggered() && this.client.method_74188()) {
            this.moveGroup(-1);
        }
        if (this.nextItemKeyPressed.canBeTriggered() && !this.client.method_74188()) {
            this.moveObject(1);
        }
        if (this.previousItemKeyPressed.canBeTriggered() && !this.client.method_74188()) {
            this.moveObject(-1);
        }
        if (this.targetNearestObjectKeyPressed.canBeTriggered()) {
            this.targetNearestObject();
        }
    }

    private void updateGroups() {
        this.groups = this.getPOIGroups();
        int currentGroupIndex = this.groups.indexOf(this.currentGroup);
        if (this.currentGroup != null && this.currentGroup.isEmpty()) {
            currentGroupIndex = -1;
        }
        if (!this.groups.isEmpty() && currentGroupIndex == -1) {
            this.currentGroup = this.groups.getFirst();
        }
        if (this.groups.isEmpty() && currentGroupIndex != -1) {
            this.currentGroup = null;
        }
    }

    private void narrateCurrentObject(boolean interrupt) {
        Object narration;
        if (this.checkAndNarrateIfAllGroupsEmpty()) {
            return;
        }
        if (!this.isObjectValid(this.currentObject)) {
            this.clearCurrentObject();
            MainClass.narrate(class_1074.method_4662((String)"minecraft_access.point_of_interest.not_selected", (Object[])new Object[0]), true);
            return;
        }
        boolean narrateDistance = Config.getInstance().poi.narrateDistance;
        Object object = this.currentObject;
        if (object instanceof class_1297) {
            class_1297 entity = (class_1297)object;
            narration = new StringBuilder(NarrationUtils.narrateEntity(entity));
            if (narrateDistance) {
                ((StringBuilder)narration).append(' ').append(NarrationUtils.narrateRelativePositionOfPlayerAnd(entity.method_24515()));
            }
            MainClass.narrate(((StringBuilder)narration).toString(), interrupt);
            assert (this.client.field_1687 != null);
            this.client.field_1687.method_8486(entity.method_23317(), entity.method_23318(), entity.method_23321(), (class_3414)class_3417.field_14793.comp_349(), class_3419.field_15245, 1.0f, 1.0f, true);
            return;
        }
        narration = this.currentObject;
        if (narration instanceof class_2338) {
            class_2338 blockPos = (class_2338)narration;
            narration = new StringBuilder(NarrationUtils.narrateBlock(blockPos, null));
            if (narrateDistance) {
                ((StringBuilder)narration).append(' ').append(NarrationUtils.narrateRelativePositionOfPlayerAnd(blockPos));
            }
            MainClass.narrate(((StringBuilder)narration).toString(), interrupt);
            assert (this.client.field_1687 != null);
            this.client.field_1687.method_45446(blockPos, (class_3414)class_3417.field_14793.comp_349(), class_3419.field_15245, 1.0f, 1.0f, true);
        }
    }

    private void moveGroup(int step) {
        if (this.checkAndNarrateIfAllGroupsEmpty()) {
            return;
        }
        int currentGroupIndex = this.groups.indexOf(this.currentGroup);
        int newIndex = currentGroupIndex + step;
        boolean atBoundary = false;
        if (newIndex < 0) {
            newIndex = 0;
            atBoundary = true;
            MainClass.narrate(class_1074.method_4662((String)START_OF_LIST, (Object[])new Object[0]), true);
        } else if (newIndex >= this.groups.size()) {
            newIndex = this.groups.size() - 1;
            atBoundary = true;
            MainClass.narrate(class_1074.method_4662((String)END_OF_LIST, (Object[])new Object[0]), true);
        }
        POIGroup<?> nextGroup = this.groups.get(newIndex);
        while ((nextGroup.isEmpty() || nextGroup.sortByDistance().stream().noneMatch(this::isObjectValid)) && newIndex + step >= 0 && newIndex + step < this.groups.size()) {
            nextGroup = this.groups.get(newIndex += step);
        }
        if (nextGroup.isEmpty() || nextGroup.sortByDistance().stream().noneMatch(this::isObjectValid)) {
            MainClass.narrate(class_1074.method_4662((String)(step > 0 ? END_OF_LIST : START_OF_LIST), (Object[])new Object[0]), true);
            return;
        }
        this.currentGroup = nextGroup;
        List<Object> validObjects = this.currentGroup.sortByDistance().stream().filter(this::isObjectValid).toList();
        if (validObjects.isEmpty()) {
            this.clearCurrentObject();
            MainClass.narrate(class_1074.method_4662((String)"minecraft_access.point_of_interest.not_selected", (Object[])new Object[0]), true);
            return;
        }
        this.currentObject = validObjects.getFirst();
        if (!atBoundary) {
            MainClass.narrate(this.currentGroup.getTranslatedName(), true);
        } else {
            MainClass.narrate(this.currentGroup.getTranslatedName(), false);
        }
        this.narrateCurrentObject(false);
    }

    public boolean isObjectValid(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof class_1297) {
            class_1297 entity = (class_1297)object;
            return entity.method_5805();
        }
        if (object instanceof class_2338) {
            class_2338 pos = (class_2338)object;
            if (this.client.field_1687 == null) {
                return false;
            }
            return !(this.client.field_1687.method_8320(pos).method_26204() instanceof class_2189);
        }
        return false;
    }

    private void moveObject(int step) {
        List<?> objects;
        int currentObjectIndex;
        if (this.checkAndNarrateIfAllGroupsEmpty()) {
            return;
        }
        if (this.currentGroup != null && this.currentGroup.isEmpty()) {
            this.clearCurrentObject();
        }
        if ((currentObjectIndex = (objects = this.currentGroup.sortByDistance()).indexOf(this.currentObject)) == -1) {
            MainClass.narrate(class_1074.method_4662((String)START_OF_LIST, (Object[])new Object[0]), true);
            this.currentObject = objects.getFirst();
        } else {
            int newIndex = currentObjectIndex + step;
            if (newIndex < 0) {
                MainClass.narrate(class_1074.method_4662((String)START_OF_LIST, (Object[])new Object[0]), true);
                this.currentObject = objects.getFirst();
            } else if (newIndex >= objects.size()) {
                MainClass.narrate(class_1074.method_4662((String)END_OF_LIST, (Object[])new Object[0]), true);
                this.currentObject = objects.getLast();
            } else {
                this.currentObject = objects.get(newIndex);
            }
        }
        while (!this.isObjectValid(this.currentObject)) {
            int nextIndex = objects.indexOf(this.currentObject) + step;
            if (nextIndex < 0 || nextIndex >= objects.size()) {
                MainClass.narrate(class_1074.method_4662((String)(step > 0 ? END_OF_LIST : START_OF_LIST), (Object[])new Object[0]), true);
                this.clearCurrentObject();
                return;
            }
            this.currentObject = objects.get(nextIndex);
        }
        this.narrateCurrentObject(false);
    }

    private boolean checkAndNarrateIfAllGroupsEmpty() {
        if (this.groups.isEmpty()) {
            this.clearCurrentObject();
            MainClass.narrate(class_1074.method_4662((String)"minecraft_access.point_of_interest.not_found", (Object[])new Object[0]), true);
            return true;
        }
        return false;
    }

    private void targetNearestObject() {
        class_746 player = this.client.field_1724;
        List<class_1297> entities = MainClass.poiManager.poiEntities.getLastScanResults().stream().sorted(Comparator.comparingDouble(a -> a.method_5739((class_1297)player))).toList();
        List<class_2338> blocks = MainClass.poiManager.poiBlocks.getLastScanResults().stream().sorted(Comparator.comparingDouble(a -> {
            assert (player != null);
            return player.method_33571().method_1022(a.method_46558());
        })).toList();
        if (this.client.method_74188() && !this.client.method_74187()) {
            if (entities.isEmpty()) {
                MainClass.narrate(class_1074.method_4662((String)"minecraft_access.point_of_interest.not_found.entity", (Object[])new Object[0]), true);
            } else {
                this.currentObject = entities.getFirst();
                MainClass.narrate(class_1074.method_4662((String)"minecraft_access.point_of_interest.targeting_nearest.entity", (Object[])new Object[0]), true);
            }
        } else if (this.client.method_74187() && !this.client.method_74188()) {
            if (blocks.isEmpty()) {
                MainClass.narrate(class_1074.method_4662((String)"minecraft_access.point_of_interest.not_found.block", (Object[])new Object[0]), true);
            } else {
                this.currentObject = blocks.getFirst();
                MainClass.narrate(class_1074.method_4662((String)"minecraft_access.point_of_interest.targeting_nearest.block", (Object[])new Object[0]), true);
            }
        } else if (entities.isEmpty() && blocks.isEmpty()) {
            MainClass.narrate(class_1074.method_4662((String)"minecraft_access.point_of_interest.not_found", (Object[])new Object[0]), true);
        } else if (entities.isEmpty()) {
            this.currentObject = blocks.getFirst();
            MainClass.narrate(class_1074.method_4662((String)"minecraft_access.point_of_interest.targeting_nearest", (Object[])new Object[0]), true);
        } else if (blocks.isEmpty()) {
            this.currentObject = entities.getFirst();
            MainClass.narrate(class_1074.method_4662((String)"minecraft_access.point_of_interest.targeting_nearest", (Object[])new Object[0]), true);
        } else {
            this.currentObject = player.method_33571().method_1022(blocks.getFirst().method_46558()) < (double)player.method_5739(entities.getFirst()) ? blocks.getFirst() : entities.getFirst();
            MainClass.narrate(class_1074.method_4662((String)"minecraft_access.point_of_interest.targeting_nearest", (Object[])new Object[0]), true);
        }
        if (!entities.isEmpty() || !blocks.isEmpty()) {
            this.narrateCurrentObject(false);
        }
    }

    public void clearCurrentObject() {
        this.currentObject = null;
        this.updateGroups();
    }

    @Generated
    public Object getCurrentObject() {
        return this.currentObject;
    }

    @Generated
    public POIGroup<?> getCurrentGroup() {
        return this.currentGroup;
    }
}

