/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.point_of_interest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.features.point_of_interest.BlockScanner;
import org.mcaccess.minecraftaccess.features.point_of_interest.BuiltinBlockPOIGroups;
import org.mcaccess.minecraftaccess.features.point_of_interest.POIGroup;
import org.mcaccess.minecraftaccess.utils.condition.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POIBlocks {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(POIBlocks.class);
    private final class_310 client = class_310.method_1551();
    private Config.POI.Blocks config;
    private final Interval interval = Interval.defaultDelay();
    @Nullable
    private class_2248 markedBlock = null;
    private class_638 world;
    private final POIGroup<class_2338> markedGroup;
    private final POIGroup<class_2338> otherBlocksGroup;
    public final POIGroup<class_2338>[] groups;
    private List<class_2338> lastScanResults;

    POIBlocks() {
        this.world = this.client.field_1687;
        this.markedGroup = new POIGroup<class_2338>("minecraft_access.point_of_interest.group.markedBlock", new POIGroup.Sound(class_3417.field_15197, -5.0f), pos -> this.world.method_8320(pos).method_27852(this.markedBlock));
        this.otherBlocksGroup = new POIGroup<class_2338>("minecraft_access.point_of_interest.group.otherBlocks", pos -> {
            class_2680 state = this.world.method_8320(pos);
            boolean blockAlreadyInGroup = this.otherBlocksGroup.getItems().stream().map(p -> this.world.method_8320(p).method_26204()).anyMatch(t -> t.equals(state.method_26204()));
            return !state.method_26215() && !blockAlreadyInGroup;
        });
        this.groups = (POIGroup[])Stream.of(List.of(this.markedGroup), BuiltinBlockPOIGroups.ALL, List.of(this.otherBlocksGroup)).flatMap(Collection::stream).toArray(POIGroup[]::new);
        this.lastScanResults = new ArrayList<class_2338>();
        this.loadConfig();
    }

    public void tick(boolean isMarking, class_2248 markedBlock) {
        this.setMarkedBlock(markedBlock);
        this.loadConfig();
        if (!this.config.enabled) {
            return;
        }
        if (!this.interval.isReady()) {
            return;
        }
        if (this.client.field_1724 == null) {
            return;
        }
        if (this.client.field_1755 != null) {
            return;
        }
        log.trace("POIBlock started");
        this.scanBlocksAroundPlayer();
        this.playerSoundAtFoundPOI(isMarking);
        log.trace("POIBlock ended");
    }

    private void scanBlocksAroundPlayer() {
        ArrayList<class_2338> currentScanResults = new ArrayList<class_2338>();
        for (POIGroup<class_2338> group : this.groups) {
            group.clear();
        }
        BlockScanner scanner = new BlockScanner(blockPos -> {
            for (POIGroup<class_2338> group : this.groups) {
                if (!group.addIfQualified((class_2338)blockPos) || group == this.otherBlocksGroup) continue;
                currentScanResults.add((class_2338)blockPos);
                break;
            }
        });
        assert (this.client.field_1724 != null);
        class_2338 pos = this.client.field_1724.method_24515();
        scanner.scanAndQualifyBlocksExposedInAirAround(pos.method_10074(), 0);
        scanner.scanAndQualifyBlocksExposedInAirAround(pos.method_10086(2), 0);
        scanner.scanAndQualifyBlocksExposedInAirAround(pos, this.config.range);
        scanner.scanAndQualifyBlocksExposedInAirAround(pos.method_10084(), this.config.range);
        this.lastScanResults = currentScanResults;
    }

    private void playerSoundAtFoundPOI(boolean isMarking) {
        if (this.config.volume == 0.0f) {
            return;
        }
        if (isMarking && Config.getInstance().poi.marking.suppressOtherWhenEnabled) {
            this.markedGroup.playSoundForGroupItems(class_2338::method_46558, this.config.volume);
        } else if (this.config.playSound) {
            if (this.config.playSoundForOtherBlocks) {
                for (POIGroup<class_2338> group : this.groups) {
                    group.playSoundForGroupItems(class_2338::method_46558, this.config.volume);
                }
            } else {
                BuiltinBlockPOIGroups.ORE.group.playSoundForGroupItems(class_2338::method_46558, this.config.volume);
            }
        }
    }

    private void loadConfig() {
        this.config = Config.getInstance().poi.blocks;
        this.interval.setDelay(this.config.delay, Interval.Unit.MILLISECOND);
    }

    private void setMarkedBlock(@Nullable class_2248 block) {
        this.markedBlock = block;
    }

    @Generated
    public List<class_2338> getLastScanResults() {
        return this.lastScanResults;
    }
}

