/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.screen_reader;

import lombok.Generated;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderInterface;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderLinux;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderMacOS;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderWindows;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScreenReaderController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScreenReaderController.class);

    private ScreenReaderController() {
    }

    @Nullable
    public static ScreenReaderInterface getAvailable() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("windows")) {
            ScreenReaderWindows screenReaderWindows = new ScreenReaderWindows();
            screenReaderWindows.initializeScreenReader();
            return screenReaderWindows;
        }
        if (osName.startsWith("mac")) {
            ScreenReaderMacOS screenReaderMacOS = new ScreenReaderMacOS();
            screenReaderMacOS.initializeScreenReader();
            return screenReaderMacOS;
        }
        if (osName.startsWith("linux")) {
            ScreenReaderLinux screenReaderLinux = new ScreenReaderLinux();
            screenReaderLinux.initializeScreenReader();
            return screenReaderLinux;
        }
        log.error("No valid ScreenReader interface found");
        return null;
    }

    public static void refreshScreenReader() {
        ScreenReaderController.refreshScreenReader(false);
    }

    public static void refreshScreenReader(boolean closeOpenedScreen) {
        log.info("Refreshing screen reader");
        MainClass.setScreenReader(ScreenReaderController.getAvailable());
        if (!closeOpenedScreen) {
            return;
        }
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        class_310.method_1551().field_1724.method_3137();
        MainClass.narrate(class_1074.method_4662((String)"minecraft_access.access_menu.screen_reader_refreshed", (Object[])new Object[0]), true);
    }
}

