/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.screen_reader;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import lombok.Generated;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenReaderMacOS
implements ScreenReaderInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScreenReaderMacOS.class);
    private ObjcRuntimeInterface objcRuntimeInstance = null;
    private Pointer speechSynthesizer = null;

    @Override
    public void initializeScreenReader() {
        log.info("Initializing MacOS Objective C runtime");
        this.objcRuntimeInstance = (ObjcRuntimeInterface)Native.load((String)"objc", ObjcRuntimeInterface.class);
        this.speechSynthesizer = this.objcRuntimeInstance.objc_msgSend(this.objcRuntimeInstance.objc_getClass("AVSpeechSynthesizer"), this.objcRuntimeInstance.sel_getUid("alloc"));
        this.objcRuntimeInstance.objc_msgSend(this.speechSynthesizer, this.objcRuntimeInstance.sel_getUid("init"));
        log.info("Successfully initialized screen reader");
    }

    @Override
    public boolean isInitialized() {
        return this.speechSynthesizer != null;
    }

    @Override
    public void narrate(String text, boolean interrupt) {
        if (this.speechSynthesizer == null) {
            return;
        }
        String narration = this.formatNarration(text);
        if (interrupt) {
            this.objcRuntimeInstance.objc_msgSend(this.speechSynthesizer, this.objcRuntimeInstance.sel_getUid("stopSpeakingAtBoundary:"), 0);
        }
        float speechRate = Config.getInstance().speechSettings.speechRate / 100.0f;
        Pointer stringObject = this.objcRuntimeInstance.objc_msgSend(this.objcRuntimeInstance.objc_getClass("NSString"), this.objcRuntimeInstance.sel_getUid("stringWithUTF8String:"), narration);
        Pointer utterance = this.objcRuntimeInstance.objc_msgSend(this.objcRuntimeInstance.objc_getClass("AVSpeechUtterance"), this.objcRuntimeInstance.sel_getUid("alloc"));
        this.objcRuntimeInstance.objc_msgSend(utterance, this.objcRuntimeInstance.sel_getUid("initWithString:"), stringObject);
        this.objcRuntimeInstance.objc_msgSend(utterance, this.objcRuntimeInstance.sel_getUid("setPrefersAssistiveTechnologySettings:"), (byte)0);
        this.objcRuntimeInstance.objc_msgSend(utterance, this.objcRuntimeInstance.sel_getUid("setRate:"), Float.valueOf(speechRate));
        this.objcRuntimeInstance.objc_msgSend(this.speechSynthesizer, this.objcRuntimeInstance.sel_getUid("speakUtterance:"), utterance);
        log.info("Narrating(interrupt:{})= {}", (Object)interrupt, (Object)narration);
        this.objcRuntimeInstance.objc_msgSend(utterance, this.objcRuntimeInstance.sel_getUid("release"));
    }

    @Override
    public void closeScreenReader() {
        if (this.speechSynthesizer == null) {
            return;
        }
        this.objcRuntimeInstance.objc_msgSend(this.speechSynthesizer, this.objcRuntimeInstance.sel_getUid("release"));
        log.info("Successfully closed screen reader");
    }

    private static interface ObjcRuntimeInterface
    extends Library {
        public Pointer objc_getClass(String var1);

        public Pointer sel_getUid(String var1);

        public Pointer objc_msgSend(Pointer var1, Pointer var2);

        public Pointer objc_msgSend(Pointer var1, Pointer var2, Object var3);
    }
}

