/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.utils.position;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_310;

public final class Orientation
extends Enum<Orientation> {
    public static final /* enum */ Orientation CENTER = new Orientation(0, 0, Layer.MIDDLE, new class_2382(0, 0, 0));
    public static final /* enum */ Orientation NORTH = new Orientation(1, 2, Layer.MIDDLE, new class_2382(0, 0, -1));
    public static final /* enum */ Orientation SOUTH = new Orientation(2, 1, Layer.MIDDLE, new class_2382(0, 0, 1));
    public static final /* enum */ Orientation EAST = new Orientation(3, 4, Layer.MIDDLE, new class_2382(1, 0, 0));
    public static final /* enum */ Orientation WEST = new Orientation(4, 3, Layer.MIDDLE, new class_2382(-1, 0, 0));
    public static final /* enum */ Orientation NORTH_EAST = new Orientation(5, 8, Layer.MIDDLE, new class_2382(1, 0, -1));
    public static final /* enum */ Orientation NORTH_WEST = new Orientation(6, 7, Layer.MIDDLE, new class_2382(-1, 0, -1));
    public static final /* enum */ Orientation SOUTH_EAST = new Orientation(7, 6, Layer.MIDDLE, new class_2382(1, 0, 1));
    public static final /* enum */ Orientation SOUTH_WEST = new Orientation(8, 5, Layer.MIDDLE, new class_2382(-1, 0, 1));
    public static final /* enum */ Orientation UP = new Orientation(9, 10, Layer.UPPER, new class_2382(0, 1, 0));
    public static final /* enum */ Orientation DOWN = new Orientation(10, 9, Layer.LOWER, new class_2382(0, -1, 0));
    public static final /* enum */ Orientation UPPER_NORTH = new Orientation(11, 20, Layer.UPPER, new class_2382(0, 1, -1));
    public static final /* enum */ Orientation UPPER_SOUTH = new Orientation(12, 19, Layer.UPPER, new class_2382(0, 1, 1));
    public static final /* enum */ Orientation UPPER_EAST = new Orientation(13, 22, Layer.UPPER, new class_2382(1, 1, 0));
    public static final /* enum */ Orientation UPPER_WEST = new Orientation(14, 21, Layer.UPPER, new class_2382(-1, 1, 0));
    public static final /* enum */ Orientation UPPER_NORTH_EAST = new Orientation(15, 26, Layer.UPPER, new class_2382(1, 1, -1));
    public static final /* enum */ Orientation UPPER_NORTH_WEST = new Orientation(16, 25, Layer.UPPER, new class_2382(-1, 1, -1));
    public static final /* enum */ Orientation UPPER_SOUTH_EAST = new Orientation(17, 24, Layer.UPPER, new class_2382(1, 1, 1));
    public static final /* enum */ Orientation UPPER_SOUTH_WEST = new Orientation(18, 23, Layer.UPPER, new class_2382(-1, 1, 1));
    public static final /* enum */ Orientation LOWER_NORTH = new Orientation(19, 12, Layer.LOWER, new class_2382(0, -1, -1));
    public static final /* enum */ Orientation LOWER_SOUTH = new Orientation(20, 11, Layer.LOWER, new class_2382(0, -1, 1));
    public static final /* enum */ Orientation LOWER_EAST = new Orientation(21, 14, Layer.LOWER, new class_2382(1, -1, 0));
    public static final /* enum */ Orientation LOWER_WEST = new Orientation(22, 13, Layer.LOWER, new class_2382(-1, -1, 0));
    public static final /* enum */ Orientation LOWER_NORTH_EAST = new Orientation(23, 18, Layer.LOWER, new class_2382(1, -1, -1));
    public static final /* enum */ Orientation LOWER_NORTH_WEST = new Orientation(24, 17, Layer.LOWER, new class_2382(-1, -1, -1));
    public static final /* enum */ Orientation LOWER_SOUTH_EAST = new Orientation(25, 16, Layer.LOWER, new class_2382(1, -1, 1));
    public static final /* enum */ Orientation LOWER_SOUTH_WEST = new Orientation(26, 15, Layer.LOWER, new class_2382(-1, -1, 1));
    private final int id;
    private final int idOpposite;
    private static final Orientation[] ALL;
    public final class_2382 vector;
    public final Layer layer;
    private static final /* synthetic */ Orientation[] $VALUES;

    public static Orientation[] values() {
        return (Orientation[])$VALUES.clone();
    }

    public static Orientation valueOf(String name) {
        return Enum.valueOf(Orientation.class, name);
    }

    private Orientation(int id, int idOpposite, Layer layer, class_2382 vector) {
        this.id = id;
        this.idOpposite = idOpposite;
        this.layer = layer;
        this.vector = vector;
    }

    public static Orientation of(String s) {
        try {
            return Orientation.valueOf(s.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return CENTER;
        }
    }

    public static Orientation of(class_2350 direction) {
        return Orientation.of(direction.method_15434().toUpperCase());
    }

    public static String getOppositeDirectionKey(String originalDirectionKey) {
        return Orientation.of(originalDirectionKey).getOpposite().toString();
    }

    public static Orientation ofHorizontal(int angle) {
        int normalised = angle % 360;
        if (normalised < 0) {
            normalised += 360;
        }
        if ((double)normalised >= 11.25 && (double)normalised < 78.75) {
            return SOUTH_WEST;
        }
        if ((double)normalised >= 101.25 && (double)normalised < 168.75) {
            return NORTH_WEST;
        }
        if ((double)normalised >= 191.25 && (double)normalised < 258.75) {
            return NORTH_EAST;
        }
        if ((double)normalised >= 281.25 && (double)normalised < 348.75) {
            return SOUTH_EAST;
        }
        assert (class_310.method_1551().field_1724 != null);
        return Orientation.of(class_310.method_1551().field_1724.method_5735());
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public Orientation getOpposite() {
        return Orientation.byId(this.idOpposite);
    }

    public boolean in(Layer layer) {
        return this.layer == layer;
    }

    public static Orientation byId(int id) {
        return ALL[Math.abs(id % ALL.length)];
    }

    private static /* synthetic */ Orientation[] $values() {
        return new Orientation[]{CENTER, NORTH, SOUTH, EAST, WEST, NORTH_EAST, NORTH_WEST, SOUTH_EAST, SOUTH_WEST, UP, DOWN, UPPER_NORTH, UPPER_SOUTH, UPPER_EAST, UPPER_WEST, UPPER_NORTH_EAST, UPPER_NORTH_WEST, UPPER_SOUTH_EAST, UPPER_SOUTH_WEST, LOWER_NORTH, LOWER_SOUTH, LOWER_EAST, LOWER_WEST, LOWER_NORTH_EAST, LOWER_NORTH_WEST, LOWER_SOUTH_EAST, LOWER_SOUTH_WEST};
    }

    static {
        $VALUES = Orientation.$values();
        ALL = (Orientation[])Arrays.stream(Orientation.values()).sorted(Comparator.comparingInt(direction -> direction.id)).toArray(Orientation[]::new);
    }

    public static enum Layer {
        UPPER,
        MIDDLE,
        LOWER;

    }
}

