/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess;

import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import lombok.Generated;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.NarratorStatus;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.level.GameType;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.util.Strings;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.features.AutoLibrarySetup;
import org.mcaccess.minecraftaccess.features.BiomeIndicator;
import org.mcaccess.minecraftaccess.features.CameraControls;
import org.mcaccess.minecraftaccess.features.FacingDirection;
import org.mcaccess.minecraftaccess.features.FallDetector;
import org.mcaccess.minecraftaccess.features.FluidDetector;
import org.mcaccess.minecraftaccess.features.HUDStatus;
import org.mcaccess.minecraftaccess.features.MenuFix;
import org.mcaccess.minecraftaccess.features.MouseKeySimulation;
import org.mcaccess.minecraftaccess.features.NarrateHeldItem;
import org.mcaccess.minecraftaccess.features.PlayerStatus;
import org.mcaccess.minecraftaccess.features.PlayerWarnings;
import org.mcaccess.minecraftaccess.features.PositionNarrator;
import org.mcaccess.minecraftaccess.features.XPIndicator;
import org.mcaccess.minecraftaccess.features.access_menu.AccessMenu;
import org.mcaccess.minecraftaccess.features.inventory_controls.InventoryControls;
import org.mcaccess.minecraftaccess.features.narrate_crosshair.NarrateCrosshair;
import org.mcaccess.minecraftaccess.features.point_of_interest.POIManager;
import org.mcaccess.minecraftaccess.mixin.GameNarratorAccessor;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderController;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderInterface;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;
import org.mcaccess.minecraftaccess.utils.condition.Keystroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MainClass {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MainClass.class);
    private static final Minecraft CLIENT = Minecraft.getInstance();
    public static final String MOD_ID = "minecraft_access";
    private static ScreenReaderInterface screenReader = null;
    public static AccessMenu accessMenu = null;
    public static BiomeIndicator biomeIndicator = null;
    public static FacingDirection facingDirection = null;
    public static FallDetector fallDetector = null;
    public static FluidDetector fluidDetector = null;
    public static HUDStatus hudStatus = null;
    public static InventoryControls inventoryControls = null;
    public static NarrateCrosshair narrateCrosshair = null;
    public static NarrateHeldItem narrateHeldItem = null;
    public static PlayerStatus playerStatus = null;
    public static PlayerWarnings playerWarnings = null;
    public static POIManager poiManager = null;
    public static XPIndicator xpIndicator = null;

    private MainClass() {
    }

    public static void init() {
        Config.init();
        String startupMessage = "Initializing Minecraft Access: version " + Platform.getMod((String)MOD_ID).getVersion();
        log.info(startupMessage);
        new AutoLibrarySetup().initialize();
        ScreenReaderController.refreshScreenReader();
        if (MainClass.getScreenReader() != null && MainClass.getScreenReader().isInitialized()) {
            MainClass.getScreenReader().narrate(startupMessage, true);
        }
        for (KeyBindingsHandler.Keys key : KeyBindingsHandler.Keys.values()) {
            KeyMappingRegistry.register((KeyMapping)key.mapping);
        }
        ClientTickEvent.CLIENT_POST.register(MainClass::clientTickEventsMethod);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(MainClass::initWorldState);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (MainClass.getScreenReader() != null && MainClass.getScreenReader().isInitialized()) {
                MainClass.getScreenReader().closeScreenReader();
            }
        }, "Shutdown-thread"));
    }

    public static void clientTickEventsMethod(Minecraft client) {
        Config config = Config.getInstance();
        MainClass.changeLogLevelBaseOnDebugConfig();
        if (config.menuFixEnabled) {
            MenuFix.tick(client);
        }
        if (client.level == null || client.player == null) {
            Keystroke.updateInstances();
            return;
        }
        narrateCrosshair.tick();
        facingDirection.tick();
        PositionNarrator.getINSTANCE().tick();
        poiManager.tick();
        fallDetector.tick();
        hudStatus.tick();
        if (client.screen == null || !(client.screen.getFocused() instanceof EditBox) && !(client.screen instanceof KeyBindsScreen)) {
            MouseKeySimulation.tick();
        }
        if (inventoryControls != null && config.inventoryControls.enabled) {
            inventoryControls.tick();
        }
        assert (client.gameMode != null);
        GameType mode = client.gameMode.getPlayerMode();
        if (xpIndicator != null && config.features.xpIndicatorEnabled && (mode == GameType.SURVIVAL || mode == GameType.ADVENTURE)) {
            xpIndicator.tick();
        }
        if (biomeIndicator != null && config.features.biomeIndicatorEnabled) {
            biomeIndicator.tick();
        }
        if (playerStatus != null) {
            playerStatus.tick();
        }
        if (client.screen == null) {
            CameraControls.tick();
        }
        if (playerWarnings != null) {
            if (config.playerWarnings.enabled && (mode == GameType.SURVIVAL || mode == GameType.ADVENTURE)) {
                playerWarnings.tick();
            }
            if (config.playerWarnings.durabilityWarnings.enableHeldItems || config.playerWarnings.durabilityWarnings.enableWornArmor) {
                playerWarnings.durabilityWarnings();
            }
        }
        if (accessMenu != null && config.accessMenu.enabled) {
            accessMenu.tick();
        }
        if (mode != GameType.SPECTATOR) {
            narrateHeldItem.tick();
        }
        Keystroke.updateInstances();
    }

    private static void initWorldState(LocalPlayer player) {
        accessMenu = new AccessMenu();
        biomeIndicator = new BiomeIndicator();
        facingDirection = new FacingDirection();
        fallDetector = new FallDetector();
        fluidDetector = new FluidDetector();
        hudStatus = new HUDStatus();
        inventoryControls = new InventoryControls();
        narrateCrosshair = new NarrateCrosshair();
        narrateHeldItem = new NarrateHeldItem();
        playerStatus = new PlayerStatus();
        playerWarnings = new PlayerWarnings();
        poiManager = new POIManager();
        xpIndicator = new XPIndicator();
        if (MainClass.CLIENT.options.keyAdvancements.same(KeyBindingsHandler.Keys.CAMERA_CONTROLS_RIGHT.mapping)) {
            MainClass.CLIENT.options.keyAdvancements.setKey(InputConstants.Type.KEYSYM.getOrCreate(79));
            MainClass.CLIENT.options.save();
            MainClass.CLIENT.options.load();
            log.info("Rebound advancements key");
        }
    }

    private static void changeLogLevelBaseOnDebugConfig() {
        boolean debugMode;
        boolean bl = debugMode = Config.getInstance().debugMode || Platform.isDevelopmentEnvironment();
        if (debugMode) {
            if (!log.isDebugEnabled()) {
                Configurator.setLevel((String)"org.mcaccess.minecraftaccess", (Level)Level.DEBUG);
            }
        } else if (log.isDebugEnabled()) {
            Configurator.setLevel((String)"org.mcaccess.minecraftaccess", (Level)Level.INFO);
        }
    }

    public static void setScreenReader(ScreenReaderInterface screenReader) {
        MainClass.screenReader = screenReader;
    }

    public static void narrate(String text, boolean interrupt) {
        if (Strings.isEmpty((CharSequence)text) || !CLIENT.isWindowActive()) {
            log.warn("The narration of string \"{}\" with interrupt={} was suppressed", (Object)text, (Object)interrupt);
            return;
        }
        if (MainClass.CLIENT.options.narrator().get() != NarratorStatus.OFF) {
            ((GameNarratorAccessor)CLIENT.getNarrator()).invokeNarrateMessage(text, interrupt);
        }
    }

    @Generated
    public static ScreenReaderInterface getScreenReader() {
        return screenReader;
    }
}

