/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.compat.mixin.clothconfig;

import java.util.List;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.gui.AbstractTabbedConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigTabButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.mixin.ScreenAccessor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClothConfigScreen.class}, remap=false)
abstract class ClothConfigScreenMixin
extends AbstractTabbedConfigScreen {
    @Shadow
    @Final
    private List<ClothConfigTabButton> tabButtons;
    @Shadow
    private AbstractWidget buttonRightTab;
    @Shadow
    private AbstractWidget buttonLeftTab;
    @Shadow
    public ClothConfigScreen.ListWidget<AbstractConfigEntry<AbstractConfigEntry<?>>> listWidget;

    ClothConfigScreenMixin(Screen parent, Component title, ResourceLocation backgroundLocation) {
        super(parent, title, backgroundLocation);
    }

    @Shadow
    public abstract Component getSelectedCategory();

    @Inject(at={@At(value="TAIL")}, method={"init()V"}, remap=true)
    private void addComponentsAsNarratables(CallbackInfo ci) {
        List<NarratableEntry> narratables = ((ScreenAccessor)((Object)this)).getNarratables();
        if (this.listWidget != null) {
            narratables.addAll(this.listWidget.children());
        }
        narratables.addAll(this.tabButtons);
    }

    protected void setInitialFocus() {
    }

    @NotNull
    public Component getNarrationMessage() {
        return super.getNarrationMessage().copy().append(I18n.get((String)"minecraft_access.other.words_connection", (Object[])new Object[0])).append(this.getSelectedCategory());
    }

    public boolean keyPressed(KeyEvent event) {
        if (Minecraft.getInstance().hasControlDown() && event.key() == 258) {
            this.switchCategory(!Minecraft.getInstance().hasShiftDown());
            return true;
        }
        return super.keyPressed(event);
    }

    @Unique
    private void switchCategory(boolean forward) {
        int nextIndex = this.selectedCategoryIndex + (forward ? 1 : -1);
        if (nextIndex < 0 || nextIndex >= this.tabButtons.size()) {
            MainClass.narrate(I18n.get((String)"minecraft_access.other.reached_the_border", (Object[])new Object[0]), true);
            return;
        }
        ClothConfigTabButton tabButton = this.tabButtons.get(nextIndex);
        if (tabButton.isMouseOver((double)(tabButton.getX() + 1), (double)(tabButton.getY() + 1))) {
            tabButton.mouseClicked(new MouseButtonEvent((double)(tabButton.getX() + 1), (double)(tabButton.getY() + 1), new MouseButtonInfo(0, 0)), false);
        } else {
            AbstractWidget arrowButton = forward ? this.buttonRightTab : this.buttonLeftTab;
            arrowButton.mouseClicked(new MouseButtonEvent((double)(arrowButton.getX() + 1), (double)(arrowButton.getY() + 1), new MouseButtonInfo(0, 0)), false);
            tabButton.onPress((InputWithModifiers)new MouseButtonInfo(0, 0));
        }
    }
}

