/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features;

import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiomeIndicator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BiomeIndicator.class);
    @Nullable
    private Holder<Biome> previousBiome = null;

    public void tick() {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        if (client.player == null) {
            return;
        }
        if (client.screen != null) {
            return;
        }
        BlockPos pos = client.player.blockPosition();
        LevelChunk currentChunk = client.level.getChunkSource().getChunk(pos.getX() >> 4, pos.getZ() >> 4, false);
        if (currentChunk == null) {
            return;
        }
        Holder currentBiome = client.level.getBiome(client.player.blockPosition());
        if (currentBiome != this.previousBiome) {
            this.previousBiome = currentBiome;
            NarrationUtils.getTranslatedName(currentBiome, "biome").ifPresent(name -> MainClass.narrate(I18n.get((String)"minecraft_access.other.biome", (Object[])new Object[]{name}), true));
        }
    }
}

