/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;
import org.mcaccess.minecraftaccess.utils.condition.DoubleClick;
import org.mcaccess.minecraftaccess.utils.condition.Interval;
import org.mcaccess.minecraftaccess.utils.position.Orientation;
import org.mcaccess.minecraftaccess.utils.position.PlayerPositionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CameraControls {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CameraControls.class);
    private static final Minecraft CLIENT = Minecraft.getInstance();
    private static CameraConfig config;
    private static final Interval INTERVAL;
    private static final DoubleClick straightUpDoubleClick;
    private static final DoubleClick straightDownDoubleClick;

    private CameraControls() {
    }

    public static void tick() {
        if (!INTERVAL.isReady()) {
            return;
        }
        CameraControls.loadConfigurations();
        CameraControls.keyListener();
    }

    private static void loadConfigurations() {
        Config.CameraControls config = Config.getInstance().cameraControls;
        CameraControls.config = new CameraConfig(config);
        INTERVAL.setDelay(config.delayMilliseconds, Interval.Unit.MILLISECOND);
    }

    private static void keyListener() {
        float rotateAngle;
        boolean isLeftAltPressed = InputConstants.isKeyDown((Window)CLIENT.getWindow(), (int)342);
        boolean isRightAltPressed = InputConstants.isKeyDown((Window)CLIENT.getWindow(), (int)346);
        boolean isUpKeyPressed = KeyBindingsHandler.Keys.CAMERA_CONTROLS_UP.mapping.isDown() || KeyBindingsHandler.Keys.CAMERA_CONTROLS_ALTERNATE_UP.mapping.isDown();
        boolean isRightKeyPressed = KeyBindingsHandler.Keys.CAMERA_CONTROLS_RIGHT.mapping.isDown() || KeyBindingsHandler.Keys.CAMERA_CONTROLS_ALTERNATE_RIGHT.mapping.isDown();
        boolean isDownKeyPressed = KeyBindingsHandler.Keys.CAMERA_CONTROLS_DOWN.mapping.isDown() || KeyBindingsHandler.Keys.CAMERA_CONTROLS_ALTERNATE_DOWN.mapping.isDown();
        boolean isLeftKeyPressed = KeyBindingsHandler.Keys.CAMERA_CONTROLS_LEFT.mapping.isDown() || KeyBindingsHandler.Keys.CAMERA_CONTROLS_ALTERNATE_LEFT.mapping.isDown();
        boolean isNorthKeyPressed = KeyBindingsHandler.Keys.CAMERA_CONTROLS_NORTH.mapping.isDown() || isUpKeyPressed && isRightAltPressed && !isLeftAltPressed;
        boolean isEastKeyPressed = KeyBindingsHandler.Keys.CAMERA_CONTROLS_EAST.mapping.isDown() || isRightKeyPressed && isRightAltPressed && !isLeftAltPressed;
        boolean isWestKeyPressed = KeyBindingsHandler.Keys.CAMERA_CONTROLS_WEST.mapping.isDown() || isLeftKeyPressed && isRightAltPressed && !isLeftAltPressed;
        boolean isSouthKeyPressed = KeyBindingsHandler.Keys.CAMERA_CONTROLS_SOUTH.mapping.isDown() || isDownKeyPressed && isRightAltPressed && !isLeftAltPressed;
        boolean isCenterCameraKeyPressed = KeyBindingsHandler.Keys.CAMERA_CONTROLS_CENTER_CAMERA.mapping.isDown();
        boolean isStraightUpKeyPressed = KeyBindingsHandler.Keys.CAMERA_CONTROLS_STRAIGHT_UP.mapping.isDown();
        boolean isUpKeyDoublePressedWithRightAlt = isRightAltPressed && straightUpDoubleClick.canBeTriggered();
        boolean isStraightDownKeyPressed = KeyBindingsHandler.Keys.CAMERA_CONTROLS_STRAIGHT_DOWN.mapping.isDown();
        boolean isDownKeyDoublePressedWithRightAlt = isRightAltPressed && straightDownDoubleClick.canBeTriggered();
        boolean anyFunctionTriggered = false;
        if (isStraightUpKeyPressed || isUpKeyDoublePressedWithRightAlt) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraTo(Orientation.UP);
        }
        if (isStraightDownKeyPressed || isDownKeyDoublePressedWithRightAlt) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraTo(Orientation.DOWN);
        }
        if (isNorthKeyPressed) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraTo(Orientation.NORTH);
        }
        if (isEastKeyPressed) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraTo(Orientation.EAST);
        }
        if (isWestKeyPressed) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraTo(Orientation.WEST);
        }
        if (isSouthKeyPressed) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraTo(Orientation.SOUTH);
        }
        float f = rotateAngle = isLeftAltPressed ? CameraControls.config.modifiedRotatingAngle : CameraControls.config.normalRotatingAngle;
        if (isUpKeyPressed && !isRightAltPressed) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraBy(rotateAngle, RotatingDirection.UP);
        }
        if (isRightKeyPressed && !isRightAltPressed) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraBy(rotateAngle, RotatingDirection.RIGHT);
        }
        if (isDownKeyPressed && !isRightAltPressed) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraBy(rotateAngle, RotatingDirection.DOWN);
        }
        if (isLeftKeyPressed && !isRightAltPressed) {
            anyFunctionTriggered = true;
            CameraControls.rotateCameraBy(rotateAngle, RotatingDirection.LEFT);
        }
        if (isCenterCameraKeyPressed) {
            anyFunctionTriggered = true;
            CameraControls.centerCamera(isLeftAltPressed);
        }
        INTERVAL.adjustNextReadyTimeBy(anyFunctionTriggered);
    }

    private static void rotateCameraBy(float angle, RotatingDirection direction) {
        if (CameraControls.handleLocking()) {
            return;
        }
        float horizontalAngleDelta = angle * (float)direction.horizontalWight;
        float verticalAngleDelta = angle * (float)direction.verticalWight;
        log.debug("Rotating camera by x:{} y:{}", (Object)Float.valueOf(horizontalAngleDelta), (Object)Float.valueOf(verticalAngleDelta));
        assert (CameraControls.CLIENT.player != null);
        CameraControls.CLIENT.player.turn((double)horizontalAngleDelta, (double)verticalAngleDelta);
        String horizontalDirection = PlayerPositionUtils.getHorizontalFacingDirectionInWords();
        String verticalDirection = PlayerPositionUtils.getVerticalFacingDirectionInWords();
        if (Config.getInstance().features.facingDirectionEnabled) {
            if (direction.isRotatingHorizontal) {
                MainClass.narrate(horizontalDirection, true);
            } else if (verticalDirection != null) {
                MainClass.narrate(verticalDirection, true);
            }
        }
    }

    private static void rotateCameraTo(Orientation direction) {
        if (CameraControls.handleLocking()) {
            return;
        }
        LocalPlayer player = CameraControls.CLIENT.player;
        assert (player != null);
        Vec3 playerBlockPosition = player.position();
        Vec3 targetBlockPosition = playerBlockPosition.add(Vec3.atLowerCornerOf((Vec3i)direction.vector));
        player.lookAt(EntityAnchorArgument.Anchor.FEET, targetBlockPosition);
        log.debug("Rotating camera to: {}", (Object)direction.name());
        if (Config.getInstance().features.facingDirectionEnabled) {
            if (direction.in(Orientation.Layer.MIDDLE)) {
                MainClass.narrate(PlayerPositionUtils.getHorizontalFacingDirectionInWords(), true);
            } else {
                MainClass.narrate(PlayerPositionUtils.getVerticalFacingDirectionInWords(), true);
            }
        }
    }

    private static void centerCamera(boolean lookOpposite) {
        if (CameraControls.handleLocking()) {
            return;
        }
        Orientation o = PlayerPositionUtils.getHorizontalFacing();
        CameraControls.rotateCameraTo(lookOpposite ? o.getOpposite() : o);
    }

    private static boolean handleLocking() {
        if (!MainClass.poiManager.lockingHandler.isPlayerLocked() && CLIENT.getCameraEntity().is((Entity)CameraControls.CLIENT.player)) {
            return false;
        }
        MainClass.narrate(I18n.get((String)"minecraft_access.other.camera_locked", (Object[])new Object[0]), true);
        return true;
    }

    static {
        INTERVAL = Interval.defaultDelay();
        straightUpDoubleClick = new DoubleClick(() -> KeyBindingsHandler.Keys.CAMERA_CONTROLS_UP.mapping.isDown());
        straightDownDoubleClick = new DoubleClick(() -> KeyBindingsHandler.Keys.CAMERA_CONTROLS_DOWN.mapping.isDown());
    }

    private record CameraConfig(float normalRotatingAngle, float modifiedRotatingAngle) {
        static final float DELTA_90_DEGREES = 600.0f;

        private CameraConfig(Config.CameraControls config) {
            this(600.0f / (90.0f / config.normalRotatingAngle), 600.0f / (90.0f / config.modifiedRotatingAngle));
        }
    }

    private static enum RotatingDirection {
        UP(0, -1),
        DOWN(0, 1),
        LEFT(-1, 0),
        RIGHT(1, 0);

        final int horizontalWight;
        final int verticalWight;
        final boolean isRotatingHorizontal;

        private RotatingDirection(int horizontalWight, int verticalWight) {
            this.horizontalWight = horizontalWight;
            this.verticalWight = verticalWight;
            this.isRotatingHorizontal = horizontalWight != 0;
        }
    }
}

