/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features;

import java.time.Clock;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import org.mcaccess.minecraftaccess.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallDetector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FallDetector.class);
    private final Clock clock;
    private long previousTimeInMillis;
    private final Minecraft client = Minecraft.getInstance();
    private int count;
    private Config.FallDetector config;

    public FallDetector() {
        this.clock = Clock.systemDefaultZone();
        this.previousTimeInMillis = this.clock.millis();
        this.config = Config.getInstance().fallDetector;
    }

    public void tick() {
        this.config = Config.getInstance().fallDetector;
        if (!this.config.enabled) {
            return;
        }
        if (this.client.player == null) {
            return;
        }
        if (this.client.screen != null) {
            return;
        }
        if (!this.client.player.onGround()) {
            return;
        }
        if (this.client.player.isUnderWater()) {
            return;
        }
        if (this.client.player.isSwimming()) {
            return;
        }
        if (this.client.player.isVisuallySwimming()) {
            return;
        }
        long currentTimeInMillis = this.clock.millis();
        if (currentTimeInMillis - this.previousTimeInMillis < (long)this.config.delay) {
            return;
        }
        this.previousTimeInMillis = currentTimeInMillis;
        log.trace("Searching for fall in nearby area...");
        this.searchNearbyPositions();
        log.trace("Searching ended");
    }

    private void searchNearbyPositions() {
        if (this.client.level == null) {
            return;
        }
        assert (this.client.player != null);
        BlockPos center = this.client.player.blockPosition();
        LinkedList<BlockPos> toSearch = new LinkedList<BlockPos>();
        HashSet<BlockPos> searched = new HashSet<BlockPos>();
        int[] dirX = new int[]{-1, 0, 1, 0};
        int[] dirZ = new int[]{0, 1, 0, -1};
        this.count = 0;
        toSearch.add(center);
        searched.add(center);
        while (!toSearch.isEmpty()) {
            BlockPos item = (BlockPos)toSearch.poll();
            this.checkForFall(item);
            for (int i = 0; i < 4; ++i) {
                BlockPos dir = new BlockPos(item.getX() + dirX[i], item.getY(), item.getZ() + dirZ[i]);
                if (!this.isValid(dir, center, searched)) continue;
                toSearch.add(dir);
                searched.add(dir);
            }
        }
    }

    private boolean isValid(BlockPos dir, BlockPos center, Set<BlockPos> searched) {
        if (Math.abs(dir.getX() - center.getX()) > this.config.range) {
            return false;
        }
        if (Math.abs(dir.getZ() - center.getZ()) > this.config.range) {
            return false;
        }
        return !searched.contains(dir);
    }

    private void checkForFall(BlockPos toCheck) {
        assert (this.client.level != null);
        if (!this.client.level.getBlockState(toCheck).isAir()) {
            return;
        }
        if (this.getDepth(toCheck, this.config.depth) < this.config.depth) {
            return;
        }
        ++this.count;
        log.debug("{}) Found qualified fall position: x:{} y:{} z:{}", new Object[]{this.count, toCheck.getX(), toCheck.getY(), toCheck.getZ()});
        this.client.level.playLocalSound(toCheck, SoundEvents.ANVIL_HIT, SoundSource.BLOCKS, this.config.volume, 1.0f, true);
    }

    private int getDepth(BlockPos blockPos, int maxDepth) {
        if (maxDepth <= 0) {
            return 0;
        }
        assert (this.client.level != null);
        if (!this.client.level.getBlockState(blockPos).isAir()) {
            return 0;
        }
        return 1 + this.getDepth(blockPos.below(), maxDepth - 1);
    }
}

