/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features;

import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluidDetector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FluidDetector.class);

    public void findClosestWaterSource(boolean closeCurrentlyOpenedScreen) {
        if (closeCurrentlyOpenedScreen && Minecraft.getInstance().screen != null && Minecraft.getInstance().player != null) {
            Minecraft.getInstance().player.clientSideCloseContainer();
        }
        log.debug("Finding closest water source");
        this.findClosestFluidSource(true);
    }

    public void findClosestLavaSource(boolean closeCurrentlyOpenedScreen) {
        if (closeCurrentlyOpenedScreen && Minecraft.getInstance().screen != null && Minecraft.getInstance().player != null) {
            Minecraft.getInstance().player.clientSideCloseContainer();
        }
        log.debug("Finding closest lava source");
        this.findClosestFluidSource(false);
    }

    private void findClosestFluidSource(boolean water) {
        int posZ;
        int posY;
        Minecraft minecraftClient = Minecraft.getInstance();
        if (minecraftClient.level == null) {
            return;
        }
        if (minecraftClient.player == null) {
            return;
        }
        Config.AccessMenu.FluidDetector config = Config.getInstance().accessMenu.fluidDetector;
        BlockPos pos = minecraftClient.player.blockPosition();
        int posX = pos.getX();
        BlockPos startingPointPos = new BlockPos(new Vec3i(posX, posY = pos.getY(), posZ = pos.getZ()));
        BlockPos closestFluidPos = FluidDetector.findFluid(minecraftClient, startingPointPos, config.range, water);
        if (closestFluidPos == null) {
            log.debug("Unable to find closest fluid source");
            MainClass.narrate(I18n.get((String)"minecraft_access.other.not_found", (Object[])new Object[0]), true);
            return;
        }
        log.debug("{FluidDetector} playing sound at %dx %dy %dz".formatted(closestFluidPos.getX(), closestFluidPos.getY(), closestFluidPos.getZ()));
        minecraftClient.level.playSound((Entity)minecraftClient.player, closestFluidPos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, config.volume, 1.0f);
        String posDifference = NarrationUtils.narrateRelativePositionOfPlayerAnd(closestFluidPos);
        String name = minecraftClient.level.getBlockState(closestFluidPos).getBlock().getName().getString();
        MainClass.narrate(name + ", " + posDifference, true);
    }

    private static BlockPos findFluid(Minecraft minecraftClient, BlockPos blockPos, int range, boolean water) {
        boolean rightTarget;
        if (minecraftClient.level == null) {
            return null;
        }
        if (minecraftClient.player == null) {
            return null;
        }
        BlockState blockState = minecraftClient.level.getBlockState(blockPos);
        if (blockState.is(Blocks.VOID_AIR)) {
            return null;
        }
        FluidState fluidState = minecraftClient.level.getFluidState(blockPos);
        boolean bl = rightTarget = fluidState.is(FluidTags.LAVA) && !water || fluidState.is(FluidTags.WATER) && water;
        if (rightTarget && fluidState.isSource()) {
            return blockPos;
        }
        if (range - 1 >= 0 && blockState.isAir()) {
            int posX = blockPos.getX();
            int posY = blockPos.getY();
            int posZ = blockPos.getZ();
            int rangeVal = range - 1;
            BlockPos bp1 = FluidDetector.findFluid(minecraftClient, new BlockPos(new Vec3i(posX, posY, posZ - 1)), rangeVal, water);
            BlockPos bp2 = FluidDetector.findFluid(minecraftClient, new BlockPos(new Vec3i(posX, posY, posZ + 1)), rangeVal, water);
            BlockPos bp3 = FluidDetector.findFluid(minecraftClient, new BlockPos(new Vec3i(posX - 1, posY, posZ)), rangeVal, water);
            BlockPos bp4 = FluidDetector.findFluid(minecraftClient, new BlockPos(new Vec3i(posX + 1, posY, posZ)), rangeVal, water);
            BlockPos bp5 = FluidDetector.findFluid(minecraftClient, new BlockPos(new Vec3i(posX, posY - 1, posZ)), rangeVal, water);
            BlockPos bp6 = FluidDetector.findFluid(minecraftClient, new BlockPos(new Vec3i(posX, posY + 1, posZ)), rangeVal, water);
            if (bp1 != null) {
                return bp1;
            }
            if (bp2 != null) {
                return bp2;
            }
            if (bp3 != null) {
                return bp3;
            }
            if (bp4 != null) {
                return bp4;
            }
            if (bp5 != null) {
                return bp5;
            }
            return bp6;
        }
        return null;
    }
}

