/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features;

import java.util.ArrayList;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.GameType;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.mixin.BossHealthOverlayAccessor;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;

public class HUDStatus {
    private final Minecraft client = Minecraft.getInstance();
    private Boolean hudWasHidden;
    private boolean attackCooldownPlayed;
    private boolean bossbarKeyIsDown;
    private int bossIndex;

    public HUDStatus() {
        this.hudWasHidden = Minecraft.getInstance().options.hideGui;
        this.attackCooldownPlayed = false;
        this.bossbarKeyIsDown = false;
        this.bossIndex = 0;
    }

    public void tick() {
        this.hudVisibilityStatus();
        this.attackCooldownStatus();
        if (KeyBindingsHandler.Keys.NARRATE_BOSSBARS_KEY.mapping.consumeClick()) {
            if (!this.bossbarKeyIsDown) {
                this.bossbarKeyIsDown = true;
                this.narrateBossBars();
            }
        } else if (!KeyBindingsHandler.Keys.NARRATE_BOSSBARS_KEY.mapping.isDown()) {
            this.bossbarKeyIsDown = false;
        }
    }

    private void hudVisibilityStatus() {
        Boolean hudIsHidden = this.client.options.hideGui;
        if (this.hudWasHidden != hudIsHidden) {
            MainClass.narrate(I18n.get((String)String.format("minecraft_access.hud_status.announce_%s", hudIsHidden != false ? "hidden" : "shown"), (Object[])new Object[0]), true);
            this.hudWasHidden = hudIsHidden;
        }
    }

    private void attackCooldownStatus() {
        boolean indicatorShowing;
        boolean bl = indicatorShowing = this.hudWasHidden == false && this.client.options.attackIndicator().get() != AttackIndicatorStatus.OFF && this.client.gameMode.getPlayerMode() != GameType.SPECTATOR;
        if (!indicatorShowing) {
            return;
        }
        LocalPlayer player = this.client.player;
        if (player == null) {
            return;
        }
        float cooldownProgress = player.getAttackStrengthScale(1.0f);
        if (!this.attackCooldownPlayed && cooldownProgress == 1.0f) {
            player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_HAT.value(), SoundSource.PLAYERS, 0.6f, 1.0f);
            this.attackCooldownPlayed = true;
        } else if (this.attackCooldownPlayed && cooldownProgress < 1.0f) {
            this.attackCooldownPlayed = false;
        }
    }

    private void narrateBossBars() {
        ArrayList<LerpingBossEvent> bosses = new ArrayList<LerpingBossEvent>(((BossHealthOverlayAccessor)this.client.gui.getBossOverlay()).getEvents().values());
        if (bosses.isEmpty()) {
            MainClass.narrate(I18n.get((String)"minecraft_access.other.no_bossbars", (Object[])new Object[0]), true);
            return;
        }
        this.bossIndex = (this.bossIndex + 1) % bosses.size();
        LerpingBossEvent currentBoss = (LerpingBossEvent)bosses.get(this.bossIndex);
        String name = currentBoss.getName().getString();
        int healthPercent = Math.round(currentBoss.getProgress() * 100.0f);
        MainClass.narrate(I18n.get((String)"minecraft_access.other.bossbar_status", (Object[])new Object[]{name, healthPercent}), true);
    }
}

