/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.Set;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DirectJoinServerScreen;
import net.minecraft.client.gui.screens.ManageServerScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.options.AccessibilityOptionsScreen;
import net.minecraft.client.gui.screens.options.ChatOptionsScreen;
import net.minecraft.client.gui.screens.options.LanguageSelectScreen;
import net.minecraft.client.gui.screens.options.MouseSettingsScreen;
import net.minecraft.client.gui.screens.options.OnlineOptionsScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.gui.screens.options.SkinCustomizationScreen;
import net.minecraft.client.gui.screens.options.SoundOptionsScreen;
import net.minecraft.client.gui.screens.options.VideoSettingsScreen;
import net.minecraft.client.gui.screens.options.controls.ControlsScreen;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.utils.system.MouseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MenuFix {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MenuFix.class);
    private static Class<? extends Screen> prevScreenClass = TitleScreen.class;
    private static final Set<Class<? extends Screen>> MENUS_NEED_FIX = Set.of(TitleScreen.class, OptionsScreen.class, ControlsScreen.class, OnlineOptionsScreen.class, SkinCustomizationScreen.class, SoundOptionsScreen.class, VideoSettingsScreen.class, LanguageSelectScreen.class, ChatOptionsScreen.class, PackSelectionScreen.class, AccessibilityOptionsScreen.class, MouseSettingsScreen.class, KeyBindsScreen.class, SelectWorldScreen.class, CreateWorldScreen.class, EditWorldScreen.class, JoinMultiplayerScreen.class, DirectJoinServerScreen.class, ManageServerScreen.class);

    private MenuFix() {
    }

    public static void tick(Minecraft client) {
        if (!Config.getInstance().menuFixEnabled || client.screen == null) {
            return;
        }
        Class<?> currentScreen = client.screen.getClass();
        if (MENUS_NEED_FIX.contains(currentScreen)) {
            if (prevScreenClass != currentScreen) {
                log.debug("Performing menu fix on {}", (Object)client.screen.getTitle().getString());
                MenuFix.moveMouseCursor();
                prevScreenClass = currentScreen;
            }
            if (InputConstants.isKeyDown((Window)client.getWindow(), (int)82) && client.hasAltDown()) {
                MenuFix.moveMouseCursor();
            }
        }
    }

    private static void moveMouseCursor() {
        MouseUtils.moveAndLeftClick(10, 10);
    }
}

