/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Tuple;
import org.apache.commons.lang3.tuple.Triple;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.mixin.KeyMappingAccessor;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;
import org.mcaccess.minecraftaccess.utils.condition.Interval;
import org.mcaccess.minecraftaccess.utils.condition.IntervalKeystroke;
import org.mcaccess.minecraftaccess.utils.condition.Keystroke;
import org.mcaccess.minecraftaccess.utils.system.MouseUtils;

public final class MouseKeySimulation {
    private static final Keystroke[] MOUSE_CLICKS = new Keystroke[]{new Keystroke(() -> MouseKeySimulation.isKeyPressed(KeyBindingsHandler.Keys.MOUSE_SIMULATION_LEFT_MOUSE_KEY.mapping)), new Keystroke(() -> MouseKeySimulation.isKeyPressed(KeyBindingsHandler.Keys.MOUSE_SIMULATION_MIDDLE_MOUSE_KEY.mapping)), new Keystroke(() -> MouseKeySimulation.isKeyPressed(KeyBindingsHandler.Keys.MOUSE_SIMULATION_RIGHT_MOUSE_KEY.mapping))};
    public static final Set<Triple<Keystroke, Runnable, Runnable>> MOUSE_CLICK_ACTIONS = Set.of(Triple.of((Object)MOUSE_CLICKS[0], MouseUtils.Key.LEFT::press, MouseUtils.Key.LEFT::release), Triple.of((Object)MOUSE_CLICKS[1], MouseUtils.Key.MIDDLE::press, MouseUtils.Key.MIDDLE::release), Triple.of((Object)MOUSE_CLICKS[2], MouseUtils.Key.RIGHT::press, MouseUtils.Key.RIGHT::release));
    private static final IntervalKeystroke[] MOUSE_SCROLLS = new IntervalKeystroke[]{new IntervalKeystroke(KeyBindingsHandler.Keys.MOUSE_SIMULATION_SCROLL_UP_KEY.mapping), new IntervalKeystroke(KeyBindingsHandler.Keys.MOUSE_SIMULATION_SCROLL_DOWN_KEY.mapping)};
    public static final Set<Tuple<IntervalKeystroke, Runnable>> MOUSE_SCROLL_ACTIONS = Set.of(new Tuple((Object)MOUSE_SCROLLS[0], MouseUtils.Wheel.UP::scroll), new Tuple((Object)MOUSE_SCROLLS[1], MouseUtils.Wheel.DOWN::scroll));

    private MouseKeySimulation() {
    }

    private static void loadConfig() {
        Config.MouseSimulation config = Config.getInstance().mouseSimulation;
        MouseKeySimulation.MOUSE_SCROLLS[0].interval.setDelay(config.scrollDelayMilliseconds, Interval.Unit.MILLISECOND);
        MouseKeySimulation.MOUSE_SCROLLS[1].interval.setDelay(config.scrollDelayMilliseconds, Interval.Unit.MILLISECOND);
    }

    public static void tick() {
        MouseKeySimulation.loadConfig();
        MOUSE_SCROLL_ACTIONS.forEach(t -> {
            if (((IntervalKeystroke)t.getA()).canBeTriggered()) {
                ((Runnable)t.getB()).run();
            }
        });
        MOUSE_CLICK_ACTIONS.forEach(t -> {
            if (((Keystroke)t.getLeft()).isPressed()) {
                ((Runnable)t.getMiddle()).run();
            } else if (((Keystroke)t.getLeft()).isReleased()) {
                ((Runnable)t.getRight()).run();
            }
        });
    }

    private static boolean isKeyPressed(KeyMapping keyMapping) {
        if (keyMapping.isUnbound()) {
            return false;
        }
        return InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)((KeyMappingAccessor)keyMapping).getKey().getValue());
    }
}

