/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxPlayable;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;

public class NarrateHeldItem {
    private String previousItemName = "";
    private int previousItemCount = 0;
    private int previousSelectedSlot = 0;

    public void tick() {
        boolean slotChanged;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        while (KeyBindingsHandler.Keys.NARRATE_HELD_ITEM_KEY.mapping.consumeClick()) {
            this.narrateHand(Minecraft.getInstance().hasAltDown());
        }
        ItemStack currentItemStack = player.getMainHandItem();
        int selectedSlot = player.getInventory().getSelectedSlot();
        String baseItemName = this.getItemName(currentItemStack);
        int itemCount = currentItemStack.getCount();
        String itemNameWithCount = currentItemStack.getCount() != 1 && !currentItemStack.isEmpty() ? itemCount + " " + baseItemName : baseItemName;
        boolean nameChanged = !this.previousItemName.equals(baseItemName);
        boolean countChanged = itemCount != this.previousItemCount;
        boolean bl = slotChanged = selectedSlot != this.previousSelectedSlot;
        if (nameChanged || slotChanged) {
            MainClass.narrate(I18n.get((String)"minecraft_access.other.selected", (Object[])new Object[]{itemNameWithCount}), true);
        } else if (countChanged && Config.getInstance().features.narrateHeldItemsCountWhenChanged) {
            MainClass.narrate(String.valueOf(itemCount), true);
        }
        this.previousItemName = baseItemName;
        this.previousItemCount = itemCount;
        this.previousSelectedSlot = selectedSlot;
    }

    private String getItemName(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return I18n.get((String)"minecraft_access.inventory_controls.empty_slot", (Object[])new Object[]{""});
        }
        StringBuilder itemName = new StringBuilder();
        itemName.append(itemStack.getHoverName().getString());
        Optional.ofNullable((JukeboxPlayable)itemStack.get(DataComponents.JUKEBOX_PLAYABLE)).flatMap(jukeboxPlayable -> jukeboxPlayable.song().key()).ifPresent(discNumber -> itemName.append(' ').append(I18n.get((String)("jukebox_song.minecraft." + discNumber.location().getPath()), (Object[])new Object[0])));
        return itemName.toString();
    }

    private void narrateHand(boolean hasAltDown) {
        ItemStack heldItem;
        String hand;
        LocalPlayer player = Minecraft.getInstance().player;
        if (!hasAltDown) {
            hand = I18n.get((String)"options.mainHand", (Object[])new Object[0]);
            assert (player != null);
            heldItem = player.getMainHandItem();
        } else {
            hand = I18n.get((String)"minecraft_access.other.offhand", (Object[])new Object[0]);
            assert (player != null);
            heldItem = player.getOffhandItem();
        }
        String heldItemName = this.getItemName(heldItem);
        int heldItemCount = heldItem.getCount();
        heldItemName = heldItemCount != 1 && !heldItem.isEmpty() ? heldItemCount + " " + heldItemName : heldItemName;
        MainClass.narrate("%s: %s".formatted(hand, heldItemName), false);
    }
}

