/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.GameType;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.mcaccess.minecraftaccess.utils.condition.Interval;
import org.mcaccess.minecraftaccess.utils.condition.IntervalKeystroke;
import org.mcaccess.minecraftaccess.utils.condition.Keystroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerStatus {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlayerStatus.class);
    private final Minecraft client = Minecraft.getInstance();
    IntervalKeystroke narrationKey = new IntervalKeystroke(() -> KeyBindingsHandler.Keys.NARRATE_PLAYER_STATUS_KEY.mapping.isDown(), Keystroke.TriggeredAt.PRESSED, Interval.ms(3000L));
    private boolean wasSneaking = false;
    private boolean wasSprinting = false;

    public void tick() {
        if (this.client.player == null) {
            return;
        }
        if (this.client.screen != null) {
            return;
        }
        this.movementTypeStatus();
        if (this.narrationKey.canBeTriggered()) {
            if (this.client.hasControlDown()) {
                Collection effects = this.client.player.getActiveEffects();
                if (effects.isEmpty()) {
                    MainClass.narrate(I18n.get((String)"minecraft_access.effect_narration.no_effects", (Object[])new Object[0]), true);
                    return;
                }
                String narration = effects.stream().map(NarrationUtils::narrateEffect).collect(Collectors.joining(I18n.get((String)"minecraft_access.other.words_connection", (Object[])new Object[0])));
                MainClass.narrate(narration, true);
                return;
            }
            double health = (double)Math.round((double)this.client.player.getHealth() / 2.0 * 10.0) / 10.0;
            double maxHealth = (double)Math.round((double)this.client.player.getMaxHealth() / 2.0 * 10.0) / 10.0;
            double absorption = (double)Math.round((double)this.client.player.getAbsorptionAmount() / 2.0 * 10.0) / 10.0;
            double hunger = (double)Math.round((double)this.client.player.getFoodData().getFoodLevel() / 2.0 * 10.0) / 10.0;
            double maxHunger = (double)Math.round(100.0) / 10.0;
            double armor = (double)Math.round((double)this.client.player.getArmorValue() / 2.0 * 10.0) / 10.0;
            double air = (double)Math.round((double)this.client.player.getAirSupply() / 20.0 * 10.0) / 10.0;
            double maxAir = (double)Math.round((double)this.client.player.getMaxAirSupply() / 20.0 * 10.0) / 10.0;
            double frostExposurePercent = (double)Math.round((double)this.client.player.getPercentFrozen() * 100.0 * 10.0) / 10.0;
            assert (this.client.gameMode != null);
            GameType currentMode = this.client.gameMode.getPlayerMode();
            StringBuilder narration = new StringBuilder();
            if (currentMode == GameType.SURVIVAL || currentMode == GameType.ADVENTURE) {
                if (!this.client.hasAltDown()) {
                    if (absorption > 0.0) {
                        narration.append(I18n.get((String)"minecraft_access.player_status.base_with_absorption", (Object[])new Object[]{NarrationUtils.narrateNumber(health), NarrationUtils.narrateNumber(absorption), NarrationUtils.narrateNumber(maxHealth), NarrationUtils.narrateNumber(hunger), NarrationUtils.narrateNumber(maxHunger), NarrationUtils.narrateNumber(armor)}));
                    } else {
                        narration.append(I18n.get((String)"minecraft_access.player_status.base", (Object[])new Object[]{NarrationUtils.narrateNumber(health), NarrationUtils.narrateNumber(maxHealth), NarrationUtils.narrateNumber(hunger), NarrationUtils.narrateNumber(maxHunger), NarrationUtils.narrateNumber(armor)}));
                    }
                }
                if ((this.client.player.isUnderWater() || this.client.player.getAirSupply() < this.client.player.getMaxAirSupply()) && !this.client.player.canBreatheUnderwater()) {
                    air = Math.max(air, 0.0);
                    narration.append(I18n.get((String)"minecraft_access.player_status.air", (Object[])new Object[]{NarrationUtils.narrateNumber(air), NarrationUtils.narrateNumber(maxAir)}));
                }
                if ((this.client.player.isInPowderSnow || frostExposurePercent > 0.0) && this.client.player.canFreeze()) {
                    narration.append(I18n.get((String)"minecraft_access.player_status.frost", (Object[])new Object[]{NarrationUtils.narrateNumber(frostExposurePercent)}));
                }
            }
            if (narration.isEmpty() && (currentMode == GameType.SURVIVAL || currentMode == GameType.ADVENTURE)) {
                narration.append(I18n.get((String)"minecraft_access.player_status.no_conditional_status", (Object[])new Object[0]));
            }
            if (!Objects.equals(narration.toString(), I18n.get((String)"minecraft_access.player_status.no_conditional_status", (Object[])new Object[0]))) {
                this.addGameMode(narration, currentMode);
            }
            MainClass.narrate(narration.toString(), true);
        }
        this.narrationKey.updateStateForNextTick();
    }

    private void movementTypeStatus() {
        boolean isSprinting;
        boolean isSneaking = this.client.player.isCrouching();
        boolean bl = isSprinting = this.client.player.isSprinting() && !isSneaking;
        if (!this.wasSneaking && isSneaking) {
            this.client.player.playNotifySound(SoundEvents.SHOVEL_FLATTEN, SoundSource.PLAYERS, 1.0f, 0.5f);
        } else if (isSprinting && !this.wasSprinting) {
            this.client.player.playNotifySound(SoundEvents.SHOVEL_FLATTEN, SoundSource.PLAYERS, 1.0f, 2.0f);
        } else if (!isSneaking && this.wasSneaking || !isSprinting && this.wasSprinting) {
            this.client.player.playNotifySound(SoundEvents.SHOVEL_FLATTEN, SoundSource.PLAYERS, 1.0f, 0.9f);
        }
        this.wasSneaking = isSneaking;
        this.wasSprinting = isSprinting;
    }

    public void addGameMode(StringBuilder narration, GameType playerMode) {
        if (!narration.isEmpty()) {
            narration.append(I18n.get((String)"minecraft_access.other.words_connection", (Object[])new Object[0]));
        }
        narration.append(switch (playerMode) {
            default -> throw new MatchException(null, null);
            case GameType.SURVIVAL -> {
                if (!$assertionsDisabled && this.client.level == null) {
                    throw new AssertionError();
                }
                if (this.client.level.getLevelData().isHardcore()) {
                    yield I18n.get((String)"gameMode.hardcore", (Object[])new Object[0]);
                }
                yield I18n.get((String)"gameMode.survival", (Object[])new Object[0]);
            }
            case GameType.CREATIVE -> I18n.get((String)"gameMode.creative", (Object[])new Object[0]);
            case GameType.SPECTATOR -> I18n.get((String)"gameMode.spectator", (Object[])new Object[0]);
            case GameType.ADVENTURE -> I18n.get((String)"gameMode.adventure", (Object[])new Object[0]);
        });
        assert (this.client.level != null);
        if (this.client.level.getLevelData().isHardcore() && playerMode != GameType.SURVIVAL) {
            narration.append(' ').append(I18n.get((String)"options.difficulty.hardcore", (Object[])new Object[0]));
        }
    }
}

