/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features;

import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerWarnings {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlayerWarnings.class);
    private final Minecraft client = Minecraft.getInstance();
    private LocalPlayer player;
    private boolean isHealthBelowFirstThreshold;
    private boolean isHealthBelowSecondThreshold;
    private boolean isFoodBelowThreshold;
    private boolean isAirBelowThreshold;
    private boolean isFrostAboveThreshold;
    private DurabilityWarningStatus lastMainHandStatus = DurabilityWarningStatus.NONE;
    private DurabilityWarningStatus lastOffHandStatus = DurabilityWarningStatus.NONE;
    private DurabilityWarningStatus lastHeadStatus = DurabilityWarningStatus.NONE;
    private DurabilityWarningStatus lastChestStatus = DurabilityWarningStatus.NONE;
    private DurabilityWarningStatus lastLegsStatus = DurabilityWarningStatus.NONE;
    private DurabilityWarningStatus lastFeetStatus = DurabilityWarningStatus.NONE;
    private static final Config.PlayerWarnings CONFIG = Config.getInstance().playerWarnings;

    public void tick() {
        this.player = this.client.player;
        this.healthWarning();
        this.hungerWarning();
        this.airWarning();
        this.frostWarning();
    }

    private void healthWarning() {
        double health = this.player.getHealth() / 2.0f;
        double maxHealth = (double)Math.round((double)this.player.getMaxHealth() / 2.0 * 10.0) / 10.0;
        if (health <= PlayerWarnings.CONFIG.firstHealthThreshold && health > PlayerWarnings.CONFIG.secondHealthThreshold && !this.isHealthBelowFirstThreshold && !this.isHealthBelowSecondThreshold) {
            this.isHealthBelowFirstThreshold = true;
            MainClass.narrate(I18n.get((String)"minecraft_access.player_warnings.health_low", (Object[])new Object[]{NarrationUtils.narrateNumber(health), NarrationUtils.narrateNumber(maxHealth)}), true);
            this.playWarningSound(false);
        }
        if (health <= PlayerWarnings.CONFIG.secondHealthThreshold && health > 0.0 && this.isHealthBelowFirstThreshold && !this.isHealthBelowSecondThreshold) {
            this.isHealthBelowSecondThreshold = true;
            MainClass.narrate(I18n.get((String)"minecraft_access.player_warnings.health_low", (Object[])new Object[]{NarrationUtils.narrateNumber(health), NarrationUtils.narrateNumber(maxHealth)}), true);
            this.playWarningSound(true);
        }
        if (this.isHealthBelowFirstThreshold && health > PlayerWarnings.CONFIG.firstHealthThreshold) {
            this.isHealthBelowFirstThreshold = false;
        }
        if (this.isHealthBelowSecondThreshold && health > PlayerWarnings.CONFIG.secondHealthThreshold) {
            this.isHealthBelowSecondThreshold = false;
        }
    }

    private void hungerWarning() {
        double hunger = this.player.getFoodData().getFoodLevel() / 2;
        double maxHunger = (double)Math.round(100.0) / 10.0;
        if (hunger <= PlayerWarnings.CONFIG.hungerThreshold && hunger > 0.0 && !this.isFoodBelowThreshold) {
            this.isFoodBelowThreshold = true;
            MainClass.narrate(I18n.get((String)"minecraft_access.player_warnings.hunger_low", (Object[])new Object[]{NarrationUtils.narrateNumber(hunger), NarrationUtils.narrateNumber(maxHunger)}), true);
            this.playWarningSound(false);
        }
        if (this.isFoodBelowThreshold && hunger > PlayerWarnings.CONFIG.hungerThreshold) {
            this.isFoodBelowThreshold = false;
        }
    }

    private void airWarning() {
        double air = Math.max((double)this.player.getAirSupply() / 20.0, 0.0);
        double maxAir = (double)Math.round((double)this.player.getMaxAirSupply() / 20.0 * 10.0) / 10.0;
        if (air <= PlayerWarnings.CONFIG.airThreshold && air > 0.0 && !this.isAirBelowThreshold) {
            this.isAirBelowThreshold = true;
            MainClass.narrate(I18n.get((String)"minecraft_access.player_warnings.air_low", (Object[])new Object[]{NarrationUtils.narrateNumber(air), NarrationUtils.narrateNumber(maxAir)}), true);
            this.playWarningSound(false);
        }
        if (this.isAirBelowThreshold && air > PlayerWarnings.CONFIG.airThreshold) {
            this.isAirBelowThreshold = false;
        }
    }

    private void frostWarning() {
        double frostExposurePercent = (double)Math.round((double)this.player.getPercentFrozen() * 100.0 * 10.0) / 10.0;
        if (frostExposurePercent >= PlayerWarnings.CONFIG.frostThreshold && frostExposurePercent < 100.0 && !this.isFrostAboveThreshold) {
            this.isFrostAboveThreshold = true;
            MainClass.narrate(I18n.get((String)"minecraft_access.player_warnings.frost_low", (Object[])new Object[]{NarrationUtils.narrateNumber(frostExposurePercent)}), true);
            this.playWarningSound(false);
        }
        if (this.isFrostAboveThreshold && frostExposurePercent < PlayerWarnings.CONFIG.frostThreshold) {
            this.isFrostAboveThreshold = false;
        }
    }

    private void playWarningSound(boolean severe) {
        if (PlayerWarnings.CONFIG.playSound) {
            SoundEvent soundToPlay = severe ? SoundEvents.ANVIL_PLACE : (SoundEvent)SoundEvents.RESPAWN_ANCHOR_DEPLETE.value();
            this.player.playNotifySound(soundToPlay, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private void playWarningSound(DurabilityWarningStatus status) {
        this.playWarningSound(status.ordinal() > DurabilityWarningStatus.FIRST.ordinal());
    }

    public void durabilityWarnings() {
        if (this.player == null) {
            return;
        }
        if (PlayerWarnings.CONFIG.durabilityWarnings.enableHeldItems) {
            DurabilityWarningStatus mainHandStatus = this.checkDurabilityLevel(this.player.getMainHandItem());
            DurabilityWarningStatus offHandStatus = this.checkDurabilityLevel(this.player.getOffhandItem());
            if (mainHandStatus.ordinal() > this.lastMainHandStatus.ordinal()) {
                this.narrateDurability(this.player.getMainHandItem());
                this.playWarningSound(mainHandStatus);
            }
            if (offHandStatus.ordinal() > this.lastOffHandStatus.ordinal()) {
                this.narrateDurability(this.player.getOffhandItem());
                this.playWarningSound(offHandStatus);
            }
            this.lastMainHandStatus = mainHandStatus;
            this.lastOffHandStatus = offHandStatus;
        }
        if (PlayerWarnings.CONFIG.durabilityWarnings.enableWornArmor) {
            Inventory inventory = this.player.getInventory();
            DurabilityWarningStatus headStatus = this.checkDurabilityLevel(inventory.getItem(36));
            DurabilityWarningStatus chestStatus = this.checkDurabilityLevel(inventory.getItem(37));
            DurabilityWarningStatus legsStatus = this.checkDurabilityLevel(inventory.getItem(38));
            DurabilityWarningStatus feetStatus = this.checkDurabilityLevel(inventory.getItem(39));
            if (headStatus.ordinal() > this.lastHeadStatus.ordinal()) {
                this.narrateDurability(inventory.getItem(36));
                this.playWarningSound(headStatus);
            }
            if (chestStatus.ordinal() > this.lastChestStatus.ordinal()) {
                this.narrateDurability(inventory.getItem(37));
                this.playWarningSound(chestStatus);
            }
            if (legsStatus.ordinal() > this.lastLegsStatus.ordinal()) {
                this.narrateDurability(inventory.getItem(38));
                this.playWarningSound(legsStatus);
            }
            if (feetStatus.ordinal() > this.lastFeetStatus.ordinal()) {
                this.narrateDurability(inventory.getItem(39));
                this.playWarningSound(feetStatus);
            }
            this.lastHeadStatus = headStatus;
            this.lastChestStatus = chestStatus;
            this.lastLegsStatus = legsStatus;
            this.lastFeetStatus = feetStatus;
        }
    }

    private DurabilityWarningStatus checkDurabilityLevel(ItemStack itemStack) {
        if (itemStack == null || !itemStack.isDamageableItem() || !itemStack.isDamaged()) {
            return DurabilityWarningStatus.NONE;
        }
        int durability = itemStack.getMaxDamage() - itemStack.getDamageValue();
        if (itemStack.nextDamageWillBreak()) {
            return DurabilityWarningStatus.NEXT_WILL_BREAK;
        }
        if (durability <= PlayerWarnings.CONFIG.durabilityWarnings.secondThreshold) {
            return DurabilityWarningStatus.SECOND;
        }
        if (durability <= PlayerWarnings.CONFIG.durabilityWarnings.firstThreshold) {
            return DurabilityWarningStatus.FIRST;
        }
        return DurabilityWarningStatus.NONE;
    }

    private void narrateDurability(ItemStack item) {
        String itemName = item.getItemName().getString();
        int maxDamage = item.getMaxDamage();
        int durability = maxDamage - item.getDamageValue();
        MainClass.narrate(I18n.get((String)"minecraft_access.player_warnings.durability_warning", (Object[])new Object[]{itemName, durability, maxDamage}), false);
    }

    private static enum DurabilityWarningStatus {
        NONE,
        FIRST,
        SECOND,
        NEXT_WILL_BREAK;

    }
}

