/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features;

import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.Nullable;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPIndicator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XPIndicator.class);
    private final Minecraft client = Minecraft.getInstance();
    @Nullable
    private Integer previousXPLevel = null;

    public void tick() {
        if (this.client.level == null) {
            return;
        }
        if (this.client.player == null) {
            return;
        }
        if (this.client.screen != null) {
            return;
        }
        int currentXPLevel = this.client.player.experienceLevel;
        if (this.previousXPLevel == null) {
            this.previousXPLevel = currentXPLevel;
            return;
        }
        if (this.previousXPLevel == currentXPLevel) {
            return;
        }
        boolean increased = this.previousXPLevel < currentXPLevel;
        this.previousXPLevel = currentXPLevel;
        String narration = I18n.get((String)(increased ? "minecraft_access.xp_indicator.increased" : "minecraft_access.xp_indicator.decreased"), (Object[])new Object[]{NarrationUtils.narrateNumber(currentXPLevel)});
        MainClass.narrate(narration, true);
    }
}

