/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.access_menu;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.Arrays;
import java.util.stream.Stream;
import lombok.Generated;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.debug.GameModeSwitcherScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.features.access_menu.AccessMenuGUI;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderController;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.mcaccess.minecraftaccess.utils.PlayerUtils;
import org.mcaccess.minecraftaccess.utils.condition.Interval;
import org.mcaccess.minecraftaccess.utils.condition.IntervalKeystroke;
import org.mcaccess.minecraftaccess.utils.condition.MenuKeystroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessMenu {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccessMenu.class);
    private static final Minecraft CLIENT = Minecraft.getInstance();
    public static final double RAY_CAST_DISTANCE = 20.0;
    private static final MenuKeystroke MENU_KEY = new MenuKeystroke(KeyBindingsHandler.Keys.ACCESS_MENU_KEY.mapping);
    private boolean gameModeSwitcherActive = false;
    private static final Interval[] FUNCTION_INTERVALS = new Interval[10];
    private static final MenuFunction[] FUNCTIONS = new MenuFunction[]{new MenuFunction(0, new IntervalKeystroke(KeyBindingsHandler.Keys.OPEN_CONFIG_MENU.mapping), () -> Minecraft.getInstance().setScreen((Screen)AutoConfig.getConfigScreen(Config.class, null).get())), new MenuFunction(1, new IntervalKeystroke(KeyBindingsHandler.Keys.NARRATE_TARGET.mapping), AccessMenu::getBlockAndFluidTargetInformation), new MenuFunction(2, new IntervalKeystroke(KeyBindingsHandler.Keys.TARGET_POSITION.mapping), AccessMenu::getBlockAndFluidTargetPosition), new MenuFunction(3, new IntervalKeystroke(KeyBindingsHandler.Keys.LIGHT_LEVEL.mapping), AccessMenu::getLightLevel), new MenuFunction(4, new IntervalKeystroke(KeyBindingsHandler.Keys.CLOSEST_WATER_SOURCE.mapping), () -> MainClass.fluidDetector.findClosestWaterSource(true)), new MenuFunction(5, new IntervalKeystroke(KeyBindingsHandler.Keys.CLOSEST_LAVA_SOURCE.mapping), () -> MainClass.fluidDetector.findClosestLavaSource(true)), new MenuFunction(6, new IntervalKeystroke(KeyBindingsHandler.Keys.CURRENT_BIOME.mapping), AccessMenu::getBiome), new MenuFunction(7, new IntervalKeystroke(KeyBindingsHandler.Keys.TIME_OF_DAY.mapping), AccessMenu::getTimeOfDay), new MenuFunction(8, new IntervalKeystroke(KeyBindingsHandler.Keys.XP_LEVEL.mapping), AccessMenu::getXP), new MenuFunction(9, new IntervalKeystroke(KeyBindingsHandler.Keys.REFRESH_SCREEN_READER.mapping), () -> ScreenReaderController.refreshScreenReader(true))};

    public void tick() {
        if (AccessMenu.CLIENT.player == null) {
            return;
        }
        if (AccessMenu.CLIENT.screen == null) {
            if (CLIENT.hasAltDown()) {
                AccessMenu.handleInMenuActions();
                return;
            }
            for (MenuFunction function : FUNCTIONS) {
                if (!function.keystroke.canBeTriggered()) continue;
                function.func.run();
                return;
            }
            if (MENU_KEY.canOpenMenu() && !this.gameModeSwitcherActive) {
                CLIENT.setScreen((Screen)new AccessMenuGUI());
            }
        } else if (AccessMenu.CLIENT.screen instanceof AccessMenuGUI) {
            AccessMenu.handleInMenuActions();
        }
        if (AccessMenu.CLIENT.screen instanceof GameModeSwitcherScreen) {
            this.gameModeSwitcherActive = true;
        } else if (!InputConstants.isKeyDown((Window)CLIENT.getWindow(), (int)293)) {
            this.gameModeSwitcherActive = false;
        }
    }

    private static void handleInMenuActions() {
        Window window = CLIENT.getWindow();
        Stream.of(FUNCTIONS).filter(f -> InputConstants.isKeyDown((Window)window, (int)(f.number + 48))).findFirst().ifPresent(f -> {
            if (FUNCTION_INTERVALS[f.number].isReady()) {
                f.func().run();
            }
        });
    }

    public static void getBlockAndFluidTargetInformation() {
        HitResult hit = PlayerUtils.crosshairTarget(20.0);
        if (hit == null) {
            return;
        }
        switch (hit.getType()) {
            case MISS: 
            case ENTITY: {
                MainClass.narrate(I18n.get((String)"minecraft_access.access_menu.target_missed", (Object[])new Object[0]), true);
                break;
            }
            case BLOCK: {
                BlockHitResult blockHit = (BlockHitResult)hit;
                BlockPos blockPos = blockHit.getBlockPos();
                String narration = NarrationUtils.narrateBlock(blockPos, "") + ", " + NarrationUtils.narrateRelativePositionOfPlayerAnd(blockPos);
                MainClass.narrate(narration, true);
            }
        }
    }

    public static void getBlockAndFluidTargetPosition() {
        HitResult hit = PlayerUtils.crosshairTarget(20.0);
        if (hit == null) {
            return;
        }
        switch (hit.getType()) {
            case MISS: 
            case ENTITY: {
                MainClass.narrate(I18n.get((String)"minecraft_access.access_menu.target_missed", (Object[])new Object[0]), true);
                break;
            }
            case BLOCK: {
                BlockHitResult blockHitResult = (BlockHitResult)hit;
                BlockPos blockPos = blockHitResult.getBlockPos();
                MainClass.narrate(NarrationUtils.narrateCoordinatesOf(blockPos), true);
            }
        }
    }

    public static void getLightLevel() {
        if (AccessMenu.CLIENT.player == null) {
            return;
        }
        if (AccessMenu.CLIENT.level == null) {
            return;
        }
        AccessMenu.CLIENT.player.clientSideCloseContainer();
        int light = AccessMenu.CLIENT.level.getMaxLocalRawBrightness(AccessMenu.CLIENT.player.blockPosition());
        MainClass.narrate(I18n.get((String)"minecraft_access.access_menu.light_level", (Object[])new Object[]{NarrationUtils.narrateNumber(light)}), true);
    }

    public static void getBiome() {
        if (AccessMenu.CLIENT.player == null) {
            return;
        }
        if (AccessMenu.CLIENT.level == null) {
            return;
        }
        AccessMenu.CLIENT.player.clientSideCloseContainer();
        Holder currentBiome = AccessMenu.CLIENT.level.getBiome(AccessMenu.CLIENT.player.blockPosition());
        NarrationUtils.getTranslatedName(currentBiome, "biome").ifPresent(name -> MainClass.narrate(I18n.get((String)"minecraft_access.access_menu.biome", (Object[])new Object[]{name}), true));
    }

    public static void getXP() {
        if (AccessMenu.CLIENT.player == null) {
            return;
        }
        AccessMenu.CLIENT.player.clientSideCloseContainer();
        assert (AccessMenu.CLIENT.gameMode != null);
        if (AccessMenu.CLIENT.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            MainClass.narrate(I18n.get((String)"gameMode.spectator", (Object[])new Object[0]), true);
            return;
        }
        if (AccessMenu.CLIENT.gameMode.getPlayerMode() == GameType.CREATIVE) {
            MainClass.narrate(I18n.get((String)"gameMode.creative", (Object[])new Object[0]), true);
            return;
        }
        MainClass.narrate(I18n.get((String)"minecraft_access.access_menu.xp", (Object[])new Object[]{NarrationUtils.narrateNumber(AccessMenu.CLIENT.player.experienceLevel), NarrationUtils.narrateNumber(AccessMenu.CLIENT.player.experienceProgress * 100.0f)}), true);
    }

    public static void getTimeOfDay() {
        if (AccessMenu.CLIENT.player == null) {
            return;
        }
        if (AccessMenu.CLIENT.level == null) {
            return;
        }
        AccessMenu.CLIENT.player.clientSideCloseContainer();
        long daytime = AccessMenu.CLIENT.player.level().getDayTime() + 6000L;
        int hours = (int)(daytime / 1000L) % 24;
        int minutes = (int)(daytime % 1000L * 60L / 1000L);
        StringBuilder translationKey = new StringBuilder("minecraft_access.access_menu.time_of_day");
        if (Config.getInstance().use12HourTimeFormat) {
            if (hours == 0) {
                hours = 12;
                translationKey.append("_am");
            } else if (hours > 12) {
                hours -= 12;
                translationKey.append("_pm");
            } else if (hours == 12) {
                translationKey.append("_pm");
            } else {
                translationKey.append("_am");
            }
        }
        String narration = I18n.get((String)translationKey.toString(), (Object[])new Object[]{String.format("%02d:%02d", hours, minutes)});
        MainClass.narrate(narration, true);
    }

    static {
        Arrays.fill(FUNCTION_INTERVALS, Interval.sec(1L));
        for (int i = 0; i < 10; ++i) {
            AccessMenu.FUNCTIONS[i].keystroke.interval = FUNCTION_INTERVALS[i];
        }
        AccessMenu.FUNCTION_INTERVALS[4] = Interval.ms(0L);
        AccessMenu.FUNCTION_INTERVALS[5] = Interval.ms(0L);
    }

    private record MenuFunction(int number, IntervalKeystroke keystroke, Runnable func) {
    }
}

