/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.access_menu;

import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.features.access_menu.AccessMenu;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderController;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;

public class AccessMenuGUI
extends Screen {
    private GridLayout.RowHelper rowHelper;

    public AccessMenuGUI() {
        super((Component)Component.translatable((String)"minecraft_access.gui.screen.access_menu"));
    }

    public void init() {
        assert (this.minecraft != null);
        HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
        layout.addTitleHeader(this.title, this.minecraft.font);
        GridLayout grid = (GridLayout)layout.addToContents((LayoutElement)new GridLayout().spacing(10));
        this.rowHelper = grid.createRowHelper(2);
        this.button("1", "minecraft_access.access_menu.gui.button.block_and_fluid_target_info", button -> AccessMenu.getBlockAndFluidTargetInformation());
        this.button("2", "minecraft_access.access_menu.gui.button.block_and_fluid_target_position", button -> AccessMenu.getBlockAndFluidTargetPosition());
        this.button("3", "minecraft_access.access_menu.gui.button.light_level", button -> AccessMenu.getLightLevel());
        this.button("4", "minecraft_access.access_menu.gui.button.find_water", button -> MainClass.fluidDetector.findClosestWaterSource(true));
        this.button("5", "minecraft_access.access_menu.gui.button.find_lava", button -> MainClass.fluidDetector.findClosestLavaSource(true));
        this.button("6", "minecraft_access.access_menu.gui.button.biome", button -> AccessMenu.getBiome());
        this.button("7", "minecraft_access.access_menu.gui.button.time_of_day", button -> AccessMenu.getTimeOfDay());
        this.button("8", "minecraft_access.access_menu.gui.button.xp", button -> AccessMenu.getXP());
        this.button("9", "minecraft_access.access_menu.gui.button.refresh_screen_reader", button -> ScreenReaderController.refreshScreenReader(true));
        this.button("0", "minecraft_access.access_menu.gui.button.open_config_menu", button -> Minecraft.getInstance().setScreen((Screen)AutoConfig.getConfigScreen(Config.class, (Screen)this).get()));
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        layout.arrangeElements();
    }

    private void button(String shortcut, String translationKey, Button.OnPress pressAction) {
        MutableComponent label = Component.literal((String)shortcut).append(". ").append(I18n.get((String)translationKey, (Object[])new Object[0]));
        this.rowHelper.addChild((LayoutElement)Button.builder((Component)label, (Button.OnPress)pressAction).width(Math.min(250, this.width / 2 - 15)).build());
    }

    public boolean keyPressed(KeyEvent event) {
        if (KeyBindingsHandler.Keys.ACCESS_MENU_KEY.mapping.matches(event)) {
            Minecraft.getInstance().player.clientSideCloseContainer();
            return true;
        }
        return super.keyPressed(event);
    }
}

