/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.inventory_controls;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.SearchRecipeBookCategory;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.ExtendedRecipeBookCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.features.inventory_controls.GroupGenerator;
import org.mcaccess.minecraftaccess.features.inventory_controls.SlotItem;
import org.mcaccess.minecraftaccess.features.inventory_controls.SlotsGroup;
import org.mcaccess.minecraftaccess.mixin.AbstractContainerScreenAccessor;
import org.mcaccess.minecraftaccess.mixin.AbstractRecipeBookScreenAccessor;
import org.mcaccess.minecraftaccess.mixin.AnvilScreenAccessor;
import org.mcaccess.minecraftaccess.mixin.CreativeModeInventoryScreenAccessor;
import org.mcaccess.minecraftaccess.mixin.EditBoxAccessor;
import org.mcaccess.minecraftaccess.mixin.KeyMappingAccessor;
import org.mcaccess.minecraftaccess.mixin.RecipeBookComponentAccessor;
import org.mcaccess.minecraftaccess.mixin.RecipeBookPageAccessor;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;
import org.mcaccess.minecraftaccess.utils.condition.Interval;
import org.mcaccess.minecraftaccess.utils.system.MouseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryControls {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryControls.class);
    private Config.InventoryControls config;
    private final Interval interval = Interval.defaultDelay();
    private final Minecraft client = Minecraft.getInstance();
    private AbstractContainerScreenAccessor previousScreen = null;
    private AbstractContainerScreenAccessor currentScreen = null;
    private List<SlotsGroup> currentSlotsGroupList = null;
    private SlotsGroup currentGroup = null;
    private int currentGroupIndex = 0;
    private SlotItem currentSlotItem = null;
    private RecipeBookComponent<?> currentRecipeBookWidget = null;
    private String previousSlotText = "";

    public InventoryControls() {
        this.loadConfig();
    }

    public String getRowAndColumnFormat() {
        return this.config.rowAndColumnFormat;
    }

    public void tick() {
        String slotNarrationText;
        if (!this.interval.isReady()) {
            return;
        }
        if (this.client.player == null) {
            return;
        }
        if (this.client.screen == null) {
            this.previousScreen = null;
            this.currentScreen = null;
            this.currentGroupIndex = 0;
            this.currentGroup = null;
            this.currentRecipeBookWidget = null;
            return;
        }
        if (!(this.client.screen instanceof AbstractContainerScreen)) {
            return;
        }
        this.loadConfig();
        this.currentScreen = (AbstractContainerScreenAccessor)this.client.screen;
        this.currentRecipeBookWidget = this.getRecipeBookWidget(this.client.screen);
        this.currentSlotsGroupList = GroupGenerator.generateGroupsFromSlots(this.currentScreen);
        this.interval.adjustNextReadyTimeBy(this.keyListener());
        if (this.previousScreen != this.currentScreen) {
            CreativeModeInventoryScreen creativeInventoryScreen;
            EditBox searchBox;
            this.previousScreen = this.currentScreen;
            AbstractContainerScreenAccessor abstractContainerScreenAccessor = this.currentScreen;
            if (abstractContainerScreenAccessor instanceof AnvilScreen) {
                AnvilScreen anvilScreen = (AnvilScreen)abstractContainerScreenAccessor;
                this.setSearchBoxFocus(((AnvilScreenAccessor)anvilScreen).getName(), false);
            }
            if ((abstractContainerScreenAccessor = this.currentScreen) instanceof CreativeModeInventoryScreen && (searchBox = ((CreativeModeInventoryScreenAccessor)(creativeInventoryScreen = (CreativeModeInventoryScreen)abstractContainerScreenAccessor)).getSearchBox()).canConsumeInput()) {
                this.setSearchBoxFocus(searchBox, false);
            }
            if (this.config.autoOpenRecipeBook && this.currentRecipeBookWidget != null) {
                if (!this.currentRecipeBookWidget.isVisible()) {
                    this.currentRecipeBookWidget.toggleVisibility();
                }
                this.setSearchBoxFocus(((RecipeBookComponentAccessor)this.currentRecipeBookWidget).getSearchBox(), false);
            }
            this.refreshGroupListAndSelectFirstGroup(false);
        }
        if (this.currentSlotsGroupList.isEmpty()) {
            return;
        }
        if (this.config.narrateFocusedSlotChanges && !this.previousSlotText.equals(slotNarrationText = this.getCurrentSlotNarrationText())) {
            this.previousSlotText = slotNarrationText;
            MainClass.narrate(this.previousSlotText, true);
        }
    }

    @Nullable
    private RecipeBookComponent<?> getRecipeBookWidget(Screen screen) {
        if (screen instanceof AbstractRecipeBookScreen) {
            AbstractRecipeBookScreen recipeBookScreen = (AbstractRecipeBookScreen)screen;
            return ((AbstractRecipeBookScreenAccessor)recipeBookScreen).getRecipeBookComponent();
        }
        return null;
    }

    private void loadConfig() {
        this.config = Config.getInstance().inventoryControls;
        this.interval.setDelay(this.config.delayMilliseconds, Interval.Unit.MILLISECOND);
    }

    private boolean keyListener() {
        EditBox searchBox;
        AnvilScreen anvilScreen;
        CreativeModeInventoryScreen creativeInventoryScreen;
        AbstractContainerScreenAccessor searchBox2;
        boolean isGroupKeyPressed = this.isKeyPressed(KeyBindingsHandler.Keys.INVENTORY_CONTROLS_GROUP_KEY.mapping);
        boolean isUpKeyPressed = this.isKeyPressed(KeyBindingsHandler.Keys.INVENTORY_CONTROLS_UP_KEY.mapping);
        boolean isRightKeyPressed = this.isKeyPressed(KeyBindingsHandler.Keys.INVENTORY_CONTROLS_RIGHT_KEY.mapping);
        boolean isDownKeyPressed = this.isKeyPressed(KeyBindingsHandler.Keys.INVENTORY_CONTROLS_DOWN_KEY.mapping);
        boolean isLeftKeyPressed = this.isKeyPressed(KeyBindingsHandler.Keys.INVENTORY_CONTROLS_LEFT_KEY.mapping);
        boolean isSwitchTabKeyPressed = this.isKeyPressed(KeyBindingsHandler.Keys.INVENTORY_CONTROLS_SWITCH_TAB_KEY.mapping);
        boolean isToggleCraftableKeyPressed = this.isKeyPressed(KeyBindingsHandler.Keys.INVENTORY_CONTROLS_TOGGLE_CRAFTABLE_KEY.mapping);
        boolean isEnterPressed = InputConstants.isKeyDown((Window)this.client.getWindow(), (int)257) || InputConstants.isKeyDown((Window)this.client.getWindow(), (int)335);
        boolean isTPressed = InputConstants.isKeyDown((Window)this.client.getWindow(), (int)84);
        boolean disableInputForSearchBox = false;
        AbstractContainerScreenAccessor abstractContainerScreenAccessor = this.currentScreen;
        if (abstractContainerScreenAccessor instanceof CreativeModeInventoryScreen && (searchBox2 = ((CreativeModeInventoryScreenAccessor)(creativeInventoryScreen = (CreativeModeInventoryScreen)abstractContainerScreenAccessor)).getSearchBox()).canConsumeInput()) {
            disableInputForSearchBox = true;
            if (isEnterPressed) {
                this.setSearchBoxFocus((EditBox)searchBox2, false);
                this.refreshGroupListAndSelectFirstGroup(true);
                return true;
            }
        }
        if ((searchBox2 = this.currentScreen) instanceof AnvilScreen && (searchBox2 = ((AnvilScreenAccessor)(anvilScreen = (AnvilScreen)searchBox2)).getName()).canConsumeInput()) {
            disableInputForSearchBox = true;
            if (isEnterPressed) {
                this.setSearchBoxFocus((EditBox)searchBox2, false);
                this.previousSlotText = "";
                return true;
            }
        }
        if (this.recipeBookIsOpening() && (searchBox = ((RecipeBookComponentAccessor)this.currentRecipeBookWidget).getSearchBox()).canConsumeInput()) {
            disableInputForSearchBox = true;
            if (isEnterPressed) {
                this.setSearchBoxFocus(searchBox, false);
                this.previousSlotText = "";
                return true;
            }
        }
        if (disableInputForSearchBox) {
            return true;
        }
        if (isGroupKeyPressed) {
            log.debug("Group key pressed");
            this.changeGroup(!this.client.hasShiftDown());
            return true;
        }
        if (isSwitchTabKeyPressed) {
            log.debug("Switch Tab key pressed");
            if (this.currentScreen instanceof InventoryScreen || this.currentScreen instanceof CraftingScreen) {
                this.changeRecipeTab(!this.client.hasShiftDown());
            } else if (this.currentScreen instanceof CreativeModeInventoryScreen) {
                this.changeCreativeInventoryTab(!this.client.hasShiftDown());
            }
            return true;
        }
        if (isUpKeyPressed) {
            log.debug("Up key pressed");
            if (this.client.hasShiftDown() && this.currentGroup.isScrollable) {
                if (this.recipeBookIsOpening()) {
                    this.clickPreviousRecipeBookPage();
                } else {
                    MouseUtils.Wheel.UP.scroll();
                }
            } else {
                this.focusSlotItemAt(FocusDirection.UP);
            }
            return true;
        }
        if (isRightKeyPressed) {
            log.debug("Right key pressed");
            this.focusSlotItemAt(FocusDirection.RIGHT);
            return true;
        }
        if (isDownKeyPressed) {
            log.debug("Down key pressed");
            if (this.client.hasShiftDown() && this.currentGroup.isScrollable) {
                if (this.recipeBookIsOpening()) {
                    this.clickNextRecipeBookPage();
                } else {
                    MouseUtils.Wheel.DOWN.scroll();
                }
            } else {
                this.focusSlotItemAt(FocusDirection.DOWN);
            }
            return true;
        }
        if (isLeftKeyPressed) {
            log.debug("Left key pressed");
            this.focusSlotItemAt(FocusDirection.LEFT);
            return true;
        }
        if (isTPressed) {
            AbstractContainerScreenAccessor abstractContainerScreenAccessor2;
            if (CreativeModeInventoryScreenAccessor.getSelectedTab().getType() == CreativeModeTab.Type.SEARCH && (abstractContainerScreenAccessor2 = this.currentScreen) instanceof CreativeModeInventoryScreen) {
                creativeInventoryScreen = (CreativeModeInventoryScreen)abstractContainerScreenAccessor2;
                this.setSearchBoxFocus(((CreativeModeInventoryScreenAccessor)creativeInventoryScreen).getSearchBox(), true);
            } else {
                abstractContainerScreenAccessor2 = this.currentScreen;
                if (abstractContainerScreenAccessor2 instanceof AnvilScreen) {
                    AnvilScreen anvilScreen2 = (AnvilScreen)abstractContainerScreenAccessor2;
                    this.setSearchBoxFocus(((AnvilScreenAccessor)anvilScreen2).getName(), true);
                } else if (this.recipeBookIsOpening()) {
                    this.client.screen.setFocused(this.currentRecipeBookWidget);
                    this.setSearchBoxFocus(((RecipeBookComponentAccessor)this.currentRecipeBookWidget).getSearchBox(), true);
                }
            }
            return true;
        }
        if (isToggleCraftableKeyPressed) {
            if (this.currentRecipeBookWidget == null) {
                return false;
            }
            if (!this.currentRecipeBookWidget.isVisible()) {
                return false;
            }
            StateSwitchingButton toggleCraftableButton = ((RecipeBookComponentAccessor)this.currentRecipeBookWidget).getFilterButton();
            int x = toggleCraftableButton.getX() + 8;
            int y = toggleCraftableButton.getY() + 4;
            MouseUtils.Coordinates p = MouseUtils.calcRealPositionOfWidget(x, y);
            MouseUtils.moveAndLeftClick(p.x(), p.y());
            this.moveToSlotItem(this.currentSlotItem, 100);
            String narration = toggleCraftableButton.isStateTriggered() ? I18n.get((String)"gui.recipebook.toggleRecipes.all", (Object[])new Object[0]) : ((RecipeBookComponentAccessor)this.currentRecipeBookWidget).callGetRecipeFilterName().getString();
            MainClass.narrate(narration, true);
            return true;
        }
        return false;
    }

    private boolean isKeyPressed(KeyMapping keyMapping) {
        if (keyMapping.isUnbound()) {
            return false;
        }
        return InputConstants.isKeyDown((Window)this.client.getWindow(), (int)((KeyMappingAccessor)keyMapping).getKey().getValue());
    }

    private boolean recipeBookIsOpening() {
        return this.currentRecipeBookWidget != null && this.currentRecipeBookWidget.isVisible();
    }

    private void clickPreviousRecipeBookPage() {
        RecipeBookPageAccessor area = (RecipeBookPageAccessor)((RecipeBookComponentAccessor)this.currentRecipeBookWidget).getRecipeBookPage();
        int x = area.getBackButton().getX() + 3;
        int y = area.getBackButton().getY() + 3;
        MouseUtils.Coordinates p = MouseUtils.calcRealPositionOfWidget(x, y);
        MouseUtils.moveAndLeftClick(p.x(), p.y());
        this.moveToSlotItem(this.currentSlotItem, 100);
    }

    private void clickNextRecipeBookPage() {
        RecipeBookPageAccessor area = (RecipeBookPageAccessor)((RecipeBookComponentAccessor)this.currentRecipeBookWidget).getRecipeBookPage();
        int x = area.getForwardButton().getX() + 3;
        int y = area.getForwardButton().getY() + 3;
        MouseUtils.Coordinates p = MouseUtils.calcRealPositionOfWidget(x, y);
        MouseUtils.moveAndLeftClick(p.x(), p.y());
        this.moveToSlotItem(this.currentSlotItem, 100);
    }

    private void focusSlotItemAt(FocusDirection focusDirection) {
        if (this.currentGroup == null) {
            this.changeGroup(true);
            return;
        }
        if (this.currentSlotItem == null) {
            this.focusSlotItem(this.currentGroup.getFirstGroupItem(), true);
            return;
        }
        SlotItem slotItem = this.getGroupItemInDirection(focusDirection);
        if (slotItem == null) {
            MainClass.narrate(I18n.get((String)"minecraft_access.inventory_controls.no_slot_in_direction", (Object[])new Object[]{I18n.get((String)focusDirection.getString(), (Object[])new Object[0])}), true);
            return;
        }
        this.focusSlotItem(slotItem, true);
    }

    private SlotItem getGroupItemInDirection(FocusDirection focusDirection) {
        switch (focusDirection.ordinal()) {
            case 0: {
                if (!this.currentGroup.hasSlotItemAbove(this.currentSlotItem)) {
                    return null;
                }
                if (this.currentSlotItem.upSlotItem != null) {
                    return this.currentSlotItem.upSlotItem;
                }
                for (SlotItem item : this.currentGroup.slotItems) {
                    if (item.x != this.currentSlotItem.x || item.y != this.currentSlotItem.y - 18) continue;
                    return item;
                }
                break;
            }
            case 3: {
                if (!this.currentGroup.hasSlotItemRight(this.currentSlotItem)) {
                    return null;
                }
                if (this.currentSlotItem.rightSlotItem != null) {
                    return this.currentSlotItem.rightSlotItem;
                }
                for (SlotItem item : this.currentGroup.slotItems) {
                    if (item.x != this.currentSlotItem.x + 18 || item.y != this.currentSlotItem.y) continue;
                    return item;
                }
                break;
            }
            case 1: {
                if (!this.currentGroup.hasSlotItemBelow(this.currentSlotItem)) {
                    return null;
                }
                if (this.currentSlotItem.downSlotItem != null) {
                    return this.currentSlotItem.downSlotItem;
                }
                for (SlotItem item : this.currentGroup.slotItems) {
                    if (item.x != this.currentSlotItem.x || item.y != this.currentSlotItem.y + 18) continue;
                    return item;
                }
                break;
            }
            case 2: {
                if (!this.currentGroup.hasSlotItemLeft(this.currentSlotItem)) {
                    return null;
                }
                if (this.currentSlotItem.leftSlotItem != null) {
                    return this.currentSlotItem.leftSlotItem;
                }
                for (SlotItem item : this.currentGroup.slotItems) {
                    if (item.x != this.currentSlotItem.x - 18 || item.y != this.currentSlotItem.y) continue;
                    return item;
                }
                break;
            }
        }
        return null;
    }

    private void focusSlotItem(@NotNull SlotItem slotItem, boolean interrupt) {
        this.currentSlotItem = slotItem;
        this.moveToSlotItem(this.currentSlotItem);
        String narration = this.getCurrentSlotNarrationText();
        if (!narration.isEmpty()) {
            this.previousSlotText = narration;
            MainClass.narrate(narration, interrupt);
        }
    }

    private void moveToSlotItem(SlotItem slotItem) {
        if (slotItem == null) {
            return;
        }
        int x = slotItem.x;
        int y = slotItem.y;
        MouseUtils.Coordinates p = MouseUtils.calcRealPositionOfWidget(this.currentScreen.getLeftPos() + x, this.currentScreen.getTopPos() + y);
        MouseUtils.move(p.x(), p.y());
    }

    private void moveToSlotItem(SlotItem slotItem, int delay) {
        if (slotItem == null) {
            return;
        }
        int x = slotItem.x;
        int y = slotItem.y;
        MouseUtils.Coordinates p = MouseUtils.calcRealPositionOfWidget(this.currentScreen.getLeftPos() + x, this.currentScreen.getTopPos() + y);
        MouseUtils.moveAfterDelay(p.x(), p.y(), delay);
    }

    private String getCurrentSlotNarrationText() {
        if (this.currentSlotItem == null) {
            return "";
        }
        Slot slot = this.currentSlotItem.slot;
        if (slot == null) {
            return Objects.requireNonNullElse(this.currentSlotItem.getNarratableText(), I18n.get((String)"minecraft_access.inventory_controls.Unknown", (Object[])new Object[0]));
        }
        if (!slot.hasItem()) {
            return I18n.get((String)"minecraft_access.inventory_controls.empty_slot", (Object[])new Object[]{this.currentGroup.getSlotPrefix(slot)});
        }
        ItemStack itemStack = slot.getItem();
        String info = "%s %s".formatted(this.currentGroup.getSlotPrefix(slot), itemStack.getCount() != 1 && !itemStack.isEmpty() ? String.valueOf(itemStack.getCount()) : "");
        StringBuilder toolTipString = new StringBuilder();
        List toolTipList = itemStack.getTooltipLines(Item.TooltipContext.EMPTY, (Player)this.client.player, (TooltipFlag)TooltipFlag.NORMAL);
        for (Component line : toolTipList) {
            toolTipString.append(line.getString()).append(' ');
        }
        Optional.ofNullable((JukeboxPlayable)itemStack.get(DataComponents.JUKEBOX_PLAYABLE)).flatMap(jukeboxPlayable -> jukeboxPlayable.song().key()).ifPresent(discNumber -> toolTipString.append(' ').append(I18n.get((String)("jukebox_song.minecraft." + discNumber.location().getPath()), (Object[])new Object[0])));
        return "%s %s".formatted(info, toolTipString.toString());
    }

    private void changeGroup(boolean goForward) {
        int nextGroupIndex = this.currentGroupIndex + (goForward ? 1 : -1);
        if ((nextGroupIndex = Mth.clamp((int)nextGroupIndex, (int)0, (int)(this.currentSlotsGroupList.size() - 1))) == this.currentGroupIndex) {
            return;
        }
        this.currentGroupIndex = nextGroupIndex;
        this.selectGroup(true);
    }

    private void refreshGroupListAndSelectFirstGroup(boolean interrupt) {
        this.currentSlotsGroupList = GroupGenerator.generateGroupsFromSlots(this.currentScreen);
        if (this.currentSlotsGroupList.isEmpty()) {
            return;
        }
        this.currentGroupIndex = 0;
        this.selectGroup(interrupt);
    }

    private void selectGroup(boolean interrupt) {
        this.currentGroup = this.currentSlotsGroupList.get(this.currentGroupIndex);
        log.debug("Group(name:{}) {}/{} selected", new Object[]{this.currentGroup.getGroupName(), this.currentGroupIndex + 1, this.currentSlotsGroupList.size()});
        MainClass.narrate(I18n.get((String)"minecraft_access.inventory_controls.group_selected", (Object[])new Object[]{this.currentGroup.isScrollable ? I18n.get((String)"minecraft_access.inventory_controls.scrollable", (Object[])new Object[0]) : "", this.currentGroup.getGroupName()}), interrupt);
        this.focusSlotItem(this.currentGroup.getFirstGroupItem(), false);
    }

    private void changeCreativeInventoryTab(boolean goForward) {
        AbstractContainerScreenAccessor abstractContainerScreenAccessor = this.currentScreen;
        if (!(abstractContainerScreenAccessor instanceof CreativeModeInventoryScreen)) {
            return;
        }
        CreativeModeInventoryScreen creativeInventoryScreen = (CreativeModeInventoryScreen)abstractContainerScreenAccessor;
        int tab = CreativeModeTabs.tabs().indexOf(CreativeModeInventoryScreenAccessor.getSelectedTab());
        if (goForward && tab + 1 < CreativeModeTabs.tabs().size()) {
            ((CreativeModeInventoryScreenAccessor)creativeInventoryScreen).invokeSelectTab((CreativeModeTab)CreativeModeTabs.tabs().get(tab + 1));
            this.refreshGroupListAndSelectFirstGroup(false);
        } else if (!goForward && tab - 1 >= 0) {
            ((CreativeModeInventoryScreenAccessor)creativeInventoryScreen).invokeSelectTab((CreativeModeTab)CreativeModeTabs.tabs().get(tab - 1));
            this.refreshGroupListAndSelectFirstGroup(false);
        }
    }

    private void changeRecipeTab(boolean goForward) {
        if (this.currentRecipeBookWidget == null) {
            return;
        }
        if (!this.currentRecipeBookWidget.isVisible()) {
            return;
        }
        RecipeBookComponentAccessor recipeBookComponentAccessor = (RecipeBookComponentAccessor)this.currentRecipeBookWidget;
        int currentTabIndex = recipeBookComponentAccessor.getTabButtons().indexOf(recipeBookComponentAccessor.getSelectedTab());
        int nextTabIndex = currentTabIndex + (goForward ? 1 : -1);
        nextTabIndex = Mth.clamp((int)nextTabIndex, (int)0, (int)(recipeBookComponentAccessor.getTabButtons().size() - 1));
        int x = recipeBookComponentAccessor.getTabButtons().get(nextTabIndex).getX() + 9;
        int y = recipeBookComponentAccessor.getTabButtons().get(nextTabIndex).getY() + 9;
        MouseUtils.Coordinates p = MouseUtils.calcRealPositionOfWidget(x, y);
        MouseUtils.moveAndLeftClick(p.x(), p.y());
        this.moveToSlotItem(this.currentSlotItem, 100);
        ExtendedRecipeBookCategory category = recipeBookComponentAccessor.getSelectedTab().getCategory();
        log.debug("Change tab to {}", (Object)((SearchRecipeBookCategory)category).name());
    }

    private void setSearchBoxFocus(EditBox w, boolean focus) {
        if (focus) {
            log.debug("T key pressed, selecting the search box.");
            w.setFocused(true);
        } else {
            log.debug("Enter key pressed, deselecting the search box.");
            boolean origin = ((EditBoxAccessor)w).getCanLoseFocus();
            w.setCanLoseFocus(true);
            w.setFocused(false);
            w.setCanLoseFocus(origin);
        }
    }

    private static enum FocusDirection {
        UP("gui.up"),
        DOWN("gui.down"),
        LEFT("minecraft_access.inventory_controls.direction_left"),
        RIGHT("minecraft_access.inventory_controls.direction_right");

        private final String value;

        private FocusDirection(String value) {
            this.value = value;
        }

        String getString() {
            return this.value;
        }
    }
}

