/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.inventory_controls;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.LoomScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.gui.screens.inventory.StonecutterScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.LoomMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.mcaccess.minecraftaccess.mixin.LoomScreenAccessor;
import org.mcaccess.minecraftaccess.mixin.MerchantScreenAccessor;
import org.mcaccess.minecraftaccess.mixin.SingleItemRecipeAccessor;
import org.mcaccess.minecraftaccess.mixin.StonecutterScreenAccessor;

public class SlotItem {
    public SlotItem upSlotItem = null;
    public SlotItem rightSlotItem = null;
    public SlotItem downSlotItem = null;
    public SlotItem leftSlotItem = null;
    public int x;
    public int y;
    public Slot slot = null;
    private int recipeOrTradeIndex;
    private int row;
    private int column;
    private String text = null;

    public SlotItem(Slot slot) {
        this.slot = slot;
        this.x = slot.x + 9;
        this.y = slot.y + 9;
    }

    public SlotItem(int x, int y, int recipeOrTradeIndex) {
        this.x = x;
        this.y = y;
        this.recipeOrTradeIndex = recipeOrTradeIndex;
    }

    public SlotItem(int x, int y, int row, int column) {
        this.x = x;
        this.y = y;
        this.row = row;
        this.column = column;
    }

    public SlotItem(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public SlotItem(int x, int y, String text) {
        this.x = x;
        this.y = y;
        this.text = text;
    }

    public String getNarratableText() {
        Object list;
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof LoomScreen) {
            LoomScreen loomScreen = (LoomScreen)screen;
            list = ((LoomMenu)loomScreen.getMenu()).getSelectablePatterns();
            if (list.isEmpty()) {
                return "";
            }
            int p = this.row + ((LoomScreenAccessor)loomScreen).getStartRow();
            int q = p * 4 + this.column;
            BannerPattern pattern = (BannerPattern)((Holder)list.get(q)).value();
            ItemStack dyeItemStack = ((LoomScreenAccessor)loomScreen).getDyeStack();
            DyeItem dyeItem = (DyeItem)dyeItemStack.getItem();
            DyeColor color = dyeItem.getDyeColor();
            String transKey = pattern.translationKey() + "." + color.name().toLowerCase();
            return I18n.get((String)transKey, (Object[])new Object[0]);
        }
        list = Minecraft.getInstance().screen;
        if (list instanceof StonecutterScreen) {
            StonecutterScreen stonecutterScreen = (StonecutterScreen)list;
            if ((list = ((StonecutterMenu)stonecutterScreen.getMenu()).getVisibleRecipes().entries()).isEmpty()) {
                return "";
            }
            int scrollOffset = ((StonecutterScreenAccessor)stonecutterScreen).getStartIndex();
            Optional recipe = ((SelectableRecipe.SingleInputEntry)list.get(this.recipeOrTradeIndex + scrollOffset)).recipe().recipe();
            if (recipe.isEmpty()) {
                return "";
            }
            StonecutterRecipe recipe1 = (StonecutterRecipe)((RecipeHolder)recipe.get()).value();
            ItemStack item = ((SingleItemRecipeAccessor)recipe1).getResult();
            List toolTip = Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)item);
            StringBuilder toolTipString = new StringBuilder();
            for (Component text : toolTip) {
                toolTipString.append(text.getString()).append('\n');
            }
            return "%s %s".formatted(item.getCount(), toolTipString);
        }
        list = Minecraft.getInstance().screen;
        if (list instanceof MerchantScreen) {
            MerchantScreen merchantScreen = (MerchantScreen)list;
            MerchantOffers tradeOfferList = ((MerchantMenu)merchantScreen.getMenu()).getOffers();
            if (tradeOfferList.isEmpty()) {
                return I18n.get((String)"minecraft_access.inventory_controls.Unknown", (Object[])new Object[0]);
            }
            MerchantOffer tradeOffer = (MerchantOffer)tradeOfferList.get(this.recipeOrTradeIndex + ((MerchantScreenAccessor)merchantScreen).getScrollOff());
            ItemStack firstBuyItem = tradeOffer.getBaseCostA();
            Optional secondBuyItem = tradeOffer.getItemCostB();
            ItemStack sellItem = tradeOffer.getResult();
            int price = firstBuyItem.getCount() + tradeOffer.getSpecialPriceDiff();
            String firstBuyItemString = price + " " + firstBuyItem.getHoverName().getString();
            Object secondBuyItemString = "";
            if (secondBuyItem.isPresent()) {
                ItemStack item = ((ItemCost)secondBuyItem.get()).itemStack();
                secondBuyItemString = item.getCount() + " " + item.getHoverName().getString();
            }
            String sellItemString = sellItem.getCount() + " " + sellItem.getHoverName().getString();
            String tradeText = secondBuyItem.isEmpty() ? I18n.get((String)"minecraft_access.inventory_controls.trade_text_format", (Object[])new Object[]{firstBuyItemString, sellItemString}) : I18n.get((String)"minecraft_access.inventory_controls.trade_text_format_with_second_item", (Object[])new Object[]{firstBuyItemString, secondBuyItemString, sellItemString});
            return tradeText;
        }
        if (this.text != null) {
            return this.text;
        }
        return "";
    }
}

