/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.narrate_crosshair;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mcaccess.minecraftaccess.features.narrate_crosshair.CrosshairNarrator;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.mcaccess.minecraftaccess.utils.PlayerUtils;

public class MCAccess
implements CrosshairNarrator {
    @Override
    @NotNull
    public HitResult rayCast() {
        LocalPlayer player = Minecraft.getInstance().player;
        assert (player != null);
        return PlayerUtils.crosshairTarget(Math.min(player.blockInteractionRange(), player.entityInteractionRange()));
    }

    @Override
    @Nullable
    public Object deduplication(boolean narrateSide, boolean narrateConsecutiveBlocks) {
        HitResult hit = this.rayCast();
        if (hit.getType() == HitResult.Type.MISS) {
            return null;
        }
        HitResult hitResult = hit;
        Objects.requireNonNull(hitResult);
        HitResult hitResult2 = hitResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockHitResult.class, EntityHitResult.class}, (Object)hitResult2, n)) {
            case 0 -> {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult2;
                String side = narrateSide ? blockHitResult.getDirection().getName() : "";
                yield Arrays.asList((Comparable)NarrationUtils.narrateBlockForContentChecking(blockHitResult.getBlockPos(), side).getB(), narrateConsecutiveBlocks ? blockHitResult.getBlockPos() : null);
            }
            case 1 -> {
                EntityHitResult entityHitResult = (EntityHitResult)hitResult2;
                yield NarrationUtils.narrateEntity(entityHitResult.getEntity());
            }
            default -> null;
        };
    }

    @Override
    @NotNull
    public String narrate(boolean narrateSide) {
        HitResult hitResult = this.rayCast();
        Objects.requireNonNull(hitResult);
        HitResult hitResult2 = hitResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockHitResult.class, EntityHitResult.class}, (Object)hitResult2, n)) {
            case 0 -> {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult2;
                String side = narrateSide ? I18n.get((String)String.format("minecraft_access.direction.%s", blockHitResult.getDirection().getName()), (Object[])new Object[0]) : "";
                yield (String)NarrationUtils.narrateBlockForContentChecking(blockHitResult.getBlockPos(), side).getA();
            }
            case 1 -> {
                EntityHitResult entityHitResult = (EntityHitResult)hitResult2;
                yield NarrationUtils.narrateEntity(entityHitResult.getEntity());
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(this.rayCast()));
        };
    }
}

