/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.narrate_crosshair;

import dev.architectury.platform.Platform;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.features.narrate_crosshair.CrosshairNarrator;
import org.mcaccess.minecraftaccess.features.narrate_crosshair.Jade;
import org.mcaccess.minecraftaccess.features.narrate_crosshair.MCAccess;
import org.mcaccess.minecraftaccess.utils.condition.Interval;

public class NarrateCrosshair {
    @Nullable
    private Object previous = null;
    private Vec3 previousSoundPos = Vec3.ZERO;
    private final Interval repetitionInterval = Interval.defaultDelay();
    private boolean filterBlocks;
    private boolean filterEntities;
    private static final Config.NarrateCrosshair CONFIG = Config.getInstance().narrateCrosshair;
    private final MCAccess mcAccess;
    private final Jade jade;

    public NarrateCrosshair() {
        this.loadConfig();
        this.mcAccess = new MCAccess();
        this.jade = new Jade();
    }

    public void tick() {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        if (client.player == null) {
            return;
        }
        if (client.screen != null) {
            return;
        }
        this.loadConfig();
        if (!NarrateCrosshair.CONFIG.enabled) {
            return;
        }
        CrosshairNarrator narrator = this.getNarrator();
        Object deduplication = narrator.deduplication(NarrateCrosshair.CONFIG.narrateBlockFace, !NarrateCrosshair.CONFIG.disableNarratingConsecutiveBlocks);
        if (Objects.equals(deduplication, this.previous) && !this.repetitionInterval.isReady()) {
            return;
        }
        this.previous = deduplication;
        if (deduplication == null) {
            return;
        }
        HitResult hit = narrator.rayCast();
        if (NarrateCrosshair.CONFIG.relativePositionSoundCue.enabled) {
            Vec3 targetPosition;
            double rayCastDistance = Math.min(client.player.blockInteractionRange(), client.player.entityInteractionRange());
            HitResult hitResult = hit;
            Objects.requireNonNull(hitResult);
            HitResult hitResult2 = hitResult;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockHitResult.class, EntityHitResult.class}, (Object)hitResult2, n)) {
                case 0: {
                    BlockHitResult blockHitResult = (BlockHitResult)hitResult2;
                    Vec3 vec3 = blockHitResult.getBlockPos().getCenter();
                    break;
                }
                case 1: {
                    EntityHitResult entityHitResult = (EntityHitResult)hitResult2;
                    Vec3 vec3 = entityHitResult.getEntity().position();
                    break;
                }
                default: {
                    Vec3 vec3 = targetPosition = null;
                }
            }
            if (targetPosition != null && !Objects.equals(targetPosition, this.previousSoundPos)) {
                NarrateCrosshair.playRelativePositionSoundCue(targetPosition, rayCastDistance, (Holder.Reference<SoundEvent>)SoundEvents.NOTE_BLOCK_HARP, NarrateCrosshair.CONFIG.relativePositionSoundCue.minSoundVolume, NarrateCrosshair.CONFIG.relativePositionSoundCue.maxSoundVolume);
            }
            this.previousSoundPos = targetPosition;
        }
        if (NarrateCrosshair.CONFIG.filter.enabled) {
            ResourceLocation resourceLocation;
            HitResult hitResult = hit;
            Objects.requireNonNull(hitResult);
            HitResult hitResult3 = hitResult;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockHitResult.class, EntityHitResult.class}, (Object)hitResult3, n)) {
                case 0: {
                    BlockHitResult blockHitResult = (BlockHitResult)hitResult3;
                    ResourceLocation resourceLocation2 = BuiltInRegistries.BLOCK.getKey((Object)client.level.getBlockState(blockHitResult.getBlockPos()).getBlock());
                    break;
                }
                case 1: {
                    EntityHitResult entityHitResult = (EntityHitResult)hitResult3;
                    ResourceLocation resourceLocation2 = EntityType.getKey((EntityType)entityHitResult.getEntity().getType());
                    break;
                }
                default: {
                    ResourceLocation resourceLocation2 = resourceLocation = null;
                }
            }
            if (this.filterBlocks && hit.getType() == HitResult.Type.BLOCK && this.isIgnored(resourceLocation)) {
                return;
            }
            if (this.filterEntities && hit.getType() == HitResult.Type.ENTITY && this.isIgnored(resourceLocation)) {
                return;
            }
        }
        MainClass.narrate(narrator.narrate(NarrateCrosshair.CONFIG.narrateBlockFace), true);
    }

    private void loadConfig() {
        this.repetitionInterval.setDelay(NarrateCrosshair.CONFIG.repetitionInterval, Interval.Unit.MILLISECOND);
        switch (NarrateCrosshair.CONFIG.filter.targetMode) {
            case ALL: {
                this.filterBlocks = true;
                this.filterEntities = true;
                break;
            }
            case BLOCK: {
                this.filterBlocks = true;
                this.filterEntities = false;
                break;
            }
            case ENTITY: {
                this.filterBlocks = false;
                this.filterEntities = true;
            }
        }
    }

    private CrosshairNarrator getNarrator() {
        if (NarrateCrosshair.CONFIG.useJade && Platform.isModLoaded((String)"jade")) {
            return this.jade;
        }
        return this.mcAccess;
    }

    private boolean isIgnored(ResourceLocation identifier) {
        if (identifier == null) {
            return false;
        }
        String name = identifier.getPath();
        Predicate<String> p = NarrateCrosshair.CONFIG.filter.fuzzy ? name::contains : name::equals;
        return NarrateCrosshair.CONFIG.filter.whitelist ? Arrays.stream(NarrateCrosshair.CONFIG.filter.targets).noneMatch(p) : Arrays.stream(NarrateCrosshair.CONFIG.filter.targets).anyMatch(p);
    }

    private static void playRelativePositionSoundCue(Vec3 targetPosition, double maxDistance, Holder.Reference<SoundEvent> sound, double minVolume, double maxVolume) {
        assert (Minecraft.getInstance().player != null);
        Vec3 playerPos = Minecraft.getInstance().player.position();
        float pitch = (float)Math.pow(2.0, (targetPosition.y() - playerPos.y) / maxDistance);
        double distance = Math.sqrt(targetPosition.distanceToSqr(playerPos.x, playerPos.y, playerPos.z));
        double volumeDeltaPerBlock = (maxVolume - minVolume) / maxDistance;
        float volume = (float)(minVolume + (maxDistance - distance) * volumeDeltaPerBlock);
        assert (Minecraft.getInstance().level != null);
        Minecraft.getInstance().level.playLocalSound(targetPosition.x, targetPosition.y, targetPosition.z, (SoundEvent)sound.value(), SoundSource.BLOCKS, volume, pitch, true);
    }
}

