/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.point_of_interest;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;

public class BlockScanner {
    private final Set<BlockPos> checked = new HashSet<BlockPos>();
    private final Consumer<BlockPos> blockConsumer;

    public BlockScanner(Consumer<BlockPos> blockConsumer) {
        this.blockConsumer = blockConsumer;
    }

    public void scanAndQualifyBlocksExposedInAirAround(BlockPos blockPos, int range) {
        if (this.checked.contains(blockPos)) {
            return;
        }
        this.checked.add(blockPos);
        int nextStepRange = range - 1;
        assert (Minecraft.getInstance().level != null);
        if (Minecraft.getInstance().level.getBlockState(blockPos).isAir() && nextStepRange >= 0) {
            this.scanAndQualifyBlocksExposedInAirAround(blockPos.north(), nextStepRange);
            this.scanAndQualifyBlocksExposedInAirAround(blockPos.south(), nextStepRange);
            this.scanAndQualifyBlocksExposedInAirAround(blockPos.west(), nextStepRange);
            this.scanAndQualifyBlocksExposedInAirAround(blockPos.east(), nextStepRange);
            this.scanAndQualifyBlocksExposedInAirAround(blockPos.above(), nextStepRange);
            this.scanAndQualifyBlocksExposedInAirAround(blockPos.below(), nextStepRange);
            return;
        }
        this.blockConsumer.accept(blockPos);
    }
}

