/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.point_of_interest;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.features.point_of_interest.POIGroup;
import org.mcaccess.minecraftaccess.utils.PlayerUtils;

public final class BuiltinBlockPOIGroups
extends Enum<BuiltinBlockPOIGroups> {
    public static final /* enum */ BuiltinBlockPOIGroups ORE = new BuiltinBlockPOIGroups(new POIGroup<BlockPos>("minecraft_access.point_of_interest.group.ore", new POIGroup.Sound(SoundEvents.ITEM_PICKUP, -5.0f), pos -> Ore.PREDICATE.test(BuiltinBlockPOIGroups.getBlockState(pos).getBlock())));
    public static final /* enum */ BuiltinBlockPOIGroups FUNCTIONAL = new BuiltinBlockPOIGroups(new POIGroup<BlockPos>("minecraft_access.point_of_interest.group.functional", new POIGroup.Sound((SoundEvent)SoundEvents.NOTE_BLOCK_BIT.value(), 2.0f), pos -> {
        Block block = BuiltinBlockPOIGroups.getBlockState(pos).getBlock();
        return block instanceof ButtonBlock || block instanceof LeverBlock || Functional.PREDICATE.test(block);
    }));
    public static final /* enum */ BuiltinBlockPOIGroups DOOR = new BuiltinBlockPOIGroups(new POIGroup<BlockPos>("minecraft_access.point_of_interest.group.door", new POIGroup.Sound((SoundEvent)SoundEvents.NOTE_BLOCK_BIT.value(), 2.0f), pos -> {
        assert (Minecraft.getInstance().level != null);
        BlockState doorState = Minecraft.getInstance().level.getBlockState(pos);
        if (doorState.getBlock() instanceof DoorBlock) {
            return doorState.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.UPPER;
        }
        return doorState.getBlock() instanceof TrapDoorBlock;
    }));
    public static final /* enum */ BuiltinBlockPOIGroups PORTAL = new BuiltinBlockPOIGroups(new POIGroup<BlockPos>("minecraft_access.point_of_interest.group.portal", pos -> {
        assert (Minecraft.getInstance().level != null);
        Block block = Minecraft.getInstance().level.getBlockState(pos).getBlock();
        return block instanceof Portal || block instanceof EndPortalFrameBlock;
    }));
    public static final /* enum */ BuiltinBlockPOIGroups LADDER = new BuiltinBlockPOIGroups(new POIGroup<BlockPos>("minecraft_access.point_of_interest.group.ladder", new POIGroup.Sound((SoundEvent)SoundEvents.NOTE_BLOCK_BIT.value(), 2.0f), pos -> {
        assert (Minecraft.getInstance().level != null);
        Block block = Minecraft.getInstance().level.getBlockState(pos).getBlock();
        return block instanceof LadderBlock;
    }));
    public static final /* enum */ BuiltinBlockPOIGroups FLUID = new BuiltinBlockPOIGroups(new POIGroup<BlockPos>("minecraft_access.point_of_interest.group.fluid", new POIGroup.Sound((SoundEvent)SoundEvents.NOTE_BLOCK_BIT.value(), 2.0f), pos -> {
        ClientLevel world = Minecraft.getInstance().level;
        boolean configEnabled = Config.getInstance().poi.blocks.detectFluidBlocks;
        assert (world != null);
        boolean isSource = world.getFluidState(pos).getAmount() == 8;
        boolean isLiquid = world.getBlockState(pos).getBlock() instanceof LiquidBlock;
        return configEnabled && isLiquid && !PlayerUtils.isInFluid() && isSource;
    }));
    public static final /* enum */ BuiltinBlockPOIGroups HAVE_INTERFACE = new BuiltinBlockPOIGroups(new POIGroup<BlockPos>("minecraft_access.point_of_interest.group.gui", new POIGroup.Sound((SoundEvent)SoundEvents.NOTE_BLOCK_BANJO.value(), 0.0f), pos -> {
        BlockState state = BuiltinBlockPOIGroups.getBlockState(pos);
        if (state.getBlock() instanceof ChestBlock) {
            ChestType chestType = (ChestType)state.getValue((Property)ChestBlock.TYPE);
            return chestType == ChestType.SINGLE || chestType == ChestType.RIGHT;
        }
        return state.getMenuProvider((Level)Minecraft.getInstance().level, pos) != null;
    }));
    public static final List<POIGroup<BlockPos>> ALL;
    public static final Function<Block[], Predicate<Block>> BLOCK_PREDICATE_BUILDER;
    public final POIGroup<BlockPos> group;
    private static final /* synthetic */ BuiltinBlockPOIGroups[] $VALUES;

    public static BuiltinBlockPOIGroups[] values() {
        return (BuiltinBlockPOIGroups[])$VALUES.clone();
    }

    public static BuiltinBlockPOIGroups valueOf(String name) {
        return Enum.valueOf(BuiltinBlockPOIGroups.class, name);
    }

    private BuiltinBlockPOIGroups(POIGroup<BlockPos> group) {
        this.group = group;
    }

    private static BlockState getBlockState(BlockPos pos) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getBlockState(pos);
    }

    private static /* synthetic */ BuiltinBlockPOIGroups[] $values() {
        return new BuiltinBlockPOIGroups[]{ORE, FUNCTIONAL, DOOR, PORTAL, LADDER, FLUID, HAVE_INTERFACE};
    }

    static {
        $VALUES = BuiltinBlockPOIGroups.$values();
        ALL = Arrays.stream(BuiltinBlockPOIGroups.values()).map(bg -> bg.group).toList();
        BLOCK_PREDICATE_BUILDER = blocks -> b -> Arrays.stream(blocks).anyMatch(valid -> valid == b);
    }

    private static final class Functional {
        private static final Block[] FUNCTION_BLOCKS = new Block[]{Blocks.PISTON, Blocks.STICKY_PISTON, Blocks.RESPAWN_ANCHOR, Blocks.BELL, Blocks.OBSERVER, Blocks.DAYLIGHT_DETECTOR, Blocks.JUKEBOX, Blocks.LODESTONE, Blocks.BEE_NEST, Blocks.COMPOSTER, Blocks.OBSERVER, Blocks.SCULK_SHRIEKER, Blocks.SCULK_CATALYST, Blocks.CALIBRATED_SCULK_SENSOR, Blocks.SCULK_SENSOR, Blocks.VAULT, Blocks.TRIAL_SPAWNER, Blocks.SPAWNER, Blocks.CREAKING_HEART};
        public static final Predicate<Block> PREDICATE = BLOCK_PREDICATE_BUILDER.apply(FUNCTION_BLOCKS);

        private Functional() {
        }
    }

    private static final class Ore {
        private static final Block[] ORE_BLOCKS = new Block[]{Blocks.DEEPSLATE_COAL_ORE, Blocks.COAL_ORE, Blocks.COPPER_ORE, Blocks.DEEPSLATE_COPPER_ORE, Blocks.DIAMOND_ORE, Blocks.DEEPSLATE_DIAMOND_ORE, Blocks.EMERALD_ORE, Blocks.DEEPSLATE_EMERALD_ORE, Blocks.GOLD_ORE, Blocks.DEEPSLATE_GOLD_ORE, Blocks.NETHER_GOLD_ORE, Blocks.IRON_ORE, Blocks.DEEPSLATE_IRON_ORE, Blocks.LAPIS_ORE, Blocks.DEEPSLATE_LAPIS_ORE, Blocks.REDSTONE_ORE, Blocks.DEEPSLATE_REDSTONE_ORE, Blocks.NETHER_QUARTZ_ORE, Blocks.ANCIENT_DEBRIS};
        public static final Predicate<Block> PREDICATE = BLOCK_PREDICATE_BUILDER.apply(ORE_BLOCKS);

        private Ore() {
        }
    }
}

