/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.point_of_interest;

import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.features.point_of_interest.BlockPos3d;
import org.mcaccess.minecraftaccess.features.point_of_interest.BuiltinEntityPOIGroups;
import org.mcaccess.minecraftaccess.features.point_of_interest.NonCubeBlockAbsolutePositions;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.mcaccess.minecraftaccess.utils.PlayerUtils;
import org.mcaccess.minecraftaccess.utils.condition.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockingHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LockingHandler.class);
    private final Minecraft client = Minecraft.getInstance();
    private Config.POI.Locking config;
    private Entity lockedOnEntity = null;
    private BlockPos3d lockedOnBlockPos = null;
    private boolean isLockedOnWhereEyeOfEnderDisappears = false;
    private Map<Property<?>, Comparable<?>> entriesOfLockedOnBlock;
    private final Interval interval = Interval.defaultDelay();
    private boolean aimAssistActive = false;
    private int lastAimAssistCue = -1;
    private int lastBowState = -1;

    LockingHandler() {
    }

    private void loadConfig() {
        this.config = Config.getInstance().poi.locking;
        this.interval.setDelay(this.config.delay, Interval.Unit.MILLISECOND);
    }

    public void tick() {
        this.loadConfig();
        if (!this.interval.isReady()) {
            return;
        }
        if (this.client.player == null) {
            return;
        }
        if (this.client.level == null) {
            return;
        }
        if (this.client.screen != null) {
            return;
        }
        this.handleLockingKeyPressing();
        if (this.isPlayerLocked()) {
            this.lookAtLockedTarget();
        }
        this.bowAimingAssist();
    }

    private void handleLockingKeyPressing() {
        boolean isLockingKeyPressed = KeyBindingsHandler.Keys.LOCKING_HANDLER_KEY.mapping.isDown();
        if (isLockingKeyPressed && this.client.hasAltDown()) {
            if (this.isPlayerLocked()) {
                this.unlock(true, true);
                this.interval.beReady();
            }
        } else if (isLockingKeyPressed) {
            assert (this.client.getCameraEntity() != null);
            if (this.client.getCameraEntity().is((Entity)this.client.player)) {
                this.relock();
            } else {
                MainClass.narrate(I18n.get((String)"minecraft_access.other.camera_locked", (Object[])new Object[0]), true);
            }
            this.interval.reset();
        } else {
            this.interval.beReady();
        }
    }

    private void lookAtLockedTarget() {
        assert (this.client.getCameraEntity() != null);
        if (!this.client.getCameraEntity().is((Entity)this.client.player)) {
            this.unlock(true, true);
            return;
        }
        if (this.lockedOnEntity != null) {
            if (this.unlockFromDeadEntity()) {
                return;
            }
            PlayerUtils.lookAt(this.lockedOnEntity);
        }
        if (this.lockedOnBlockPos != null) {
            boolean entriesOfLockedBlockNotChanged;
            if (this.unlockFromAirBlock()) {
                return;
            }
            assert (this.client.level != null);
            BlockState blockState = this.client.level.getBlockState(BlockPos.containing((Position)this.lockedOnBlockPos.getAccuratePosition()));
            if (this.unlockFromLadderIfClimbingOnIt(blockState)) {
                return;
            }
            Map entries = blockState.getValues();
            boolean bl = entriesOfLockedBlockNotChanged = entries.values() == this.entriesOfLockedOnBlock.values();
            if (entriesOfLockedBlockNotChanged || this.isLockedOnWhereEyeOfEnderDisappears) {
                assert (this.client.player != null);
                this.client.player.lookAt(EntityAnchorArgument.Anchor.EYES, this.lockedOnBlockPos.getAccuratePosition());
            } else {
                this.unlock(true, true);
            }
        }
    }

    private void bowAimingAssist() {
        List<Entity> hostileEntities;
        LocalPlayer player = this.client.player;
        if (player == null) {
            return;
        }
        if (this.config.aimAssistEnabled && !this.aimAssistActive && player.isUsingItem() && player.getUseItem().getItem() instanceof BowItem && !(hostileEntities = BuiltinEntityPOIGroups.HOSTILE.group.getItems()).isEmpty()) {
            Entity entity = hostileEntities.stream().min(Comparator.comparingDouble(arg_0 -> ((LocalPlayer)player).distanceTo(arg_0))).get();
            if (this.lockOnEntity(entity)) {
                this.aimAssistActive = true;
            }
        }
        if (!(!this.aimAssistActive || player.isUsingItem() && player.getUseItem().getItem() instanceof BowItem)) {
            this.unlock(false, true);
            this.aimAssistActive = false;
            this.lastAimAssistCue = -1;
            this.lastBowState = -1;
            return;
        }
        if (this.config.aimAssistAudioCuesEnabled && this.aimAssistActive && this.lockedOnEntity != null) {
            float bowPullingProgress = BowItem.getPowerForTime((int)player.getTicksUsingItem());
            int bowState = -1;
            if (bowPullingProgress >= 0.0f && bowPullingProgress < 0.5f) {
                bowState = 0;
            }
            if (bowPullingProgress >= 0.5f && bowPullingProgress < 1.0f) {
                bowState = 1;
            }
            if (bowPullingProgress == 1.0f) {
                bowState = 2;
            }
            Vec3 eyePosition = player.getEyePosition();
            Vec3 targetPosition = PlayerUtils.currentEntityLookingAtPosition;
            if (targetPosition != null) {
                if (PlayerUtils.isVisibleToPlayer(eyePosition, targetPosition, this.lockedOnEntity)) {
                    if (this.lastAimAssistCue != 1 || bowState != this.lastBowState) {
                        player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value(), this.config.aimAssistAudioCuesVolume, (float)bowState);
                        this.lastAimAssistCue = 1;
                    }
                } else if (this.lastAimAssistCue != 0 || bowState != this.lastBowState) {
                    player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), this.config.aimAssistAudioCuesVolume, (float)bowState);
                    this.lastAimAssistCue = 0;
                }
                this.lastBowState = bowState;
            }
        }
    }

    public boolean isPlayerLocked() {
        return this.lockedOnBlockPos != null || this.lockedOnEntity != null;
    }

    private void unlock(boolean narrate, boolean isStillValid) {
        this.lockedOnEntity = null;
        this.entriesOfLockedOnBlock = null;
        this.lockedOnBlockPos = null;
        this.isLockedOnWhereEyeOfEnderDisappears = false;
        if (!isStillValid) {
            MainClass.poiManager.objectTracker.clearCurrentObject();
        }
        if (narrate) {
            if (this.config.unlockingSound) {
                assert (this.client.player != null);
                this.client.player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASEDRUM.value(), 0.4f, 2.0f);
            } else {
                MainClass.narrate(I18n.get((String)"narrator.button.difficulty_lock.unlocked", (Object[])new Object[0]), true);
            }
        }
    }

    private void relock() {
        Object target = MainClass.poiManager.objectTracker.getCurrentObject();
        if (target == null) {
            MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.not_selected", (Object[])new Object[0]), true);
            return;
        }
        Object object = target;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Entity.class, BlockPos.class}, (Object)object2, n)) {
            case 0: {
                Entity entity = (Entity)object2;
                this.lockOnEntity(entity);
                break;
            }
            case 1: {
                BlockPos blockPos = (BlockPos)object2;
                this.lockOnBlock(blockPos);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected locking target type: " + String.valueOf(target));
            }
        }
    }

    private boolean unlockFromLadderIfClimbingOnIt(BlockState blockState) {
        if (Blocks.LADDER.equals(blockState.getBlock())) {
            assert (this.client.player != null);
            Vec3 playerPos = this.client.player.position();
            double distance = this.lockedOnBlockPos.getCenter().distanceTo(playerPos);
            if (distance <= 0.5) {
                this.unlock(true, true);
                return true;
            }
        }
        return false;
    }

    private boolean unlockFromDeadEntity() {
        if (this.lockedOnEntity instanceof EyeOfEnder) {
            this.lockOnBlock(this.lockedOnEntity.blockPosition());
            this.isLockedOnWhereEyeOfEnderDisappears = true;
        }
        if (MainClass.poiManager.objectTracker.isObjectValid(this.lockedOnEntity)) {
            return false;
        }
        this.unlock(true, false);
        return true;
    }

    private boolean unlockFromAirBlock() {
        if (MainClass.poiManager.objectTracker.isObjectValid((Object)this.lockedOnBlockPos)) {
            return false;
        }
        this.unlock(true, false);
        return true;
    }

    public boolean lockOnEntity(Entity entity) {
        if (!MainClass.poiManager.objectTracker.isObjectValid(entity)) {
            return false;
        }
        this.unlock(false, true);
        this.lockedOnEntity = entity;
        StringBuilder narration = new StringBuilder(NarrationUtils.narrateEntity(entity));
        if (Config.getInstance().poi.narrateDistance) {
            narration.append(' ').append(NarrationUtils.narrateRelativePositionOfPlayerAnd(entity.blockPosition()));
        }
        MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.locking.locked", (Object[])new Object[]{narration}), true);
        return true;
    }

    private void lockOnBlock(BlockPos position) {
        assert (this.client.level != null);
        BlockState blockState = this.client.level.getBlockState(position);
        this.entriesOfLockedOnBlock = blockState.getValues();
        Block block = blockState.getBlock();
        Objects.requireNonNull(block);
        Block block2 = block;
        int n = 0;
        Vec3 absolutePosition = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DoorBlock.class, TrapDoorBlock.class, ButtonBlock.class, LadderBlock.class, LeverBlock.class}, (Object)block2, n)) {
            case 0 -> {
                DoorBlock ignored = (DoorBlock)block2;
                yield NonCubeBlockAbsolutePositions.getDoorPos(position.getCenter());
            }
            case 1 -> {
                TrapDoorBlock ignored = (TrapDoorBlock)block2;
                yield NonCubeBlockAbsolutePositions.getTrapDoorPos(position.getCenter());
            }
            case 2 -> {
                ButtonBlock ignored = (ButtonBlock)block2;
                yield NonCubeBlockAbsolutePositions.getButtonPos(position.getCenter());
            }
            case 3 -> {
                LadderBlock ignored = (LadderBlock)block2;
                yield NonCubeBlockAbsolutePositions.getLadderPos(position.getCenter());
            }
            case 4 -> {
                LeverBlock ignored = (LeverBlock)block2;
                yield NonCubeBlockAbsolutePositions.getLeverPos(position.getCenter());
            }
            default -> position.getCenter();
        };
        this.lockedOnBlockPos = new BlockPos3d(position, absolutePosition);
        StringBuilder blockDescription = new StringBuilder(NarrationUtils.narrateBlock(this.lockedOnBlockPos, ""));
        if (Config.getInstance().poi.narrateDistance) {
            blockDescription.append(' ').append(NarrationUtils.narrateRelativePositionOfPlayerAnd(this.lockedOnBlockPos));
        }
        MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.locking.locked", (Object[])new Object[]{blockDescription}), true);
    }
}

