/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.point_of_interest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.AirBlock;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.features.point_of_interest.POIGroup;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.mcaccess.minecraftaccess.utils.condition.Keystroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTracker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ObjectTracker.class);
    private final Minecraft client = Minecraft.getInstance();
    public static final String START_OF_LIST = "minecraft_access.other.start_of_list";
    public static final String END_OF_LIST = "minecraft_access.other.end_of_list";
    private final Keystroke nextItemKeyPressed = new Keystroke(() -> KeyBindingsHandler.Keys.OBJECT_TRACKER_NEXT_ITEM.mapping.isDown(), Keystroke.TriggeredAt.PRESSED);
    private final Keystroke previousItemKeyPressed = new Keystroke(() -> KeyBindingsHandler.Keys.OBJECT_TRACKER_PREVIOUS_ITEM.mapping.isDown(), Keystroke.TriggeredAt.PRESSED);
    private final Keystroke narrateCurrentObjectKeyPressed = new Keystroke(() -> KeyBindingsHandler.Keys.OBJECT_TRACKER_NARRATE_CURRENT_OBJECT.mapping.isDown(), Keystroke.TriggeredAt.PRESSED);
    private final Keystroke targetNearestObjectKeyPressed = new Keystroke(() -> KeyBindingsHandler.Keys.TARGET_NEAREST_OBJECT.mapping.isDown(), Keystroke.TriggeredAt.PRESSED);
    private Object currentObject = null;
    private POIGroup<?> currentGroup = null;
    private List<POIGroup<?>> groups = new ArrayList();

    ObjectTracker() {
    }

    private List<POIGroup<?>> getPOIGroups() {
        List<POIGroup<BlockPos>> groupList = Stream.concat(Arrays.stream(MainClass.poiManager.poiEntities.groups), Arrays.stream(MainClass.poiManager.poiBlocks.groups)).toList();
        ArrayList result = new ArrayList();
        for (POIGroup<BlockPos> group : groupList) {
            if (group.isEmpty()) continue;
            result.add(group);
        }
        return result;
    }

    public void tick() {
        if (this.client.player == null) {
            return;
        }
        if (this.client.level == null) {
            return;
        }
        if (this.client.screen != null) {
            return;
        }
        this.updateGroups();
        if (this.narrateCurrentObjectKeyPressed.canBeTriggered()) {
            this.narrateCurrentObject(true);
        }
        if (this.nextItemKeyPressed.canBeTriggered() && this.client.hasControlDown()) {
            this.moveGroup(1);
        }
        if (this.previousItemKeyPressed.canBeTriggered() && this.client.hasControlDown()) {
            this.moveGroup(-1);
        }
        if (this.nextItemKeyPressed.canBeTriggered() && !this.client.hasControlDown()) {
            this.moveObject(1);
        }
        if (this.previousItemKeyPressed.canBeTriggered() && !this.client.hasControlDown()) {
            this.moveObject(-1);
        }
        if (this.targetNearestObjectKeyPressed.canBeTriggered()) {
            this.targetNearestObject();
        }
    }

    private void updateGroups() {
        this.groups = this.getPOIGroups();
        int currentGroupIndex = this.groups.indexOf(this.currentGroup);
        if (this.currentGroup != null && this.currentGroup.isEmpty()) {
            currentGroupIndex = -1;
        }
        if (!this.groups.isEmpty() && currentGroupIndex == -1) {
            this.currentGroup = this.groups.getFirst();
        }
        if (this.groups.isEmpty() && currentGroupIndex != -1) {
            this.currentGroup = null;
        }
    }

    private void narrateCurrentObject(boolean interrupt) {
        Object narration;
        if (this.checkAndNarrateIfAllGroupsEmpty()) {
            return;
        }
        if (!this.isObjectValid(this.currentObject)) {
            this.clearCurrentObject();
            MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.not_selected", (Object[])new Object[0]), true);
            return;
        }
        boolean narrateDistance = Config.getInstance().poi.narrateDistance;
        Object object = this.currentObject;
        if (object instanceof Entity) {
            Entity entity = (Entity)object;
            narration = new StringBuilder(NarrationUtils.narrateEntity(entity));
            if (narrateDistance) {
                ((StringBuilder)narration).append(' ').append(NarrationUtils.narrateRelativePositionOfPlayerAnd(entity.blockPosition()));
            }
            MainClass.narrate(((StringBuilder)narration).toString(), interrupt);
            assert (this.client.level != null);
            this.client.level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), SoundSource.BLOCKS, 1.0f, 1.0f, true);
            return;
        }
        narration = this.currentObject;
        if (narration instanceof BlockPos) {
            BlockPos blockPos = (BlockPos)narration;
            narration = new StringBuilder(NarrationUtils.narrateBlock(blockPos, null));
            if (narrateDistance) {
                ((StringBuilder)narration).append(' ').append(NarrationUtils.narrateRelativePositionOfPlayerAnd(blockPos));
            }
            MainClass.narrate(((StringBuilder)narration).toString(), interrupt);
            assert (this.client.level != null);
            this.client.level.playLocalSound(blockPos, (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
    }

    private void moveGroup(int step) {
        if (this.checkAndNarrateIfAllGroupsEmpty()) {
            return;
        }
        int currentGroupIndex = this.groups.indexOf(this.currentGroup);
        int newIndex = currentGroupIndex + step;
        boolean atBoundary = false;
        if (newIndex < 0) {
            newIndex = 0;
            atBoundary = true;
            MainClass.narrate(I18n.get((String)START_OF_LIST, (Object[])new Object[0]), true);
        } else if (newIndex >= this.groups.size()) {
            newIndex = this.groups.size() - 1;
            atBoundary = true;
            MainClass.narrate(I18n.get((String)END_OF_LIST, (Object[])new Object[0]), true);
        }
        POIGroup<?> nextGroup = this.groups.get(newIndex);
        while ((nextGroup.isEmpty() || nextGroup.sortByDistance().stream().noneMatch(this::isObjectValid)) && newIndex + step >= 0 && newIndex + step < this.groups.size()) {
            nextGroup = this.groups.get(newIndex += step);
        }
        if (nextGroup.isEmpty() || nextGroup.sortByDistance().stream().noneMatch(this::isObjectValid)) {
            MainClass.narrate(I18n.get((String)(step > 0 ? END_OF_LIST : START_OF_LIST), (Object[])new Object[0]), true);
            return;
        }
        this.currentGroup = nextGroup;
        List<Object> validObjects = this.currentGroup.sortByDistance().stream().filter(this::isObjectValid).toList();
        if (validObjects.isEmpty()) {
            this.clearCurrentObject();
            MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.not_selected", (Object[])new Object[0]), true);
            return;
        }
        this.currentObject = validObjects.getFirst();
        if (!atBoundary) {
            MainClass.narrate(this.currentGroup.getTranslatedName(), true);
        } else {
            MainClass.narrate(this.currentGroup.getTranslatedName(), false);
        }
        this.narrateCurrentObject(false);
    }

    public boolean isObjectValid(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Entity) {
            Entity entity = (Entity)object;
            return entity.isAlive();
        }
        if (object instanceof BlockPos) {
            BlockPos pos = (BlockPos)object;
            if (this.client.level == null) {
                return false;
            }
            return !(this.client.level.getBlockState(pos).getBlock() instanceof AirBlock);
        }
        return false;
    }

    private void moveObject(int step) {
        List<?> objects;
        int currentObjectIndex;
        if (this.checkAndNarrateIfAllGroupsEmpty()) {
            return;
        }
        if (this.currentGroup != null && this.currentGroup.isEmpty()) {
            this.clearCurrentObject();
        }
        if ((currentObjectIndex = (objects = this.currentGroup.sortByDistance()).indexOf(this.currentObject)) == -1) {
            MainClass.narrate(I18n.get((String)START_OF_LIST, (Object[])new Object[0]), true);
            this.currentObject = objects.getFirst();
        } else {
            int newIndex = currentObjectIndex + step;
            if (newIndex < 0) {
                MainClass.narrate(I18n.get((String)START_OF_LIST, (Object[])new Object[0]), true);
                this.currentObject = objects.getFirst();
            } else if (newIndex >= objects.size()) {
                MainClass.narrate(I18n.get((String)END_OF_LIST, (Object[])new Object[0]), true);
                this.currentObject = objects.getLast();
            } else {
                this.currentObject = objects.get(newIndex);
            }
        }
        while (!this.isObjectValid(this.currentObject)) {
            int nextIndex = objects.indexOf(this.currentObject) + step;
            if (nextIndex < 0 || nextIndex >= objects.size()) {
                MainClass.narrate(I18n.get((String)(step > 0 ? END_OF_LIST : START_OF_LIST), (Object[])new Object[0]), true);
                this.clearCurrentObject();
                return;
            }
            this.currentObject = objects.get(nextIndex);
        }
        this.narrateCurrentObject(false);
    }

    private boolean checkAndNarrateIfAllGroupsEmpty() {
        if (this.groups.isEmpty()) {
            this.clearCurrentObject();
            MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.not_found", (Object[])new Object[0]), true);
            return true;
        }
        return false;
    }

    private void targetNearestObject() {
        LocalPlayer player = this.client.player;
        List<Entity> entities = MainClass.poiManager.poiEntities.getLastScanResults().stream().sorted(Comparator.comparingDouble(a -> a.distanceTo((Entity)player))).toList();
        List<BlockPos> blocks = MainClass.poiManager.poiBlocks.getLastScanResults().stream().sorted(Comparator.comparingDouble(a -> {
            assert (player != null);
            return player.getEyePosition().distanceTo(a.getCenter());
        })).toList();
        if (this.client.hasControlDown() && !this.client.hasShiftDown()) {
            if (entities.isEmpty()) {
                MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.not_found.entity", (Object[])new Object[0]), true);
            } else {
                this.currentObject = entities.getFirst();
                MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.targeting_nearest.entity", (Object[])new Object[0]), true);
            }
        } else if (this.client.hasShiftDown() && !this.client.hasControlDown()) {
            if (blocks.isEmpty()) {
                MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.not_found.block", (Object[])new Object[0]), true);
            } else {
                this.currentObject = blocks.getFirst();
                MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.targeting_nearest.block", (Object[])new Object[0]), true);
            }
        } else if (entities.isEmpty() && blocks.isEmpty()) {
            MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.not_found", (Object[])new Object[0]), true);
        } else if (entities.isEmpty()) {
            this.currentObject = blocks.getFirst();
            MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.targeting_nearest", (Object[])new Object[0]), true);
        } else if (blocks.isEmpty()) {
            this.currentObject = entities.getFirst();
            MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.targeting_nearest", (Object[])new Object[0]), true);
        } else {
            this.currentObject = player.getEyePosition().distanceTo(blocks.getFirst().getCenter()) < (double)player.distanceTo(entities.getFirst()) ? blocks.getFirst() : entities.getFirst();
            MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.targeting_nearest", (Object[])new Object[0]), true);
        }
        if (!entities.isEmpty() || !blocks.isEmpty()) {
            this.narrateCurrentObject(false);
        }
    }

    public void clearCurrentObject() {
        this.currentObject = null;
        this.updateGroups();
    }

    @Generated
    public Object getCurrentObject() {
        return this.currentObject;
    }

    @Generated
    public POIGroup<?> getCurrentGroup() {
        return this.currentGroup;
    }
}

