/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.point_of_interest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.features.point_of_interest.BlockScanner;
import org.mcaccess.minecraftaccess.features.point_of_interest.BuiltinBlockPOIGroups;
import org.mcaccess.minecraftaccess.features.point_of_interest.POIGroup;
import org.mcaccess.minecraftaccess.utils.condition.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POIBlocks {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(POIBlocks.class);
    private final Minecraft client = Minecraft.getInstance();
    private Config.POI.Blocks config;
    private final Interval interval = Interval.defaultDelay();
    @Nullable
    private Block markedBlock = null;
    private ClientLevel world;
    private final POIGroup<BlockPos> markedGroup;
    private final POIGroup<BlockPos> otherBlocksGroup;
    public final POIGroup<BlockPos>[] groups;
    private List<BlockPos> lastScanResults;

    POIBlocks() {
        this.world = this.client.level;
        this.markedGroup = new POIGroup<BlockPos>("minecraft_access.point_of_interest.group.markedBlock", new POIGroup.Sound(SoundEvents.ITEM_PICKUP, -5.0f), pos -> this.world.getBlockState(pos).is(this.markedBlock));
        this.otherBlocksGroup = new POIGroup<BlockPos>("minecraft_access.point_of_interest.group.otherBlocks", pos -> {
            BlockState state = this.world.getBlockState(pos);
            boolean blockAlreadyInGroup = this.otherBlocksGroup.getItems().stream().map(p -> this.world.getBlockState(p).getBlock()).anyMatch(t -> t.equals(state.getBlock()));
            return !state.isAir() && !blockAlreadyInGroup;
        });
        this.groups = (POIGroup[])Stream.of(List.of(this.markedGroup), BuiltinBlockPOIGroups.ALL, List.of(this.otherBlocksGroup)).flatMap(Collection::stream).toArray(POIGroup[]::new);
        this.lastScanResults = new ArrayList<BlockPos>();
        this.loadConfig();
    }

    public void tick(boolean isMarking, Block markedBlock) {
        this.setMarkedBlock(markedBlock);
        this.loadConfig();
        if (!this.config.enabled) {
            return;
        }
        if (!this.interval.isReady()) {
            return;
        }
        if (this.client.player == null) {
            return;
        }
        if (this.client.screen != null) {
            return;
        }
        log.trace("POIBlock started");
        this.scanBlocksAroundPlayer();
        this.playerSoundAtFoundPOI(isMarking);
        log.trace("POIBlock ended");
    }

    private void scanBlocksAroundPlayer() {
        ArrayList<BlockPos> currentScanResults = new ArrayList<BlockPos>();
        for (POIGroup<BlockPos> group : this.groups) {
            group.clear();
        }
        BlockScanner scanner = new BlockScanner(blockPos -> {
            for (POIGroup<BlockPos> group : this.groups) {
                if (!group.addIfQualified((BlockPos)blockPos) || group == this.otherBlocksGroup) continue;
                currentScanResults.add((BlockPos)blockPos);
                break;
            }
        });
        assert (this.client.player != null);
        BlockPos pos = this.client.player.blockPosition();
        scanner.scanAndQualifyBlocksExposedInAirAround(pos.below(), 0);
        scanner.scanAndQualifyBlocksExposedInAirAround(pos.above(2), 0);
        scanner.scanAndQualifyBlocksExposedInAirAround(pos, this.config.range);
        scanner.scanAndQualifyBlocksExposedInAirAround(pos.above(), this.config.range);
        this.lastScanResults = currentScanResults;
    }

    private void playerSoundAtFoundPOI(boolean isMarking) {
        if (this.config.volume == 0.0f) {
            return;
        }
        if (isMarking && Config.getInstance().poi.marking.suppressOtherWhenEnabled) {
            this.markedGroup.playSoundForGroupItems(BlockPos::getCenter, this.config.volume);
        } else if (this.config.playSound) {
            if (this.config.playSoundForOtherBlocks) {
                for (POIGroup<BlockPos> group : this.groups) {
                    group.playSoundForGroupItems(BlockPos::getCenter, this.config.volume);
                }
            } else {
                BuiltinBlockPOIGroups.ORE.group.playSoundForGroupItems(BlockPos::getCenter, this.config.volume);
            }
        }
    }

    private void loadConfig() {
        this.config = Config.getInstance().poi.blocks;
        this.interval.setDelay(this.config.delay, Interval.Unit.MILLISECOND);
    }

    private void setMarkedBlock(@Nullable Block block) {
        this.markedBlock = block;
    }

    @Generated
    public List<BlockPos> getLastScanResults() {
        return this.lastScanResults;
    }
}

