/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.point_of_interest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.features.point_of_interest.BuiltinEntityPOIGroups;
import org.mcaccess.minecraftaccess.features.point_of_interest.POIGroup;
import org.mcaccess.minecraftaccess.utils.condition.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POIEntities {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(POIEntities.class);
    private final Minecraft client = Minecraft.getInstance();
    private Config.POI.Entities config;
    private final Interval interval = Interval.defaultDelay();
    @Nullable
    private Class<? extends Entity> marked = null;
    private final POIGroup<Entity> markedGroup = new POIGroup<Entity>("minecraft_access.point_of_interest.group.markedEntity", new POIGroup.Sound(SoundEvents.ITEM_PICKUP, -5.0f), e -> this.marked != null && this.marked.isInstance(e));
    private final POIGroup<Entity> otherEntitiesGroup = new POIGroup<Entity>("minecraft_access.point_of_interest.group.otherEntities", entity -> true);
    final POIGroup<Entity>[] groups = (POIGroup[])Stream.of(List.of(this.markedGroup), BuiltinEntityPOIGroups.ALL, List.of(this.otherEntitiesGroup)).flatMap(Collection::stream).toArray(POIGroup[]::new);
    private List<Entity> lastScanResults = new ArrayList<Entity>();

    POIEntities() {
        this.loadConfig();
    }

    public void tick(boolean isMarking, Entity markedEntity) {
        this.setMarked(markedEntity);
        this.loadConfig();
        if (!this.config.enabled) {
            return;
        }
        if (!this.interval.isReady()) {
            return;
        }
        if (this.client.player == null) {
            return;
        }
        if (this.client.level == null) {
            return;
        }
        if (this.client.screen != null) {
            return;
        }
        log.trace("POIEntities started");
        this.scanEntitiesAroundPlayer();
        this.playerSoundAtFoundPOI(isMarking);
        log.trace("POIEntities ended");
    }

    private void scanEntitiesAroundPlayer() {
        ArrayList<Entity> currentScanResults = new ArrayList<Entity>();
        for (POIGroup<Entity> group : this.groups) {
            group.clear();
        }
        LocalPlayer player = this.client.player;
        assert (player != null);
        AABB scanBox = player.getBoundingBox().inflate((double)this.config.range, (double)this.config.range, (double)this.config.range);
        assert (this.client.level != null);
        List entities = this.client.level.getEntities((Entity)player, scanBox);
        block1: for (Entity entity : entities) {
            for (POIGroup<Entity> group : this.groups) {
                if (!group.addIfQualified(entity)) continue;
                currentScanResults.add(entity);
                continue block1;
            }
        }
        this.lastScanResults = currentScanResults;
    }

    private void playerSoundAtFoundPOI(boolean isMarking) {
        if (this.config.volume == 0.0f) {
            return;
        }
        Function<Entity, Vec3> mapper = e -> e.blockPosition().getCenter();
        if (isMarking && Config.getInstance().poi.marking.suppressOtherWhenEnabled) {
            this.markedGroup.playSoundForGroupItems(mapper, this.config.volume);
        } else if (this.config.playSound) {
            for (POIGroup<Entity> group : this.groups) {
                group.playSoundForGroupItems(mapper, this.config.volume);
            }
        }
    }

    private void loadConfig() {
        this.config = Config.getInstance().poi.entities;
        this.interval.setDelay(this.config.delay, Interval.Unit.MILLISECOND);
    }

    private void setMarked(@Nullable Entity entity) {
        this.marked = Optional.ofNullable(entity).map(Object::getClass).orElse(null);
    }

    @Generated
    public List<Entity> getLastScanResults() {
        return this.lastScanResults;
    }
}

