/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.point_of_interest;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.UnmodifiableView;
import org.mcaccess.minecraftaccess.MainClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POIGroup<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(POIGroup.class);
    private final String nameTranslateKey;
    private final Sound sound;
    private final Predicate<T> predicate;
    private final List<T> items = new ArrayList<T>();

    public POIGroup(String nameTranslateKey, Sound sound, Predicate<T> predicate) {
        this.nameTranslateKey = nameTranslateKey;
        this.sound = sound;
        this.predicate = predicate;
    }

    public POIGroup(String nameTranslateKey, Predicate<T> predicate) {
        this(nameTranslateKey, new Sound(null, 0.0f), predicate);
    }

    public String getTranslatedName() {
        return I18n.get((String)this.nameTranslateKey, (Object[])new Object[0]);
    }

    public boolean addIfQualified(T item) {
        if (!MainClass.poiManager.objectTracker.isObjectValid(item)) {
            return false;
        }
        if (this.predicate.test(item)) {
            log.debug("[{}] Add POI item [{}]", (Object)this.getTranslatedName(), item);
            this.items.add(item);
            return true;
        }
        return false;
    }

    public void clear() {
        this.items.clear();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Contract(pure=true)
    public @UnmodifiableView List<T> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public @UnmodifiableView List<T> sortByDistance() {
        ArrayList<T> result = new ArrayList<T>(this.items);
        Map<Object, Double> cache = result.stream().collect(Collectors.toMap(k -> k, this::distanceBetweenPlayerAnd));
        result.sort(Comparator.comparing(cache::get));
        return Collections.unmodifiableList(result);
    }

    private double distanceBetweenPlayerAnd(T item) {
        LocalPlayer player = Minecraft.getInstance().player;
        T t = item;
        Objects.requireNonNull(t);
        T t2 = t;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Entity.class, BlockPos.class}, t2, n)) {
            case 0 -> {
                Entity entity = (Entity)t2;
                if (!$assertionsDisabled && player == null) {
                    throw new AssertionError();
                }
                yield player.distanceTo(entity);
            }
            case 1 -> {
                BlockPos blockPos = (BlockPos)t2;
                if (!$assertionsDisabled && player == null) {
                    throw new AssertionError();
                }
                yield player.getEyePosition().distanceTo(blockPos.getCenter());
            }
            default -> Double.MAX_VALUE;
        };
    }

    public void playSoundForGroupItems(Function<T, Vec3> mapper, float volume) {
        for (T item : this.items) {
            Vec3 pos = mapper.apply(item);
            this.sound.play(pos, volume);
        }
    }

    public record Sound(SoundEvent sound, float pitch) {
        static Logger log = LoggerFactory.getLogger(Sound.class);

        public void play(Vec3 pos, float volume) {
            if (this.sound == null) {
                return;
            }
            log.debug("Play POI sound [{}] at [x:{} y:{} z{}]", new Object[]{this.sound, pos.x, pos.y, pos.z});
            assert (Minecraft.getInstance().level != null);
            Minecraft.getInstance().level.playLocalSound(pos.x, pos.y, pos.z, this.sound, SoundSource.BLOCKS, volume, this.pitch, true);
        }
    }
}

