/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.point_of_interest;

import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;

public class POIMarking {
    private boolean isMarked = false;
    private Entity markedEntity = null;
    private Block markedBlock = null;

    public void tick() {
        if (Config.getInstance().poi.marking.enabled) {
            boolean controlPressed = Minecraft.getInstance().hasControlDown();
            boolean altPressed = Minecraft.getInstance().hasAltDown();
            boolean lockingKeyPressed = KeyBindingsHandler.Keys.LOCKING_HANDLER_KEY.mapping.isDown();
            if (lockingKeyPressed && altPressed && controlPressed) {
                this.unmark();
            } else if (controlPressed && lockingKeyPressed) {
                this.mark();
            }
        } else {
            this.unmark();
        }
    }

    private void mark() {
        if (this.isMarked) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        HitResult hit = client.hitResult;
        if (hit == null) {
            return;
        }
        switch (hit.getType()) {
            case MISS: {
                return;
            }
            case BLOCK: {
                ClientLevel world = client.level;
                if (world == null) {
                    return;
                }
                BlockPos pos = ((BlockHitResult)hit).getBlockPos();
                this.markedBlock = world.getBlockState(pos).getBlock();
                String name = NarrationUtils.narrateBlock(pos, "");
                MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.marking.marked", (Object[])new Object[]{name}), true);
                break;
            }
            case ENTITY: {
                Entity e;
                this.markedEntity = e = ((EntityHitResult)hit).getEntity();
                String name = NarrationUtils.narrateEntity(e);
                MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.marking.marked", (Object[])new Object[]{name}), true);
            }
        }
        this.isMarked = true;
    }

    private void unmark() {
        if (!this.isMarked) {
            return;
        }
        this.markedBlock = null;
        this.markedEntity = null;
        this.isMarked = false;
        MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.marking.unmarked", (Object[])new Object[0]), true);
    }

    @Generated
    public boolean isMarked() {
        return this.isMarked;
    }

    @Generated
    public Entity getMarkedEntity() {
        return this.markedEntity;
    }

    @Generated
    public Block getMarkedBlock() {
        return this.markedBlock;
    }
}

