/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.mixin;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.List;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.resources.language.I18n;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.mixin.ChatComponentAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatScreen.class})
abstract class ChatScreenMixin {
    @Unique
    private static int currentChatMessagePage;
    @Shadow
    protected EditBox input;

    ChatScreenMixin() {
    }

    @Inject(at={@At(value="HEAD")}, method={"init()V"})
    private void init(CallbackInfo ci) {
        currentChatMessagePage = 0;
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;getValue()Ljava/lang/String;"), method={"updateNarrationState(Lnet/minecraft/client/gui/narration/NarrationElementOutput;)V"})
    private String suppressContent(EditBox instance) {
        return "";
    }

    @Inject(at={@At(value="HEAD")}, method={"keyPressed(Lnet/minecraft/client/input/KeyEvent;)Z"}, cancellable=true)
    private void keyPressed(KeyEvent event, CallbackInfoReturnable<Boolean> cir) {
        if (!ChatScreenMixin.repeatPreviousChatMessage(event.key())) {
            return;
        }
        cir.setReturnValue((Object)true);
        cir.cancel();
    }

    @Unique
    private static boolean repeatPreviousChatMessage(int keyCode) {
        Window window = Minecraft.getInstance().getWindow();
        int numMessages = ((ChatComponentAccessor)Minecraft.getInstance().gui.getChat()).getAllMessages().size();
        int newChatMessagePage = currentChatMessagePage;
        if (Minecraft.getInstance().hasAltDown()) {
            if (InputConstants.isKeyDown((Window)window, (int)96) || InputConstants.isKeyDown((Window)window, (int)332)) {
                newChatMessagePage = Minecraft.getInstance().hasControlDown() ? numMessages / 10 : 0;
            } else if (InputConstants.isKeyDown((Window)window, (int)61) || InputConstants.isKeyDown((Window)window, (int)334)) {
                --newChatMessagePage;
                if (Minecraft.getInstance().hasControlDown()) {
                    newChatMessagePage -= 4;
                }
            } else if (InputConstants.isKeyDown((Window)window, (int)45) || InputConstants.isKeyDown((Window)window, (int)45)) {
                ++newChatMessagePage;
                if (Minecraft.getInstance().hasControlDown()) {
                    newChatMessagePage += 4;
                }
            }
            newChatMessagePage = Math.clamp((long)newChatMessagePage, 0, numMessages / 10);
            if (newChatMessagePage != currentChatMessagePage) {
                currentChatMessagePage = newChatMessagePage;
                MainClass.narrate(I18n.get((String)"minecraft_access.gui.chat_screen.showing_message_range", (Object[])new Object[]{newChatMessagePage * 10 + 1, (newChatMessagePage + 1) * 10}), true);
            }
            for (int i = 1; i <= 9; ++i) {
                if (keyCode != 48 + i && keyCode != 320 + i) continue;
                ChatScreenMixin.narratePreviousChatAtIndex(i + currentChatMessagePage * 10 - 1);
                return true;
            }
            if (InputConstants.isKeyDown((Window)window, (int)48) || InputConstants.isKeyDown((Window)window, (int)320)) {
                ChatScreenMixin.narratePreviousChatAtIndex(10 + currentChatMessagePage * 10 - 1);
            }
        }
        return false;
    }

    @Unique
    private static void narratePreviousChatAtIndex(int indexOffset) {
        List<GuiMessage> messages = ((ChatComponentAccessor)Minecraft.getInstance().gui.getChat()).getAllMessages();
        if (messages.size() - indexOffset <= 0) {
            return;
        }
        MainClass.narrate(messages.get(indexOffset).content().getString(), true);
    }

    @Inject(at={@At(value="TAIL")}, method={"moveInHistory(I)V"})
    private void narrateSwitchedChatHistory(CallbackInfo ci) {
        MainClass.narrate(this.input.getValue(), true);
    }
}

