/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.mixin;

import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketProcessor;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.FishingRodItem;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
abstract class ClientPacketListenerMixin
implements TickablePacketListener,
ClientGamePacketListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientPacketListenerMixin.class);
    @Shadow
    private ClientLevel level;

    ClientPacketListenerMixin() {
    }

    @Inject(at={@At(value="HEAD")}, method={"handleTakeItemEntity(Lnet/minecraft/network/protocol/game/ClientboundTakeItemEntityPacket;)V"})
    private void handleTakeItemEntity(ClientboundTakeItemEntityPacket packet, CallbackInfo ci) {
        Entity entity;
        int pId;
        int cId;
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        if (player == null) {
            return;
        }
        PacketUtils.ensureRunningOnSameThread((Packet)packet, (PacketListener)this, (PacketProcessor)client.packetProcessor());
        Config.Features config = Config.getInstance().features;
        if ((config.alwaysNarratePickedUpItems || config.fishingHarvestEnabled && player.getMainHandItem().getItem() instanceof FishingRodItem) && (cId = packet.getPlayerId()) == (pId = player.getId()) && (entity = this.level.getEntity(packet.getItemId())) instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            String name = I18n.get((String)itemEntity.getItem().getItem().getDescriptionId(), (Object[])new Object[0]);
            log.debug("Fishing harvest: {}", (Object)name);
            MainClass.narrate(I18n.get((String)"minecraft_access.other.picked_up_item", (Object[])new Object[]{name}), false);
        }
    }
}

