/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.Nullable;
import org.mcaccess.minecraftaccess.MainClass;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EditBox.class})
abstract class EditBoxMixin
extends AbstractWidget {
    @Shadow
    private String value;
    @Shadow
    private int cursorPos;
    @Shadow
    private int highlightPos;
    @Shadow
    @Nullable
    private String suggestion;

    protected EditBoxMixin(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    @Shadow
    public abstract boolean canConsumeInput();

    @Shadow
    public abstract int getWordPosition(int var1);

    @Shadow
    protected abstract int getCursorPos(int var1);

    @Shadow
    public abstract String getHighlighted();

    @Inject(method={"updateWidgetNarration(Lnet/minecraft/client/gui/narration/NarrationElementOutput;)V"}, at={@At(value="TAIL")})
    private void narrateSuggestionWhenContentIsEmpty(NarrationElementOutput output, CallbackInfo ci) {
        if (this.value.isBlank() && this.suggestion != null) {
            output.add(NarratedElementType.HINT, this.suggestion);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"charTyped(Lnet/minecraft/client/input/CharacterEvent;)Z"}, cancellable=true)
    private void charTyped(CallbackInfoReturnable<Boolean> cir) {
        if (!Minecraft.getInstance().hasAltDown()) {
            return;
        }
        cir.setReturnValue((Object)false);
        cir.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"keyPressed(Lnet/minecraft/client/input/KeyEvent;)Z"})
    private void narrateCursorHoverOverText(KeyEvent event, CallbackInfoReturnable<Boolean> cir) {
        if (!this.canConsumeInput()) {
            return;
        }
        if (Minecraft.getInstance().hasShiftDown()) {
            return;
        }
        switch (event.key()) {
            case 263: {
                if (Minecraft.getInstance().hasControlDown()) {
                    String hoveredText = this.getCursorHoverOverText(this.getWordPosition(-1));
                    MainClass.narrate(hoveredText, true);
                    break;
                }
                String hoveredText = this.getCursorHoverOverText(this.getCursorPos(-1));
                MainClass.narrate(hoveredText, true);
                break;
            }
            case 262: {
                if (Minecraft.getInstance().hasControlDown()) {
                    String hoveredText = this.getCursorHoverOverText(this.getWordPosition(1));
                    MainClass.narrate(hoveredText, true);
                    break;
                }
                String hoveredText = this.getCursorHoverOverText(this.getCursorPos(1));
                MainClass.narrate(hoveredText, true);
                break;
            }
            case 268: {
                if (!Strings.isNotEmpty((CharSequence)this.value)) break;
                MainClass.narrate(this.value.substring(0, 1), true);
                break;
            }
            case 269: {
                if (!Strings.isNotEmpty((CharSequence)this.value)) break;
                MainClass.narrate(this.value.substring(this.value.length() - 1), true);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"keyPressed(Lnet/minecraft/client/input/KeyEvent;)Z"})
    private void narrateSelectedText(CallbackInfoReturnable<Boolean> cir) {
        if (!this.canConsumeInput()) {
            return;
        }
        String selectedText = this.getHighlighted();
        if (!selectedText.isBlank()) {
            MainClass.narrate(selectedText, true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"deleteChars(I)V"})
    private void narrateErasedText(int characterOffset, CallbackInfo ci) {
        boolean allTextAreSelected;
        int cursorPos = this.getCursorPos(characterOffset);
        boolean bl = allTextAreSelected = this.highlightPos == 0;
        if (!allTextAreSelected) {
            String erasedText = this.getCursorHoverOverText(cursorPos);
            MainClass.narrate(erasedText, true);
        }
    }

    @Unique
    private String getCursorHoverOverText(int changedCursorPos) {
        int endPos;
        int currentCursorPos = this.cursorPos;
        int startPos = Math.min(changedCursorPos, currentCursorPos);
        return startPos == (endPos = Math.max(changedCursorPos, currentCursorPos)) ? "" : this.value.substring(startPos, endPos);
    }
}

