/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.mixin;

import lombok.Generated;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.level.Level;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EyeOfEnder.class})
abstract class EyeOfEnderMixin
extends Entity
implements ItemSupplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EyeOfEnderMixin.class);
    @Shadow
    private int life;

    protected EyeOfEnderMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick()V"})
    private void tick(CallbackInfo callbackInfo) {
        if (this.life != 1) {
            return;
        }
        if (!Config.getInstance().poi.locking.autoLockEyeOfEnderEntity) {
            return;
        }
        log.debug("Auto locking on eye of ender entity");
        MainClass.poiManager.lockingHandler.lockOnEntity(this);
        MainClass.narrate(I18n.get((String)"minecraft_access.point_of_interest.locking.tracking_eye_of_ender", (Object[])new Object[0]), true);
    }
}

