/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.mixin;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.mixin.ClientTextTooltipAccessor;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
abstract class GuiGraphicsMixin {
    @Unique
    private static String previous;

    GuiGraphicsMixin() {
    }

    @Inject(at={@At(value="HEAD")}, method={"setTooltipForNextFrameInternal(Lnet/minecraft/client/gui/Font;Ljava/util/List;IILnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;Lnet/minecraft/resources/ResourceLocation;Z)V"})
    private void narrateTooltip(Font font, List<ClientTooltipComponent> list, int i, int j, ClientTooltipPositioner clientTooltipPositioner, @Nullable ResourceLocation resourceLocation, boolean bl, CallbackInfo ci) {
        if (Config.getInstance().inventoryControls.enabled) {
            return;
        }
        String combined = list.stream().flatMap(component -> {
            Stream<Object> stream;
            if (component instanceof ClientTextTooltipAccessor) {
                ClientTextTooltipAccessor text = (ClientTextTooltipAccessor)component;
                stream = Stream.of(text);
            } else {
                stream = Stream.empty();
            }
            return stream;
        }).map(ClientTextTooltipAccessor::getText).map(NarrationUtils::formattedCharSequenceToString).collect(Collectors.joining("\n"));
        if (combined.equals(previous)) {
            return;
        }
        previous = combined;
        MainClass.narrate(combined, true);
    }
}

