/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.mixin;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.network.chat.Component;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
abstract class GuiMixin {
    @Shadow
    private Component title;
    @Shadow
    private Component subtitle;
    @Unique
    private String previousActionBarContent = "";

    GuiMixin() {
    }

    @Inject(at={@At(value="HEAD")}, method={"setOverlayMessage(Lnet/minecraft/network/chat/Component;Z)V"})
    private void narrateActionbar(Component message, boolean tinted, CallbackInfo ci) {
        Config config = Config.getInstance();
        if (config.features.actionBarEnabled) {
            boolean contentChanged;
            String msg = message.getString();
            boolean bl = contentChanged = !this.previousActionBarContent.equals(msg);
            if (contentChanged) {
                if (config.features.onlyNarrateActionBarUpdates) {
                    this.onlyNarrateChangedParts(msg);
                } else {
                    MainClass.narrate(msg, true);
                }
                this.previousActionBarContent = msg;
            }
        }
    }

    @Unique
    private void onlyNarrateChangedParts(String msg) {
        List<String> parts = Arrays.asList(this.splitToParts(msg));
        List<String> previousParts = Arrays.asList(this.splitToParts(this.previousActionBarContent));
        parts.removeAll(previousParts);
        String narration = String.join((CharSequence)", ", parts);
        MainClass.narrate(narration, true);
    }

    @Inject(method={"setTitle(Lnet/minecraft/network/chat/Component;)V"}, at={@At(value="TAIL")})
    private void setTitleMixin(Component title, CallbackInfo ci) {
        MainClass.narrate(title.getString(), true);
        if (this.subtitle != null) {
            MainClass.narrate(this.subtitle.getString(), false);
        }
    }

    @Inject(method={"setSubtitle(Lnet/minecraft/network/chat/Component;)V"}, at={@At(value="HEAD")})
    private void setSubtitleMixin(Component subtitle, CallbackInfo ci) {
        if (this.title != null && this.subtitle == null) {
            MainClass.narrate(subtitle.getString(), false);
        }
    }

    @Unique
    private String[] splitToParts(String msg) {
        if (msg.contains(",")) {
            return msg.split(",");
        }
        return msg.split("\\s");
    }
}

