/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.mixin;

import java.util.Map;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import org.mcaccess.minecraftaccess.mixin.I18NAccessor;
import org.mcaccess.minecraftaccess.utils.NamedFormatter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={I18n.class})
abstract class I18nMixin {
    @Unique
    private static Language enLanguage;

    I18nMixin() {
    }

    @Inject(at={@At(value="HEAD")}, method={"get(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;"}, cancellable=true)
    private static void useNamedFormatter(String key, Object[] args, CallbackInfoReturnable<String> cir) {
        if (args.length == 1 && args[0] instanceof Map) {
            Map params = (Map)args[0];
            String pattern = I18NAccessor.getLanguage().getOrDefault(key);
            String result = NamedFormatter.format(pattern, params);
            if (result.startsWith("minecraft_access")) {
                pattern = I18nMixin.getEnglishI18Nof(key);
                result = NamedFormatter.format(pattern, params);
            }
            cir.setReturnValue((Object)result);
            cir.cancel();
        }
    }

    @Unique
    private static String getEnglishI18Nof(String key) {
        if (enLanguage == null) {
            enLanguage = Language.getInstance();
        }
        return enLanguage.getOrDefault(key);
    }
}

