/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.mixin;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Collection;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import org.mcaccess.minecraftaccess.mixin.KeyMappingAccessor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={KeyMapping.class})
abstract class KeyMappingMixin {
    @Unique
    private static final Multimap<InputConstants.Key, KeyMapping> KEY_TO_BINDINGS_LIST = ArrayListMultimap.create();
    @Final
    @Shadow
    private static Map<String, KeyMapping> ALL;
    @Shadow
    protected InputConstants.Key key;

    KeyMappingMixin() {
    }

    @Inject(at={@At(value="HEAD")}, method={"click(Lcom/mojang/blaze3d/platform/InputConstants$Key;)V"}, cancellable=true)
    private static void clickMixin(InputConstants.Key key, CallbackInfo ci) {
        Collection keyBindings = KEY_TO_BINDINGS_LIST.get((Object)key);
        if (!keyBindings.isEmpty()) {
            keyBindings.forEach(kb -> {
                KeyMappingAccessor kba = (KeyMappingAccessor)kb;
                kba.setClickCount(kba.getClickCount() + 1);
            });
        }
        ci.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"set(Lcom/mojang/blaze3d/platform/InputConstants$Key;Z)V"}, cancellable=true)
    private static void setMixin(InputConstants.Key key, boolean pressed, CallbackInfo ci) {
        Collection keyBindings = KEY_TO_BINDINGS_LIST.get((Object)key);
        if (!keyBindings.isEmpty()) {
            keyBindings.forEach(kb -> kb.setDown(pressed));
        }
        ci.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"resetMapping()V"}, cancellable=true)
    private static void resetMappingMixin(CallbackInfo ci) {
        KEY_TO_BINDINGS_LIST.clear();
        for (KeyMapping keyBinding : ALL.values()) {
            KEY_TO_BINDINGS_LIST.put((Object)((KeyMappingAccessor)keyBinding).getKey(), (Object)keyBinding);
        }
        ci.cancel();
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>(Ljava/lang/String;Lcom/mojang/blaze3d/platform/InputConstants$Type;ILnet/minecraft/client/KeyMapping$Category;)V"})
    private void initMap(String name, InputConstants.Type type, int key, KeyMapping.Category category, CallbackInfo ci) {
        KEY_TO_BINDINGS_LIST.put((Object)this.key, (Object)((KeyMapping)this));
    }
}

