/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.mixin;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.mcaccess.minecraftaccess.features.EffectNarrator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin {
    LivingEntityMixin() {
    }

    @Inject(method={"onEffectUpdated(Lnet/minecraft/world/effect/MobEffectInstance;ZLnet/minecraft/world/entity/Entity;)V"}, at={@At(value="TAIL")})
    private void narrateEffectApplication(MobEffectInstance effectInstance, boolean forced, Entity entity, CallbackInfo ci) {
        if (Objects.equals(Minecraft.getInstance().player, this)) {
            EffectNarrator.narrateGained(effectInstance);
        }
    }

    @Inject(method={"onEffectAdded(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="TAIL")})
    private void narrateEffectApplication2(MobEffectInstance effectInstance, Entity entity, CallbackInfo ci) {
        if (Objects.equals(Minecraft.getInstance().player, this)) {
            EffectNarrator.narrateGained(effectInstance);
        }
    }

    @Inject(method={"removeEffectNoUpdate(Lnet/minecraft/core/Holder;)Lnet/minecraft/world/effect/MobEffectInstance;"}, at={@At(value="HEAD")})
    private void narrateEffectRemoval(Holder<MobEffect> effect, CallbackInfoReturnable<MobEffectInstance> cir) {
        if (Objects.equals(Minecraft.getInstance().player, this)) {
            EffectNarrator.narrateLost((MobEffect)effect.value());
        }
    }
}

