/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.mixin;

import net.minecraft.client.gui.screens.recipebook.RecipeButton;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.item.ItemStack;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.mixin.AbstractWidgetAccessor;
import org.mcaccess.minecraftaccess.utils.condition.Interval;
import org.mcaccess.minecraftaccess.utils.system.MouseUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeButton.class})
abstract class RecipeButtonMixin {
    @Shadow
    private RecipeCollection collection;
    @Unique
    private boolean vibratingFlag = false;
    @Unique
    private String previousItemName = "";
    @Unique
    private final Interval interval = Interval.ms(5000L);

    RecipeButtonMixin() {
    }

    @Shadow
    public abstract ItemStack getDisplayStack();

    @Inject(at={@At(value="HEAD")}, method={"updateWidgetNarration(Lnet/minecraft/client/gui/narration/NarrationElementOutput;)V"}, cancellable=true)
    private void updateWidgetNarrationsMixin(CallbackInfo callbackInfo) {
        ItemStack itemStack = this.getDisplayStack();
        String itemName = itemStack.getHoverName().getString();
        boolean sameItem = itemName.equalsIgnoreCase(this.previousItemName);
        if (!sameItem || this.interval.isReady()) {
            String craftable = this.collection.hasCraftable() ? "craftable" : "not_craftable";
            craftable = I18n.get((String)("minecraft_access.other." + craftable), (Object[])new Object[0]);
            String narration = "%s %d %s".formatted(craftable, itemStack.getCount(), itemName);
            MainClass.narrate(narration, true);
        }
        if (!sameItem) {
            this.previousItemName = itemName;
            this.interval.reset();
        }
        this.shakeTheMouse();
        callbackInfo.cancel();
    }

    @Unique
    private void shakeTheMouse() {
        int offset = this.vibratingFlag ? 12 : 13;
        int x = ((AbstractWidgetAccessor)((Object)this)).callGetX() + offset;
        int y = ((AbstractWidgetAccessor)((Object)this)).callGetY() + offset;
        MouseUtils.Coordinates p = MouseUtils.calcRealPositionOfWidget(x, y);
        MouseUtils.move(p.x(), p.y());
        this.vibratingFlag = !this.vibratingFlag;
    }
}

